/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;

public class InterfaceMaker
extends AbstractClassGenerator<Class<?>> {
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(InterfaceMaker.class.getName());
    private Map<Signature, Type[]> signatures = new HashMap<Signature, Type[]>();

    public InterfaceMaker() {
        super(SOURCE);
    }

    public void add(Signature sig, Type[] exceptions) {
        this.signatures.put(sig, exceptions);
    }

    public void add(Method method) {
        this.add(ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method));
    }

    public void add(Class clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getDeclaringClass().getName().equals("java.lang.Object")) continue;
            this.add(m);
        }
    }

    public Class<?> create() {
        this.setUseCache(false);
        return (Class)super.create(this);
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        return null;
    }

    @Override
    protected Class<?> firstInstance(Class<Class<?>> type) {
        return type;
    }

    @Override
    protected Class<?> nextInstance(Class<?> instance) {
        throw new IllegalStateException("InterfaceMaker does not cache");
    }

    @Override
    public void generateClass(ClassVisitor v) throws Exception {
        ClassEmitter ce = new ClassEmitter(v);
        ce.begin_class(46, 513, this.getClassName(), null, null, "<generated>");
        for (Signature sig : this.signatures.keySet()) {
            Type[] exceptions = this.signatures.get(sig);
            ce.begin_method(1025, sig, exceptions).end_method();
        }
        ce.end_class();
    }
}

