/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array;

import com.ericsson.ere.dataset.ComplexKey;
import ericsson.vareditor.variable.array.ObjectArrayDescription;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ObjectMapModel
extends ObjectArrayModel {
    private int[] myKeyColumns = new int[0];

    public ObjectMapModel(String label, String tag, Element iterator, ObjectArrayDescription desc) {
        super(label, tag, iterator, desc);
    }

    public ObjectMapModel(String label, String tag, Element iterator, ObjectArrayDescription desc, ObjectArrayModel.DefaultValueResolver resolver) {
        super(label, tag, iterator, desc, resolver);
    }

    public ObjectMapModel(String label, String tag, List<Object[]> data, ObjectArrayDescription desc, ObjectArrayModel.DefaultValueResolver resolver) {
        super(label, tag, data, desc, resolver);
    }

    public ObjectMapModel(String label, String tag, List<Object[]> data, ObjectArrayDescription desc) {
        super(label, tag, data, desc);
    }

    protected ObjectMapModel(String label, String tag, ObjectArrayDescription desc, ObjectArrayModel.DefaultValueResolver resolver) {
        super(label, tag, desc, resolver);
    }

    @Override
    public void setUniqueColumns(int[] cols) {
        this.updateUniqueColumns(cols, this.myKeyColumns);
    }

    public void setKeyColumns(int[] keyColumns) {
        if (keyColumns == null || keyColumns.length < 1) {
            throw new IllegalArgumentException("The key index array must contain at least one index");
        }
        this.myKeyColumns = Arrays.copyOf(keyColumns, keyColumns.length);
        this.updateUniqueColumns(this.getUniqueColumns(), this.myKeyColumns);
    }

    public int[] getKeyColumns() {
        return Arrays.copyOf(this.myKeyColumns, this.myKeyColumns.length);
    }

    public Map<Object, Object> getColumnMap(int columnIndex) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (this.myKeyColumns.length > 0) {
            Object[] keyArray = this.extractKeyArray();
            Object[] valueArray = this.getColumnArray(columnIndex);
            for (int i = 0; i < keyArray.length; ++i) {
                map.put(keyArray[i], valueArray[i]);
            }
        }
        return map;
    }

    private Object[] extractKeyArray() {
        if (this.myKeyColumns.length < 2) {
            return this.getColumnArray(this.myKeyColumns[0]);
        }
        Object[] keys = new Object[this.getRowCount()];
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object[] currentKeyArray = new Object[this.myKeyColumns.length];
            for (int keyColumnIndex = 0; keyColumnIndex < this.myKeyColumns.length; ++keyColumnIndex) {
                currentKeyArray[keyColumnIndex] = this.getValueAt(row, this.myKeyColumns[keyColumnIndex]);
            }
            keys[row] = ComplexKey.createComplexKeyWithValues(currentKeyArray);
        }
        return keys;
    }

    private void updateUniqueColumns(int[] uniqueColumns, int[] keyColumns) {
        ArrayList<Integer> uniqueColumnList = new ArrayList<Integer>();
        for (int currentIndex : uniqueColumns) {
            uniqueColumnList.add(currentIndex);
        }
        for (int currentIndex : keyColumns) {
            if (uniqueColumnList.contains(currentIndex)) continue;
            uniqueColumnList.add(currentIndex);
        }
        int[] newUniqueColumnArray = new int[uniqueColumnList.size()];
        for (int i = 0; i < uniqueColumnList.size(); ++i) {
            newUniqueColumnArray[i] = (Integer)uniqueColumnList.get(i);
        }
        super.setUniqueColumns(newUniqueColumnArray);
    }
}

