/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.UnsignedInt32;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class UnsignedInt32Variable
extends AbstractNumberStringVariable {
    protected long myMinValue;
    protected long myMaxValue;

    public UnsignedInt32Variable(String label, UnsignedInt32 value) {
        super(label);
        this.myValue = value.toString();
        this.setMinMax(0L, 0xFFFFFFFFL);
    }

    public UnsignedInt32Variable(String label, String value) {
        super(label, value);
        this.setMinMax(0L, 0xFFFFFFFFL);
    }

    public UnsignedInt32Variable(String label, UnsignedInt32 value, long min, long max) {
        super(label);
        this.myValue = value.toString();
        this.setMinMax(min, max);
    }

    public UnsignedInt32Variable(String label, String value, long min, long max) {
        super(label, value);
        this.setMinMax(min, max);
    }

    public UnsignedInt32Variable(UnsignedInt32Variable v) {
        super(v);
        this.myValue = v.myValue;
        this.setMinMax(v.myMinValue, v.myMaxValue);
    }

    @Override
    public Object clone() {
        return new UnsignedInt32Variable(this);
    }

    private void setMinMax(long min, long max) {
        this.myMinValue = min < 0L ? 0L : min;
        this.myMaxValue = max < 0L ? 0L : max;
    }

    @Override
    protected String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(value)) {
            return UnsignedInt32.valueOf(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "UnsignedInt32";
    }

    public Class<UnsignedInt32> getValueClass() {
        return UnsignedInt32.class;
    }

    @Override
    public int getFormat() {
        return 2000;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new NumbersOnlyDocument(this.myMinValue, this.myMaxValue);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

