/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class ShortVariable
extends AbstractNumberStringVariable {
    protected int myMinValue;
    protected int myMaxValue;

    public ShortVariable(String label, short value) {
        super(label);
        this.myValue = String.valueOf(value);
        this.myMinValue = Short.MIN_VALUE;
        this.myMaxValue = Short.MAX_VALUE;
    }

    public ShortVariable(String label, String value) {
        super(label, value);
        this.myMinValue = Short.MIN_VALUE;
        this.myMaxValue = Short.MAX_VALUE;
    }

    public ShortVariable(String label, short value, int min, int max) {
        super(label);
        this.myValue = String.valueOf(value);
        this.myMinValue = min;
        this.myMaxValue = max;
    }

    public ShortVariable(String label, String value, int min, int max) {
        super(label, value);
        this.myMinValue = min;
        this.myMaxValue = max;
    }

    public ShortVariable(ShortVariable v) {
        super(v);
        this.myValue = v.myValue;
        this.myMinValue = v.myMinValue;
        this.myMaxValue = v.myMaxValue;
    }

    @Override
    public Object clone() {
        return new ShortVariable(this);
    }

    @Override
    protected String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        if ("-".equals(value)) {
            return value;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(value)) {
            return Short.valueOf(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "Short";
    }

    public Class<Short> getValueClass() {
        return Short.class;
    }

    @Override
    public int getFormat() {
        return 10;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new NumbersOnlyDocument(this.myMinValue, this.myMaxValue);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = String.valueOf(v);
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

