/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.vareditor.variable.TypedDropDownVariable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public class ListVariableEditor<T>
extends JPanel
implements VariableChangeListener {
    private final JList myList;

    public ListVariableEditor(boolean isEditAllowed, T[] items, TypedDropDownVariable.ItemLabeler<T> labeler, ListSelectionModel selectionModel, boolean isValid) {
        super(new BorderLayout());
        this.myList = this.createListComponent(new LabelerListModel<T>(items, labeler));
        this.myList.setSelectionModel(selectionModel);
        this.myList.setEnabled(isEditAllowed);
        this.updateEditorBackground(isValid);
        this.add((Component)new JScrollPane(this.myList), "Center");
    }

    protected JList createListComponent(ListModel model) {
        JList list = new JList(model);
        list.setVisibleRowCount(4);
        return list;
    }

    private void updateEditorBackground(boolean valid) {
        this.myList.setBackground(valid ? Color.WHITE : Color.RED);
    }

    @Override
    public void valueChanged(final VariableChangeEvent event) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ListVariableEditor.this.updateEditorBackground(event.isValueValid());
            }
        });
    }

    private static class LabelerListModel<T>
    extends AbstractListModel {
        private final T[] myItems;
        private final TypedDropDownVariable.ItemLabeler<T> myLabeler;

        LabelerListModel(T[] items, TypedDropDownVariable.ItemLabeler<T> labeler) {
            this.myItems = items;
            this.myLabeler = labeler;
        }

        @Override
        public Object getElementAt(int index) {
            return this.myLabeler.getDisplayStringFor(this.myItems[index], index);
        }

        @Override
        public int getSize() {
            return this.myItems.length;
        }
    }
}

