/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.util.StringUtil;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class IntegerVariable
extends AbstractNumberStringVariable {
    protected int myMinValue;
    protected int myMaxValue;
    protected boolean allowEmpty;

    public IntegerVariable(String label, int value) {
        super(label);
        this.myValue = String.valueOf(value);
        this.myMinValue = Integer.MIN_VALUE;
        this.myMaxValue = Integer.MAX_VALUE;
        this.allowEmpty = false;
    }

    public IntegerVariable(String label, String value) {
        super(label, value);
        this.myMinValue = Integer.MIN_VALUE;
        this.myMaxValue = Integer.MAX_VALUE;
        this.allowEmpty = false;
    }

    public IntegerVariable(String label, String value, boolean allowsEmpty) {
        super(label, value);
        this.myMinValue = Integer.MIN_VALUE;
        this.myMaxValue = Integer.MAX_VALUE;
        this.allowEmpty = allowsEmpty;
    }

    public IntegerVariable(String label, int value, int min, int max) {
        super(label);
        this.myValue = String.valueOf(value);
        this.myMinValue = min;
        this.myMaxValue = max;
        this.allowEmpty = false;
    }

    public IntegerVariable(String label, String value, int min, int max) {
        super(label, value);
        this.myMinValue = min;
        this.myMaxValue = max;
    }

    public IntegerVariable(String label, int value, int min, int max, boolean allowsEmpty) {
        super(label);
        this.myValue = String.valueOf(value);
        this.myMinValue = min;
        this.myMaxValue = max;
        this.allowEmpty = allowsEmpty;
    }

    public IntegerVariable(String label, String value, int min, int max, boolean allowEmptyValue) {
        super(label, value);
        this.myMinValue = min;
        this.myMaxValue = max;
        this.allowEmpty = allowEmptyValue;
    }

    public IntegerVariable(IntegerVariable v) {
        super(v);
        this.myValue = v.myValue;
        this.myMinValue = v.myMinValue;
        this.myMaxValue = v.myMaxValue;
    }

    @Override
    public Object clone() {
        return new IntegerVariable(this);
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.allowEmpty && StringUtil.isEmptyString(value)) {
            return "";
        }
        if (this.isValueValid(value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "Integer";
    }

    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    @Override
    public int getFormat() {
        return 5;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new NumbersOnlyDocument(this.myMinValue, this.myMaxValue, this.allowEmpty);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

