/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.swing.EDT;
import ericsson.vareditor.variable.BaseTypedDropDownVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class FilterableTypedDropDownVariable<T>
extends BaseTypedDropDownVariable<T> {
    private List<ItemContainer<T>> myItemContainers;
    private DefaultComboBoxModel myModel;
    private boolean myDontFireValueChanged;
    private ItemFilterer myFilterer;
    private JComboBox myComboBox;
    private JTextField myEditorComponent;
    private ItemContainer<T> myLastSelectedItem;
    private boolean myNeedsReset;
    private boolean myDontActOnItemSelection;
    private boolean myKeyEvent;
    protected ItemDisplayer<T> myItemDisplayer;

    public FilterableTypedDropDownVariable(String label, List<T> items) {
        this(label, items, FilterableTypedDropDownVariable.firstItemOrNull(items), null, null);
    }

    private FilterableTypedDropDownVariable(String label, List<T> items, T selected, ItemFilterer filterer, ItemDisplayer<T> itemDisplayer) {
        super(label);
        if (items == null) {
            throw new IllegalArgumentException("Items array cannot be null.");
        }
        this.myFilterer = filterer != null ? filterer : new ContainsIgnoreCaseFilterer();
        this.myItemDisplayer = itemDisplayer != null ? itemDisplayer : new DefaultItemDisplayer();
        this.setOptions(items);
        this.setSelectedItem(selected);
    }

    protected void setOptions(List<T> options) {
        this.myItemContainers = new ArrayList<ItemContainer<T>>();
        for (T item : options) {
            String displayString = this.myItemDisplayer.getDisplayStringFor(item);
            this.myItemContainers.add(new ItemContainer<T>(item, displayString));
        }
        this.myModel = new DefaultComboBoxModel<Object>(this.myItemContainers.toArray());
    }

    public boolean isEmpty() {
        return this.myModel.getSize() == 0;
    }

    @Override
    public Component getEditor() {
        if (this.myComboBox == null) {
            this.myComboBox = new JComboBox(this.myModel);
            this.myComboBox.setEditable(true);
            this.myComboBox.setRenderer(new TooltipListCellRenderer());
            ComboBoxListener comboBoxListener = new ComboBoxListener();
            this.myComboBox.addActionListener(comboBoxListener);
            this.myEditorComponent = (JTextField)this.myComboBox.getEditor().getEditorComponent();
            this.myEditorComponent.setName("FilterableTypedDropDownVariable.editorTextField");
            EditorListener editorListener = new EditorListener();
            this.myEditorComponent.addKeyListener(editorListener);
            this.myEditorComponent.addMouseListener(editorListener);
            this.setTooltipOnComboBox();
        }
        this.myComboBox.setEnabled(this.myEditIsAllowed);
        this.updateEditorBackground();
        return this.myComboBox;
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myComboBox != null;
    }

    @Override
    public T getSelectedItem() {
        ItemContainer<T> itemContainer = this.getItemContainerFromSelectedItem();
        return itemContainer != null ? (T)itemContainer.getItem() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedItem(T item) {
        ItemContainer<T> localItemContainer = null;
        for (ItemContainer<T> itemContainer : this.myItemContainers) {
            if (!itemContainer.getItem().equals(item)) continue;
            localItemContainer = itemContainer;
            break;
        }
        this.myDontActOnItemSelection = true;
        try {
            if (localItemContainer != null) {
                this.myModel.setSelectedItem(localItemContainer);
                this.myLastSelectedItem = localItemContainer;
            } else if (item != null) {
                this.setEditorText(this.myItemDisplayer.getDisplayStringFor(item));
            } else {
                this.myModel.setSelectedItem(null);
            }
        }
        finally {
            this.myDontActOnItemSelection = false;
        }
        this.updateEditorBackground();
        this.fireValueChanged();
    }

    @Override
    protected void setVarValue(Object v) {
        Object valueToSet = v;
        this.myDontFireValueChanged = true;
        try {
            this.setSelectedItem(valueToSet);
        }
        finally {
            this.myDontFireValueChanged = false;
        }
    }

    @Override
    protected void setVarValue(String v) {
        Object valueToSet = null;
        for (ItemContainer<T> item : this.myItemContainers) {
            if (!item.getDisplayString().equals(v)) continue;
            valueToSet = item.getItem();
            break;
        }
        this.setVarValue((Object)valueToSet);
    }

    @Override
    protected void fireValueChanged() {
        if (!this.myDontFireValueChanged) {
            super.fireValueChanged();
        }
    }

    @Override
    public boolean isValueValid() {
        int selectedIndex = this.myModel.getIndexOf(this.myModel.getSelectedItem());
        return selectedIndex >= 0;
    }

    @Override
    public String getValueString() {
        String valueString = "";
        T item = this.getSelectedItem();
        if (item != null) {
            valueString = this.myItemDisplayer.getDisplayStringFor(item);
        } else if (this.myEditorComponent != null) {
            valueString = this.myEditorComponent.getText();
        }
        return valueString;
    }

    @Override
    public Object clone() {
        ArrayList<T> items = new ArrayList<T>();
        for (ItemContainer<T> itemContainer : this.myItemContainers) {
            items.add(itemContainer.getItem());
        }
        FilterableTypedDropDownVariable var = new FilterableTypedDropDownVariable(this.getLabel(), items, this.getSelectedItem(), this.myFilterer, this.myItemDisplayer);
        var.setKey(this.getKey());
        return var;
    }

    public void setEditorText(String text) {
        if (text != null) {
            if (this.myEditorComponent == null) {
                this.getEditor();
            }
            this.myComboBox.setToolTipText(null);
            this.myModel.setSelectedItem(null);
            this.myEditorComponent.setText(text);
            this.updateEditorBackground();
        }
    }

    private void setTooltipOnComboBox() {
        T displayItem = this.getSelectedItem();
        String tooltip = displayItem != null ? this.myItemDisplayer.getTooltipFor(displayItem) : null;
        this.myComboBox.setToolTipText(tooltip);
    }

    private void filterList() {
        EDT.runLater(new Runnable(){

            @Override
            public void run() {
                String text = FilterableTypedDropDownVariable.this.myEditorComponent.getText();
                int caretPosition = FilterableTypedDropDownVariable.this.myEditorComponent.getCaretPosition();
                FilterableTypedDropDownVariable.this.myModel = FilterableTypedDropDownVariable.this.createModel(text);
                FilterableTypedDropDownVariable.this.myComboBox.setModel(FilterableTypedDropDownVariable.this.myModel);
                FilterableTypedDropDownVariable.this.myComboBox.setToolTipText(null);
                if (FilterableTypedDropDownVariable.this.myModel.getSize() > 0) {
                    FilterableTypedDropDownVariable.this.myComboBox.showPopup();
                }
                FilterableTypedDropDownVariable.this.myEditorComponent.setText(text);
                FilterableTypedDropDownVariable.this.myEditorComponent.setCaretPosition(caretPosition);
                FilterableTypedDropDownVariable.this.myNeedsReset = true;
                FilterableTypedDropDownVariable.this.updateEditorBackground();
            }
        });
    }

    private DefaultComboBoxModel createModel(String text) {
        Vector<ItemContainer<T>> data = new Vector<ItemContainer<T>>();
        for (ItemContainer<T> itemContainer : this.myItemContainers) {
            if (!this.myFilterer.keepObject(itemContainer.getDisplayString(), text)) continue;
            data.add(itemContainer);
        }
        return new DefaultComboBoxModel(data);
    }

    private void updateEditorFont(int style) {
        this.myEditorComponent.setFont(this.myEditorComponent.getFont().deriveFont(1 + style));
    }

    private void resetFilterAndSetSelection(ItemContainer<T> selection) {
        if (this.myNeedsReset) {
            ItemContainer<T> selectedItem = selection == null ? this.getItemContainerFromSelectedItem() : selection;
            this.myModel = new DefaultComboBoxModel<Object>(this.myItemContainers.toArray());
            this.myComboBox.setModel(this.myModel);
            this.myComboBox.setSelectedItem(selectedItem);
            this.myNeedsReset = false;
        }
        this.updateEditorBackground();
    }

    private void updateEditorBackground() {
        if (this.myComboBox != null) {
            Color col = this.isValueValid() ? UIManager.getColor("ComboBox.background") : Color.RED;
            this.myComboBox.setBackground(col);
        }
    }

    private void removeComboBoxFocus() {
        Container parent = this.myComboBox.getParent();
        if (parent != null) {
            parent.requestFocus();
        }
    }

    private boolean isSelectionValid() {
        return this.myComboBox.getSelectedIndex() >= 0;
    }

    private boolean enterPressedWithIncompleteFilter(ActionEvent e) {
        return this.myKeyEvent && !this.isSelectionValid();
    }

    private boolean selectionWhileSteppingList(ActionEvent e) {
        return this.myKeyEvent && this.isSelectionValid() && this.myComboBox.isPopupVisible();
    }

    private ItemContainer<T> getItemContainerFromSelectedItem() {
        return this.isValueValid() ? (ItemContainer)this.myModel.getSelectedItem() : null;
    }

    public static <T> FilterableTypedDropDownVariableBuilder<T> builder(String label, List<T> items) {
        return new FilterableTypedDropDownVariableBuilder(label, items);
    }

    private static <R> R firstItemOrNull(List<R> items) {
        return items != null && !items.isEmpty() ? (R)items.get(0) : null;
    }

    public static class ItemContainer<G> {
        private String myDisplayString;
        private G myItem;

        public ItemContainer(G item, String displayString) {
            this.myItem = item;
            this.myDisplayString = displayString;
        }

        public String getDisplayString() {
            return this.myDisplayString;
        }

        public G getItem() {
            return this.myItem;
        }

        public String toString() {
            return this.myDisplayString;
        }
    }

    private class EditorListener
    extends MouseAdapter
    implements KeyListener {
        private EditorListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            FilterableTypedDropDownVariable.this.myKeyEvent = true;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            FilterableTypedDropDownVariable.this.myKeyEvent = false;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char keyChar = e.getKeyChar();
            if (keyChar != '\n') {
                if (keyChar == '\u001b') {
                    FilterableTypedDropDownVariable.this.resetFilterAndSetSelection(FilterableTypedDropDownVariable.this.myLastSelectedItem);
                } else {
                    FilterableTypedDropDownVariable.this.updateEditorFont(2);
                    FilterableTypedDropDownVariable.this.filterList();
                }
            }
            FilterableTypedDropDownVariable.this.myKeyEvent = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!FilterableTypedDropDownVariable.this.myComboBox.isPopupVisible()) {
                FilterableTypedDropDownVariable.this.myEditorComponent.selectAll();
                if (FilterableTypedDropDownVariable.this.myComboBox.isShowing()) {
                    FilterableTypedDropDownVariable.this.myComboBox.showPopup();
                }
            }
        }
    }

    private class ComboBoxListener
    implements ActionListener {
        private ComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FilterableTypedDropDownVariable.this.myDontActOnItemSelection) {
                if (FilterableTypedDropDownVariable.this.isSelectionValid()) {
                    FilterableTypedDropDownVariable.this.myLastSelectedItem = FilterableTypedDropDownVariable.this.getItemContainerFromSelectedItem();
                    FilterableTypedDropDownVariable.this.updateEditorFont(0);
                }
                if (FilterableTypedDropDownVariable.this.enterPressedWithIncompleteFilter(e)) {
                    if (FilterableTypedDropDownVariable.this.myModel.getSize() > 0) {
                        FilterableTypedDropDownVariable.this.myComboBox.setSelectedIndex(0);
                    }
                    FilterableTypedDropDownVariable.this.removeComboBoxFocus();
                    FilterableTypedDropDownVariable.this.fireValueChanged();
                } else if (!FilterableTypedDropDownVariable.this.selectionWhileSteppingList(e)) {
                    FilterableTypedDropDownVariable.this.resetFilterAndSetSelection(null);
                    FilterableTypedDropDownVariable.this.removeComboBoxFocus();
                    FilterableTypedDropDownVariable.this.fireValueChanged();
                }
            }
            FilterableTypedDropDownVariable.this.setTooltipOnComboBox();
        }
    }

    private class TooltipListCellRenderer
    extends BasicComboBoxRenderer {
        private TooltipListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                list.setToolTipText(FilterableTypedDropDownVariable.this.myItemDisplayer.getTooltipFor(((ItemContainer)value).getItem()));
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class DefaultItemDisplayer<V>
    implements ItemDisplayer<V> {
        private DefaultItemDisplayer() {
        }

        @Override
        public String getDisplayStringFor(V item) {
            return String.valueOf(item);
        }

        @Override
        public String getTooltipFor(V item) {
            return null;
        }
    }

    public static interface ItemDisplayer<U> {
        public String getTooltipFor(U var1);

        public String getDisplayStringFor(U var1);
    }

    public static class FilterableTypedDropDownVariableBuilder<T> {
        private String myLabel;
        private List<T> myItems;
        private ItemFilterer myItemFilterer = null;
        private T mySelected;
        private ItemDisplayer<T> myItemDisplayer = null;

        private FilterableTypedDropDownVariableBuilder(String label, List<T> items) {
            this.myLabel = label;
            this.myItems = items;
            this.mySelected = FilterableTypedDropDownVariable.firstItemOrNull(items);
        }

        public FilterableTypedDropDownVariableBuilder<T> withItemFilterer(ItemFilterer filterer) {
            this.myItemFilterer = filterer;
            return this;
        }

        public FilterableTypedDropDownVariableBuilder<T> withSelectedItem(T selected) {
            this.mySelected = selected;
            return this;
        }

        public FilterableTypedDropDownVariableBuilder<T> withItemDisplayer(ItemDisplayer<T> itemDisplayer) {
            this.myItemDisplayer = itemDisplayer;
            return this;
        }

        public FilterableTypedDropDownVariable<T> build() {
            return new FilterableTypedDropDownVariable(this.myLabel, this.myItems, this.mySelected, this.myItemFilterer, this.myItemDisplayer);
        }
    }

    private static class ContainsIgnoreCaseFilterer
    implements ItemFilterer {
        private ContainsIgnoreCaseFilterer() {
        }

        @Override
        public boolean keepObject(String item, String filterer) {
            return item.toLowerCase().contains(filterer.toLowerCase());
        }
    }

    public static interface ItemFilterer {
        public boolean keepObject(String var1, String var2);
    }
}

