/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.bitpatternutils.BitPatternInputVariablePanel;
import java.io.PrintWriter;
import java.math.BigInteger;

public class BitPatternInputVariable
extends PanelVariable {
    public int myDataType = 0;
    private boolean isFoldable = true;

    public BitPatternInputVariable(String label, String value, int dataType) {
        super(label, new BigInteger("0"));
        this.update(value, false);
        this.myDataType = dataType;
    }

    public BitPatternInputVariable(BitPatternInputVariable var) {
        super(var);
        this.myDataType = var.myDataType;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        this.myPanelVariableEditor = this.isFoldable ? new BitPatternInputVariablePanel(this) : new BitPatternInputVariablePanel(this, false);
        return this.myPanelVariableEditor;
    }

    @Override
    protected void validate() {
    }

    @Override
    public Object clone() {
        return new BitPatternInputVariable(this);
    }

    @Override
    public Object getValueObject() {
        if (this.myValue != null) {
            if (this.myDataType == 0 || this.myDataType == 3) {
                return new Short(((BigInteger)this.myValue).shortValue());
            }
            if (this.myDataType == 1 || this.myDataType == 4) {
                return new Integer(((BigInteger)this.myValue).intValue());
            }
            return new Long(((BigInteger)this.myValue).longValue());
        }
        return super.getValueObject();
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
    }

    public void setIsFoldable(boolean foldable) {
        this.isFoldable = foldable;
    }

    public void update(Object value, boolean updateDataItem) {
        if (value instanceof BigInteger) {
            this.myValue = this.myDataType == 0 ? new BigInteger("" + ((BigInteger)value).shortValue()) : (this.myDataType == 1 ? new BigInteger("" + ((BigInteger)value).intValue()) : (this.myDataType == 2 ? new BigInteger("" + ((BigInteger)value).longValue()) : value));
        } else if (value instanceof String) {
            String valueStr = (String)value;
            if (valueStr.trim().length() == 0 || valueStr.equals("-")) {
                valueStr = "0";
            }
            this.myValue = valueStr.startsWith("-") ? (this.myDataType == 3 ? new BigInteger(Long.toBinaryString(Long.parseLong(valueStr)).substring(48), 2) : (this.myDataType == 4 ? new BigInteger(Long.toBinaryString(Long.parseLong(valueStr)).substring(32), 2) : (this.myDataType == 5 ? new BigInteger(Long.toBinaryString(Long.parseLong(valueStr)), 2) : new BigInteger(valueStr)))) : new BigInteger(valueStr);
        } else if (value instanceof Short) {
            this.myValue = this.myDataType == 3 && (Short)value < 0 ? new BigInteger(Long.toBinaryString(Long.parseLong(value.toString())).substring(48), 2) : new BigInteger(((Short)value).toString());
        } else if (value instanceof Integer) {
            this.myValue = this.myDataType == 4 && (Integer)value < 0 ? new BigInteger(Long.toBinaryString(Long.parseLong(value.toString())).substring(32), 2) : new BigInteger(((Integer)value).toString());
        } else if (value instanceof Long) {
            this.myValue = this.myDataType == 5 && (Long)value < 0L ? new BigInteger(Long.toBinaryString(Long.parseLong(value.toString())), 2) : new BigInteger(((Long)value).toString());
        } else {
            System.out.println("Unknown Object for BitPatternInputVariable");
        }
        if (this.myDataItem != null && updateDataItem) {
            this.myDataItem.setDataItem(this.getKey(), this);
        }
    }

    @Override
    protected void setVarValue(Object value) {
        this.update(value, false);
        if (this.myPanelVariableEditor != null) {
            ((BitPatternInputVariablePanel)this.myPanelVariableEditor).updateEditor();
        }
    }

    @Override
    protected void setVarValue(String value) {
        this.setVarValue((Object)value);
    }

    @Override
    public String getValueString() {
        return this.myValue.toString();
    }
}

