/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Node;

public abstract class BaseVariable
extends Variable {
    protected String myLabel;
    protected String myKey;
    protected boolean myEditIsAllowed = true;
    protected boolean myIsEdited = false;
    protected DataItem myDataItem = null;
    private String myHelpId = null;
    private boolean myHelpIdIsSet = false;
    protected boolean isSelectable = false;
    protected boolean isSelected = false;
    protected List<Object> mySelectedButtonListeners;
    private EventListenerList myEventListeners = new EventListenerList();
    private Map<Object, Object> myInfo;

    protected BaseVariable(String label) {
        this.myLabel = label;
        this.myKey = label;
    }

    protected BaseVariable(BaseVariable v) {
        this.myLabel = v.myLabel;
        this.myKey = v.myKey;
        this.myEditIsAllowed = v.myEditIsAllowed;
        this.myIsEdited = v.myIsEdited;
        this.myDataItem = v.myDataItem;
        this.myHelpId = v.myHelpId;
        this.myHelpIdIsSet = v.myHelpIdIsSet;
        if (v.myInfo != null) {
            this.myInfo = new HashMap<Object, Object>(v.myInfo);
        }
    }

    @Override
    public abstract Object clone();

    @Override
    public void setDataItem(DataItem item) {
        this.myDataItem = item;
    }

    @Override
    public void addVariableChangeListener(VariableChangeListener listener) {
        this.myEventListeners.add(VariableChangeListener.class, listener);
    }

    @Override
    public void removeVariableChangeListener(VariableChangeListener listener) {
        this.myEventListeners.remove(VariableChangeListener.class, listener);
    }

    @Override
    public boolean isModified() {
        return this.myIsEdited;
    }

    @Override
    public void resetModified() {
        this.myIsEdited = false;
    }

    @Override
    public void setModified(boolean isModified) {
        this.myIsEdited = isModified;
    }

    @Override
    public void setKey(String key) {
        this.myKey = key;
    }

    @Override
    public String getKey() {
        return this.myKey;
    }

    @Override
    public String getLabel() {
        return this.myLabel;
    }

    @Override
    public void setLabel(String l) {
        if (this.myKey.equals(this.myLabel)) {
            this.myKey = l;
        }
        this.myLabel = l;
    }

    @Override
    public abstract Object getValueObject();

    protected abstract void setVarValue(Object var1);

    protected abstract void setVarValue(String var1);

    @Override
    public final void setValue(Object v) {
        Object oldValue = this.getValueObject();
        if (this.editorHasBeenCreated()) {
            EDT.runAndWait(this.createSetVarValueRunner(v));
        } else {
            this.setVarValue(v);
        }
        this.fireValueChanged(oldValue, this.getValueObject(), this.isValueValid());
    }

    @Override
    public final void setValue(String v) {
        Object oldValue = this.getValueObject();
        if (this.editorHasBeenCreated()) {
            EDT.runAndWait(this.createSetVarValueRunner(v));
        } else {
            this.setVarValue(v);
        }
        this.fireValueChanged(oldValue, this.getValueObject(), this.isValueValid());
    }

    private Runnable createSetVarValueRunner(final Object v) {
        return new Runnable(){

            @Override
            public void run() {
                BaseVariable.this.setVarValue(v);
            }
        };
    }

    private Runnable createSetVarValueRunner(final String s) {
        return new Runnable(){

            @Override
            public void run() {
                BaseVariable.this.setVarValue(s);
            }
        };
    }

    protected void fireValueChanged() {
        if (this.myDataItem != null) {
            this.myDataItem.setDataItem(this.getKey(), this);
        }
        VariableChangeEvent event = new VariableChangeEvent(this);
        for (VariableChangeListener listener : (VariableChangeListener[])this.myEventListeners.getListeners(VariableChangeListener.class)) {
            listener.valueChanged(event);
        }
    }

    protected void fireValueChanged(Object oldValue, Object newValue, boolean isValid) {
        if (this.myDataItem != null) {
            this.myDataItem.setDataItem(this.getKey(), this);
        }
        VariableChangeEvent event = new VariableChangeEvent(this, oldValue, newValue, isValid);
        for (VariableChangeListener listener : (VariableChangeListener[])this.myEventListeners.getListeners(VariableChangeListener.class)) {
            listener.valueChanged(event);
        }
    }

    @Override
    public String getValueString() {
        return this.toString();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
    }

    @Override
    public abstract int getFormat();

    @Override
    public abstract boolean isValueValid();

    @Override
    public abstract Class<?> getValueClass();

    @Override
    public abstract String getTypename();

    @Override
    @Deprecated
    public boolean getAllowEdit() {
        return this.myEditIsAllowed;
    }

    @Override
    public boolean isAllowEdit() {
        return this.myEditIsAllowed;
    }

    @Override
    public void setAllowEdit(boolean allow) {
        this.myEditIsAllowed = allow;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isAllowEdit()) {
            Component editor = this.getEditor();
            if (editor instanceof Container) {
                GuiUtil.setContainerEnabled((Container)editor, enabled);
            } else {
                editor.setEnabled(enabled);
            }
        }
    }

    @Override
    public String toString() {
        Object o = this.getValueObject();
        return o == null ? "" : o.toString();
    }

    @Override
    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
        this.myHelpIdIsSet = true;
    }

    @Override
    public Object getModel() {
        return null;
    }

    @Override
    public abstract Component getRenderer();

    @Override
    public abstract Component getEditor();

    @Override
    public void writeXML(PrintWriter out) {
        out.print("<Variable");
        out.print(XMLUtil.wrapInAttribute("key", this.getKey()));
        out.print(XMLUtil.wrapInAttribute("label", this.getLabel()));
        out.print(XMLUtil.wrapInAttribute("format", this.getFormat()));
        out.print(XMLUtil.wrapInAttribute("selected", this.isSelected()));
        if (this.getFormat() == 4) {
            out.println(">");
            out.println(XMLUtil.escape(this.getXMLValueString()));
        } else {
            out.print(XMLUtil.wrapInAttribute("value", this.getXMLValueString()));
            out.println(">");
        }
        this.writeXMLVarSpecific(out);
        out.println("</Variable>");
    }

    protected String getXMLValueString() {
        return this.toString();
    }

    @Override
    public StringBuffer getXMLDefinition(String xmlTag) {
        StringBuffer xml = new StringBuffer(xmlTag + "=");
        xml.append('\"' + this.getValueString().trim() + '\"' + " ");
        return xml;
    }

    protected abstract void writeXMLVarSpecific(PrintWriter var1);

    public abstract void initFromXml(Node var1, String var2, String var3, int var4);

    @Override
    public void setFocusListenerForEditor(FocusListener fl) {
        this.getEditor().addFocusListener(fl);
    }

    @Override
    public Variable setSelected(boolean selected) {
        if (selected == this.isSelected) {
            return this;
        }
        this.isSelected = selected;
        this.setModified(true);
        if (this.mySelectedButtonListeners != null) {
            for (Object listener : this.mySelectedButtonListeners) {
                if (listener instanceof AbstractButton) {
                    ((AbstractButton)listener).setSelected(selected);
                    continue;
                }
                if (!(listener instanceof ChangeListener)) continue;
                ((ChangeListener)listener).stateChanged(new ChangeEvent(this));
            }
        }
        return this;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    public Component getDefaultFocusableEditor() {
        return this.getEditor();
    }

    protected void moveFocusToComponentBeforeVariableEditor() {
        Component nextComponent;
        Container parent = this.getEditor().getParent();
        FocusTraversalPolicy focusTraversalPolicy = parent.getFocusTraversalPolicy();
        if (focusTraversalPolicy != null && (nextComponent = focusTraversalPolicy.getComponentBefore(parent, this.getDefaultFocusableEditor())) != null) {
            nextComponent.requestFocusInWindow();
        }
    }

    protected void moveFocusToComponentAfterVariableEditor() {
        Component nextComponent;
        Container parent = this.getEditor().getParent();
        FocusTraversalPolicy focusTraversalPolicy = parent.getFocusTraversalPolicy();
        if (focusTraversalPolicy != null && (nextComponent = focusTraversalPolicy.getComponentAfter(parent, this.getDefaultFocusableEditor())) != null) {
            nextComponent.requestFocusInWindow();
        }
    }

    @Override
    public void addSelectedActionListener(Object listener) {
        if (this.mySelectedButtonListeners == null) {
            this.mySelectedButtonListeners = new LinkedList<Object>();
        }
        this.mySelectedButtonListeners.add(listener);
    }

    @Override
    public void editFinished() {
    }

    protected boolean editorHasBeenCreated() {
        return true;
    }

    @Override
    public <T, U extends T> void addInfo(Variable.InfoKey<T> key, U info) {
        if (this.myInfo == null) {
            this.myInfo = new HashMap<Object, Object>();
        }
        this.myInfo.put(key, info);
    }

    @Override
    public <T> T getInfo(Variable.InfoKey<T> key) {
        Object ret = null;
        if (this.myInfo != null) {
            ret = this.myInfo.get(key);
        }
        return (T)ret;
    }
}

