/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.util.ArrayEditPanelBuilder;
import com.ericsson.ere.util.DefaultRMAObjectCloner;
import com.ericsson.ere.variable.VariableProducer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.BaseVariable;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ArrayVariableBase
extends BaseVariable
implements TableModelListener {
    private ArrayModel myModel;
    private ValueResolver myValueResolver = DataType.STRING;
    private VariableProducer myVariableProducer;
    private ArrayVariable.ObjectLabeler myObjectLabeler;
    private boolean myShouldForceEditArray;
    private boolean myAllowEmpty = true;
    protected boolean myActAsSetEditor = false;

    protected ArrayVariableBase(String label, ArrayModel model) {
        super(label);
        this.setModel(model);
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
        this.modelChanged(this.myModel);
    }

    public boolean allowsEmpty() {
        return this.myAllowEmpty;
    }

    protected void setValueResolver(ValueResolver resolver) {
        ValueResolver vr;
        ValueResolver valueResolver = vr = resolver != null ? resolver : DataType.STRING;
        if (vr != this.myValueResolver) {
            this.myValueResolver = vr;
            if (this.myModel != null) {
                this.myModel.setValueResolverForValueClass(this.getValueColumnClass(), vr);
            }
        }
    }

    protected void setForceArrayEdit(boolean force) {
        this.myShouldForceEditArray = force;
    }

    protected boolean getForceArrayEdit() {
        return this.myShouldForceEditArray;
    }

    @Override
    public Class<?> getValueClass() {
        return ArrayModel.class;
    }

    public void setVariableProducer(VariableProducer producer) {
        this.myVariableProducer = producer;
    }

    public void setObjectLabeler(ArrayVariable.ObjectLabeler labeler) {
        this.myObjectLabeler = labeler;
    }

    protected ArrayVariable.ObjectLabeler getObjectLabeler() {
        return this.myObjectLabeler;
    }

    protected ValueResolver getValueResolver() {
        return this.myValueResolver;
    }

    protected VariableProducer getVariableProducer() {
        return this.myVariableProducer;
    }

    @Override
    public ArrayModel getModel() {
        return this.getArrayModel();
    }

    protected final ArrayModel getArrayModel() {
        return this.myModel;
    }

    @Override
    public boolean isValueValid() {
        return this.myAllowEmpty || this.myModel == null || this.myModel.getRowCount() > 0;
    }

    @Override
    public int getFormat() {
        return 5000;
    }

    @Override
    public String getTypename() {
        return "Array";
    }

    @Override
    protected void writeXMLVarSpecific(PrintWriter out) {
        this.getModel().writeXML(out);
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        this.setKey(key);
        Element arrayElement = XMLUtil.getFirstElementNamed("Array", (Element)node);
        if (arrayElement != null) {
            try {
                HashMap valueResolvers = new HashMap();
                valueResolvers.put(this.getValueColumnClass(), this.myValueResolver);
                ArrayModel newModel = ArrayModel.create(arrayElement, Collections.unmodifiableMap(valueResolvers));
                this.setModel(newModel);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to create model from XML.", e);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() != -1) {
            this.fireValueChanged();
        }
    }

    public void setModel(ArrayModel model) {
        if (model != this.myModel) {
            if (this.myModel != null) {
                String[] columnNames = this.myModel.getColumnNames();
                model.setColumnNames(columnNames);
                this.myModel.removeTableModelListener(this);
            }
            this.myModel = model;
            this.myModel.addTableModelListener(this);
            this.myModel.setValueResolverForValueClass(this.getValueColumnClass(), this.myValueResolver);
            this.modelChanged(this.myModel);
        }
    }

    protected void modelChanged(ArrayModel newModel) {
        this.fireValueChanged();
    }

    protected Class<?> getValueColumnClass() {
        return this.getModel().getColumnClass(1);
    }

    protected ArrayEditPanelBuilder createBuilderForEditPanel() {
        ArrayEditPanelBuilder builder = ArrayEditPanelBuilder.useModel(this.getModel()).withValueResolver(this.myValueResolver).withVariableProducer(this.myVariableProducer).withObjectLabeler(this.myObjectLabeler).forceArrayEdit(this.myShouldForceEditArray).actingAsSetEditor(this.myActAsSetEditor);
        return builder;
    }

    protected static ArrayModel cloneModel(ArrayModel model) {
        try {
            return new DefaultRMAObjectCloner().cloneObject(model);
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void actAsSetEditor(boolean actAsSetEditor) {
        this.myActAsSetEditor = actAsSetEditor;
    }
}

