/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.util.ArrayEditPanelBuilder;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.util.CloneUtil;
import com.ericsson.ere.variable.DefaultVariableProducer;
import com.ericsson.ere.variable.VariableProducer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ArrayEditDialog;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariableBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.TableModelEvent;

public class ArrayVariable
extends ArrayVariableBase {
    protected JButton myRenderer = null;
    protected ArrayEditDialog myEditor = null;
    protected Object[] myValue;
    private EditMode myEditMode = EditMode.ALLOW_EDIT;

    public ArrayVariable(String label) {
        this(label, (Object[])null);
    }

    public ArrayVariable(String label, Object[] value) {
        super(label, (ArrayModel)null);
        this.myValue = value;
    }

    public ArrayVariable(String label, Object[] value, ValueResolver valueResolver) {
        this(label, value, valueResolver, false);
    }

    ArrayVariable(String label, Object[] value, ValueResolver valueResolver, boolean forceArrayEdit) {
        this(label, value);
        this.setValueResolver(valueResolver);
        this.setForceArrayEdit(forceArrayEdit);
    }

    public ArrayVariable(String label, ArrayModel model) {
        super(label, model);
        this.myValue = model.toArray();
    }

    public ArrayVariable(String label, ArrayModel model, ValueResolver valueResolver) {
        this(label, model);
        this.setValueResolver(valueResolver);
    }

    public ArrayVariable(ArrayVariable v) {
        super(v.myLabel, (ArrayModel)null);
        try {
            this.myValue = CloneUtil.deepCopy(v.myValue);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clone the array variable value.", e);
        }
        this.setValueResolver(v.getValueResolver());
        this.myEditMode = v.myEditMode;
        this.setObjectLabeler(v.getObjectLabeler());
        this.setForceArrayEdit(v.getForceArrayEdit());
        this.setVariableProducer(this.getVariableProducer());
    }

    public void setDataType(String dataType) {
        this.setValueResolver(DataType.lookup(dataType));
    }

    public void setDataType(DataType dt) {
        this.setValueResolver(dt);
    }

    public String getDataType() {
        return this.getValueResolver().getDataType().getTypeName();
    }

    @Override
    public Object clone() {
        return new ArrayVariable(this);
    }

    @Override
    public Object getValueObject() {
        return this.myValue;
    }

    @Override
    public String getValueString() {
        return ArrayVariable.createValueString(this.getValueResolver(), this.myValue);
    }

    static String createValueString(ValueResolver resolver, Object[] value) {
        StringBuilder builder = new StringBuilder();
        for (Object o : value) {
            String escapedSemicolons = StringUtil.escapeSemicolons(resolver.makeValueString(o));
            builder.append(XMLUtil.escape(escapedSemicolons));
            builder.append(";");
        }
        return builder.toString();
    }

    @Deprecated
    public ArrayEditDialog getArrayEditDialog() {
        return this.createOrGetEditor(GuiServiceCenter.getInstance().getMainWindow());
    }

    private ArrayEditDialog createOrGetEditor(Window owner) {
        if (this.myEditor == null) {
            ArrayEditDialog editor;
            ArrayEditPanelBuilder builder = this.createBuilderForEditPanel();
            String title = this.myActAsSetEditor ? "Set" : "Array";
            title = title + " Edit for " + this.getLabel();
            this.myEditor = editor = new ArrayEditDialog(owner, title, builder);
        }
        this.myEditor.setEditMode(this.myEditMode);
        return this.myEditor;
    }

    @Override
    public Component getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new JButton();
            this.myRenderer.setName("ArrayVariable.JButton.OpenEditor");
            this.myRenderer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton src = (JButton)e.getSource();
                    Window owner = GuiUtil.getClosestWindowParent(src);
                    ArrayEditDialog editor = ArrayVariable.this.createOrGetEditor(owner);
                    editor.setLocationRelativeTo(src);
                    editor.setVisible(true);
                }
            });
            ImageIcon arrayIcon = RmaDefs.getImageIcon("new_table.gif");
            if (arrayIcon != null) {
                this.myRenderer.setIcon(arrayIcon);
            }
            this.myRenderer.setText("Table...");
        }
        return this.myRenderer;
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myRenderer != null;
    }

    @Override
    public Component getEditor() {
        return this.getRenderer();
    }

    @Override
    public ArrayModel getModel() {
        if (this.getArrayModel() == null) {
            this.setModel(new ArrayModel(this.myValue));
        }
        return super.getModel();
    }

    @Override
    protected void modelChanged(ArrayModel newModel) {
        this.myValue = newModel != null ? newModel.toArray() : new Object[]{};
        this.updateGui();
        super.modelChanged(newModel);
    }

    @Override
    protected void setVarValue(Object v) {
        if (v.getClass().isArray()) {
            this.setModel(new ArrayModel((Object[])v));
        }
    }

    @Override
    protected void setVarValue(String v) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() != -1) {
            ArrayModel sourceModel = (ArrayModel)e.getSource();
            this.myValue = sourceModel.toArray();
            this.updateGui();
            super.tableChanged(e);
        }
    }

    @Override
    public void setAllowEdit(boolean allow) {
        this.setEditMode(allow ? EditMode.ALLOW_EDIT : EditMode.READ_ONLY);
    }

    public void setEditMode(final EditMode mode) {
        super.setAllowEdit(this.myEditMode != EditMode.READ_ONLY);
        if (mode != this.myEditMode) {
            this.myEditMode = mode;
            if (this.myEditor != null) {
                EDT.runAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ArrayVariable.this.myEditor.setEditMode(mode);
                    }
                });
            }
        }
    }

    private void updateGui() {
        this.getRenderer().setForeground(this.isValueValid() ? Color.black : Color.red);
        this.myEditor = null;
    }

    @Override
    public boolean isValueValid() {
        return this.allowsEmpty() || this.getModel().getRowCount() > 0;
    }

    @Override
    protected VariableProducer getVariableProducer() {
        VariableProducer prod = super.getVariableProducer();
        return prod != null ? prod : new DefaultVariableProducer(null);
    }

    @Override
    protected ObjectLabeler getObjectLabeler() {
        ObjectLabeler labeler = super.getObjectLabeler();
        return labeler != null ? labeler : new DefaultObjectLabeler(this.getValueResolver());
    }

    public static class DefaultObjectLabeler
    implements ObjectLabeler {
        ValueResolver myValueResolver;

        public DefaultObjectLabeler(ValueResolver valueResolver) {
            this.myValueResolver = valueResolver;
        }

        @Override
        public String getDisplayStringForObject(Object o) {
            return this.myValueResolver.makeDisplayString(o);
        }
    }

    public static interface ObjectLabeler {
        public String getDisplayStringForObject(Object var1);
    }

    public static enum EditMode {
        ALLOW_EDIT,
        READ_ONLY,
        PROTECT_OLD;

    }
}

