/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.components;

import com.ericsson.charging.common.documents.FieldValidation;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.factory.DefaultAmountFactory;
import ericsson.ere.datatype.interfaces.AmountFactory;
import ericsson.ere.datatype.interfaces.ExtendedAmountFactory;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import ericsson.vareditor.documents.AmountDocument;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class AmountVariablePanel
extends AbstractPanelVariableEditor
implements DocumentListener,
FocusListener {
    private static final Color VALID_BG_COLOR = UIManager.getColor("TextField.background");
    private JTextField myBalanceInputField;
    private JComboBox myCurrencyDropDown;
    private Amount myValue;
    private int myDecimals;
    private boolean myEventsDisabled = false;
    private AmountFactory myAmountFactory;

    public AmountVariablePanel(Amount data, boolean allowNegativeInput, boolean allowZero, RatingDecimal minValue, RatingDecimal maxValue, int maxLength, int decimals, AmountFactory factory) {
        this.myValue = data;
        this.myDecimals = decimals;
        this.myAmountFactory = factory;
        AmountDocument amountDoc = new AmountDocument(allowNegativeInput, allowZero, minValue, maxValue, maxLength, decimals);
        this.buildComponent(amountDoc);
    }

    private void buildComponent(Document amountDoc) {
        String currencyString = this.myValue.getCurrency();
        String amountString = this.myValue.getBalanceString(this.myDecimals, 4);
        this.setName("AmountVariablePanel");
        AmountCurrencyDocument currencyDoc = new AmountCurrencyDocument();
        this.myCurrencyDropDown = new JComboBox<String>(this.getCurrencyCodesFromFactory(currencyString));
        this.myCurrencyDropDown.setName("AmountVariablePanel.CurrencySelector");
        this.myCurrencyDropDown.setSelectedItem(currencyString);
        ((JTextField)this.myCurrencyDropDown.getEditor().getEditorComponent()).setDocument(currencyDoc);
        this.myCurrencyDropDown.setPreferredSize(new Dimension(70, 25));
        this.myCurrencyDropDown.setEditable(true);
        this.myBalanceInputField = new JTextField();
        this.myBalanceInputField.setName("AmountVariablePanel.Balance");
        this.myBalanceInputField.setDocument(amountDoc);
        amountDoc.addDocumentListener(this);
        currencyDoc.addDocumentListener(this);
        this.myBalanceInputField.addFocusListener(this);
        this.myCurrencyDropDown.getEditor().getEditorComponent().addFocusListener(this);
        this.myBalanceInputField.setText(amountString);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myBalanceInputField, "Center");
        this.add((Component)this.myCurrencyDropDown, "East");
    }

    private String[] getCurrencyCodesFromFactory(String current) {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.myAmountFactory instanceof ExtendedAmountFactory) {
            codes.addAll(Arrays.asList(((ExtendedAmountFactory)this.myAmountFactory).getCurrencyCodes()));
        } else {
            codes.addAll(Arrays.asList(DefaultAmountFactory.getInstance().getCurrencyCodes()));
        }
        if (current != null && !codes.contains(current)) {
            codes.add(current);
        }
        return codes.toArray(new String[codes.size()]);
    }

    @Override
    public Object getEditorValue() {
        try {
            return this.myAmountFactory.create(new RatingDecimal(this.getAmountString()), this.getCurrencyString());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myBalanceInputField.setEnabled(enabled);
        this.myCurrencyDropDown.setEnabled(enabled);
    }

    public String getAmountString() {
        return this.myBalanceInputField.getText();
    }

    public String getCurrencyString() {
        JTextField theTextField = (JTextField)this.myCurrencyDropDown.getEditor().getEditorComponent();
        String strCurrency = theTextField.getText();
        return strCurrency;
    }

    @Override
    public boolean isEditorValueValid() {
        return this.isAmountValid() && this.isCurrencyValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Amount amount) {
        String currencyString = amount.getCurrency();
        String amountString = amount.getBalanceString(this.myDecimals, 4);
        try {
            this.myEventsDisabled = true;
            ((FieldValidation)((Object)this.myBalanceInputField.getDocument())).enableValidation(false);
            this.myBalanceInputField.setText(amountString);
            ((FieldValidation)((Object)this.myBalanceInputField.getDocument())).enableValidation(true);
            this.myCurrencyDropDown.setSelectedItem(currencyString);
        }
        finally {
            this.myEventsDisabled = false;
            this.updateValidStateAndFireChange();
        }
    }

    @Override
    protected void fireDataChanged() {
        if (!this.myEventsDisabled) {
            super.fireDataChanged();
        }
    }

    public void setEditorValid(boolean amountEditorIsValid, boolean currencyEditorIsValid) {
        this.myBalanceInputField.setBackground(amountEditorIsValid ? VALID_BG_COLOR : Color.RED);
        ((JTextField)this.myCurrencyDropDown.getEditor().getEditorComponent()).setBackground(currencyEditorIsValid ? VALID_BG_COLOR : Color.RED);
    }

    public void setFocusListenerForEditor(FocusListener fl) {
        this.myBalanceInputField.addFocusListener(fl);
        this.myCurrencyDropDown.addFocusListener(fl);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidStateAndFireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidStateAndFireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidStateAndFireChange();
    }

    private void updateValidStateAndFireChange() {
        this.setEditorValid(this.isAmountValid(), this.isCurrencyValid());
        this.fireDataChanged();
    }

    public boolean isCurrencyValid() {
        return this.getCurrencyString().length() == 3;
    }

    public boolean isAmountValid() {
        return ((AmountDocument)this.myBalanceInputField.getDocument()).isValid(this.getAmountString());
    }

    @Override
    public void focusGained(FocusEvent e) {
        e.getComponent().setBackground(VALID_BG_COLOR);
    }

    @Override
    public void focusLost(FocusEvent e) {
        boolean valid = true;
        if (e.getComponent() == this.myCurrencyDropDown.getEditor().getEditorComponent()) {
            valid = this.isCurrencyValid();
        } else if (e.getComponent() == this.myBalanceInputField) {
            valid = this.isAmountValid();
        }
        e.getComponent().setBackground(valid ? VALID_BG_COLOR : Color.RED);
    }

    static class AmountCurrencyDocument
    extends PlainDocument {
        private boolean myIsReplacing;

        AmountCurrencyDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            StatusPanel.getInstance().setStatusMsg("");
            String istr = str.toUpperCase(Locale.US);
            boolean validInput = istr.matches("[A-Z]+");
            if (validInput) {
                String currentText = this.getText(0, this.getLength());
                String beforeOffset = currentText.substring(0, offs);
                String afterOffset = currentText.substring(offs, currentText.length());
                String proposedResult = beforeOffset + istr + afterOffset;
                if (proposedResult.length() <= 3) {
                    super.insertString(offs, istr, a);
                } else {
                    RmaDefs.getInstance().controlledBeep();
                    StatusPanel.getInstance().setStatusMsg("Submitted value must not be more than 3 characters");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            try {
                this.myIsReplacing = true;
                super.replace(offset, length, text, attrs);
            }
            finally {
                this.myIsReplacing = false;
            }
        }

        @Override
        protected void fireRemoveUpdate(DocumentEvent e) {
            if (!this.myIsReplacing) {
                super.fireRemoveUpdate(e);
            }
        }
    }
}

