/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.util;

import com.ericsson.ere.util.Transformer;
import java.util.ArrayList;
import java.util.Iterator;

public class StringUtil {
    public static final char SLASH = '/';
    public static final char BACK_SLASH = '\\';

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    public static String convertFilePathString(String path) {
        if (path == null) {
            return "";
        }
        String systemFileSeparator = System.getProperty("file.separator");
        if (systemFileSeparator.equals("/")) {
            return path.replace('\\', '/');
        }
        if (systemFileSeparator.equals("\\")) {
            return path.replace('/', '\\');
        }
        return path;
    }

    public static int indexOfFirstDifference(String s1, String s2) {
        int len2;
        int minLen;
        if (s1 == null && s2 == null) {
            return -1;
        }
        if (s1 == null || s2 == null) {
            return 0;
        }
        int len1 = s1.length();
        int diff = minLen = len1 < (len2 = s2.length()) ? len1 : len2;
        for (int i = 0; i < minLen; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            diff = i;
            break;
        }
        return diff;
    }

    public static String toInitialCapitalCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static boolean isEmptyString(String s) {
        return s == null || s.length() == 0;
    }

    public static String repeat(String string, int num) {
        if (string == null || num == 1) {
            return string;
        }
        if (num <= 0) {
            return "";
        }
        char[] chars = new char[string.length() * num];
        int len = string.length();
        for (int i = 0; i < num; ++i) {
            string.getChars(0, len, chars, i * len);
        }
        return new String(chars);
    }

    public static void repeat(String string, int num, StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        if (string != null) {
            for (int i = 0; i < num; ++i) {
                stringBuilder.append(string);
            }
        }
    }

    public static String replaceSubString(String s, String oldToken, String newToken) {
        if (s == null || oldToken == null || newToken == null) {
            return s;
        }
        int tokenPos = s.indexOf(oldToken);
        if (tokenPos == -1) {
            return s;
        }
        String start = s.substring(0, tokenPos);
        String end = s.substring(tokenPos + oldToken.length());
        return StringUtil.replaceSubString(start + newToken + end, oldToken, newToken);
    }

    public static String multilineTooltipWrapper(String s) {
        if (s == null) {
            return null;
        }
        if (s.contains("<!DOCTYPE")) {
            return s;
        }
        String returnString = "<html>" + StringUtil.replaceSubString(s, "\n", "<p>") + "</html>";
        return returnString;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLen = suffix.length();
        int stringLen = str.length();
        if (stringLen < suffixLen) {
            return false;
        }
        return str.regionMatches(true, stringLen - suffixLen, suffix, 0, suffixLen);
    }

    public static String getDisplayStringFromCamelCaseString(String camelCase) {
        if (StringUtil.isEmptyString(camelCase)) {
            return "";
        }
        String name = camelCase;
        if (Character.isLowerCase(name.charAt(0))) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        int nameLen = name.length();
        char[] chars = new char[nameLen * 2];
        int ci = 0;
        chars[ci++] = name.charAt(0);
        boolean isUpperState = true;
        for (int i = 1; i < nameLen; ++i) {
            char cur = name.charAt(i);
            if (isUpperState) {
                if (Character.isUpperCase(cur)) {
                    chars[ci++] = cur;
                    continue;
                }
                if (ci > 1 && chars[ci - 2] != ' ') {
                    char temp = chars[ci - 1];
                    chars[ci - 1] = 32;
                    chars[ci++] = temp;
                }
                chars[ci++] = cur;
                isUpperState = false;
                continue;
            }
            if (Character.isLowerCase(cur)) {
                chars[ci++] = cur;
                continue;
            }
            chars[ci++] = 32;
            chars[ci++] = cur;
            isUpperState = true;
        }
        return new String(chars, 0, ci);
    }

    public static String join(Object[] objects, String separator) {
        String ret;
        if (objects == null || separator == null) {
            throw new IllegalArgumentException("Null argument to StringUtil.join not permitted.");
        }
        if (objects.length == 0) {
            ret = "";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(objects[0]);
            for (int i = 1; i < objects.length; ++i) {
                builder.append(separator);
                builder.append(objects[i]);
            }
            ret = builder.toString();
        }
        return ret;
    }

    public static String[] splitSemiColonSeparatedString(String valueString) {
        if (valueString == null) {
            throw new IllegalArgumentException("String to split must be non-null.");
        }
        String[] splitValues = valueString.split("(?<!\\\\);");
        for (int i = 0; i < splitValues.length; ++i) {
            splitValues[i] = splitValues[i].replace("\\;", ";");
        }
        return splitValues;
    }

    public static String[] splitWithoutRegExp(String valueString, String separator) {
        if (valueString == null || StringUtil.isEmptyString(separator)) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> list = new ArrayList<String>();
        int separatorLen = separator.length();
        int from = 0;
        int index = valueString.indexOf(separator, from);
        while (index >= 0) {
            list.add(valueString.substring(from, index));
            from = index + separatorLen;
            index = valueString.indexOf(separator, from);
        }
        list.add(valueString.substring(from));
        return list.toArray(new String[list.size()]);
    }

    public static String escapeSemicolons(String valueString) {
        if (valueString == null) {
            throw new IllegalArgumentException("String to escape must be non-null.");
        }
        return valueString.replace(";", "\\;");
    }

    public static boolean containsNullValue(String[] values) {
        boolean containsNull;
        boolean bl = containsNull = values == null;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                containsNull = true;
                break;
            }
        }
        return containsNull;
    }

    public static String buildSemiColonSeparatedString(Object[] values) {
        StringBuilder builder = new StringBuilder();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    builder.append(";");
                }
                String value = values[i].toString();
                String escaped = value.replace(";", "\\;");
                builder.append(escaped);
            }
        }
        return builder.toString();
    }

    public static String joinSequenceAsSentence(Iterable<?> parts) {
        return StringUtil.joinSequenceAsSentence(new Transformer<Object, String>(){

            @Override
            public String transform(Object input) {
                return input.toString();
            }
        }, parts);
    }

    public static <T> String joinSequenceAsSentence(Transformer<? super T, String> toString, Iterable<T> parts) {
        Iterator<T> partsIterator = parts.iterator();
        StringBuilder sentenceBuilder = new StringBuilder();
        if (partsIterator.hasNext()) {
            sentenceBuilder.append(toString.transform(partsIterator.next()));
        }
        while (partsIterator.hasNext()) {
            T part = partsIterator.next();
            if (partsIterator.hasNext()) {
                sentenceBuilder.append(", ");
            } else {
                sentenceBuilder.append(" and ");
            }
            sentenceBuilder.append(toString.transform(part));
        }
        return sentenceBuilder.toString();
    }

    public static String replaceLast(String valueString, String toReplace, String replacement) {
        int pos = valueString.lastIndexOf(toReplace);
        if (pos > -1) {
            return valueString.substring(0, pos) + replacement + valueString.substring(pos + toReplace.length(), valueString.length());
        }
        return valueString;
    }
}

