/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.ratingrules;

import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.ratingrules.CycleDetectedException;
import ericsson.ere.ratingrules.LinkHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class LinkResolver
extends LinkHandler
implements TariffStructureVisitor {
    private LinkedList<TariffStructureNode> myContext = new LinkedList();
    private List<TariffStructureNode> myResolvedLinks = new ArrayList<TariffStructureNode>();

    public LinkResolver(TariffStructureNode root) {
        this(root, null);
    }

    public LinkResolver(TariffStructureNode root, List<TariffStructureNode> currCtx) {
        super(root);
        int capacity = 200;
        if (currCtx != null) {
            capacity += currCtx.size();
        }
        if (currCtx != null) {
            this.myContext.addAll(currCtx);
        }
    }

    @Override
    public boolean resolveLink(TariffStructureNode n) throws Exception {
        boolean ret = super.resolveLink(n);
        if (ret) {
            this.myResolvedLinks.add(n);
        }
        return ret;
    }

    private void enterElement(TariffStructureNode n) throws Exception {
        boolean cycleFound = false;
        int len = this.myContext.size();
        for (int i = 0; i < len; ++i) {
            if (n != this.myContext.get(i)) continue;
            cycleFound = true;
        }
        this.myContext.addLast(n);
        if (cycleFound) {
            StringBuffer buf = new StringBuffer();
            buf.append("Illegal tariff, detected cycle at path: ");
            int len2 = this.myContext.size();
            for (int i = 0; i < len2; ++i) {
                buf.append("/");
                buf.append(this.myContext.get(i).getNodeId());
            }
            DAGNode[] cycle = this.myContext.toArray(new DAGNode[this.myContext.size()]);
            throw new CycleDetectedException(buf.toString(), cycle);
        }
    }

    private void leaveElement(TariffStructureNode n) throws Exception {
        TariffStructureNode removed = this.myContext.removeLast();
        if (removed != n) {
            String msg = "LinkResolver.leaveElement: Code fault, expected node " + n + " but got last element " + removed;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void enterTariffStructure(TariffStructureNode n) throws Exception {
        this.enterElement(n);
    }

    @Override
    public void enterNode(TariffStructureNode n) throws Exception {
        this.enterElement(n);
        if (n.isLink()) {
            this.resolveLink(n);
        }
    }

    @Override
    public void enterCondition(TariffStructureNode n) throws Exception {
        this.enterElement(n);
        if (n.isLink()) {
            this.resolveLink(n);
        }
    }

    @Override
    public void enterModifier(TariffStructureNode n) throws Exception {
        this.enterElement(n);
        if (n.isLink()) {
            this.resolveLink(n);
        }
    }

    @Override
    public void leaveTariffStructure(TariffStructureNode n) throws Exception {
        this.leaveElement(n);
    }

    @Override
    public void leaveNode(TariffStructureNode n) throws Exception {
        this.leaveElement(n);
    }

    @Override
    public void leaveCondition(TariffStructureNode n) throws Exception {
        this.leaveElement(n);
    }

    @Override
    public void leaveModifier(TariffStructureNode n) throws Exception {
        this.leaveElement(n);
    }

    public List<TariffStructureNode> getLinkHistory() {
        return this.myResolvedLinks;
    }
}

