/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import ericsson.ere.datatype.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static final String ISO_8601_FORMAT = "yyyyMMdd'T'HHmmssSSS";
    public static final String[] DATE_TEXT_FORMAT_2 = new String[]{"yyyy-MM-dd", "yyyyMMdd"};
    public static final String[] DATETIME_TEXT_FORMAT = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyyMMdd'T'HHmmssSSS", "EEE MMM dd HH:mm:ss zzz yyyy"};
    public static final String[] DATE_TEXT_FORMAT = new String[]{"yyyy-MM-dd", "yyyyMMdd", "yyyy-MM-dd HH:mm:ss", "yyyyMMdd'T'HHmmssSSS", "EEE MMM dd HH:mm:ss zzz yyyy"};
    public static final String[] TIMEOFDAY_TEXT_FORMAT = new String[]{"HH:mm:ss", "HHmmss", "HHmmssSSS", "yyyy-MM-dd HH:mm:ss", "yyyyMMdd'T'HHmmssSSS", "EEE MMM dd HH:mm:ss zzz yyyy"};

    @Deprecated
    public static String format(Calendar calendar) {
        calendar.set(14, 0);
        return DateUtil.format(calendar.getTime());
    }

    public static String formatISODateTime(Calendar cal, boolean includeMS) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dom = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        int ms = cal.get(14);
        return DateUtil.formatISODateTime(year, month, dom, hour, min, sec, ms, includeMS);
    }

    public static String formatISODateTime(Date date, boolean includeMS) {
        int year = 1900 + date.getYear();
        int month = 1 + date.getMonth();
        int dom = date.getDate();
        int hour = date.getHours();
        int min = date.getMinutes();
        int sec = date.getSeconds();
        int ms = 0;
        if (includeMS) {
            ms = (int)(date.getTime() % 1000L);
        }
        return DateUtil.formatISODateTime(year, month, dom, hour, min, sec, ms, includeMS);
    }

    public static String formatISODate(EREDate date) {
        int year = date.getFullYear();
        int month = date.getMonthOfYear();
        int dom = date.getDayOfMonth();
        return DateUtil.formatISODateTime(year, month, dom, 0, 0, 0, 0, false);
    }

    private static String formatISODateTime(int year, int month, int dom, int hour, int min, int sec, int ms, boolean includeMS) {
        StringBuilder buf = new StringBuilder(18);
        if (year < 10) {
            buf.append("000");
        } else if (year < 100) {
            buf.append("00");
        } else if (year < 1000) {
            buf.append('0');
        }
        buf.append(year);
        if (month < 10) {
            buf.append('0');
        }
        buf.append(month);
        if (dom < 10) {
            buf.append('0');
        }
        buf.append(dom);
        buf.append('T');
        if (hour == 0) {
            buf.append("00");
        } else {
            if (hour < 10) {
                buf.append('0');
            }
            buf.append(hour);
        }
        if (min == 0) {
            buf.append("00");
        } else {
            if (min < 10) {
                buf.append('0');
            }
            buf.append(min);
        }
        if (sec == 0) {
            buf.append("00");
        } else {
            if (sec < 10) {
                buf.append('0');
            }
            buf.append(sec);
        }
        if (includeMS) {
            if (ms == 0) {
                buf.append("000");
            } else {
                if (ms < 10) {
                    buf.append("00");
                } else if (ms < 100) {
                    buf.append('0');
                }
                buf.append(ms);
            }
        } else {
            buf.append("000");
        }
        return buf.toString();
    }

    public static String format(Date date) {
        return DateUtil.formatISODateTime(date, true);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setLenient(false);
        return formatter.format(date);
    }

    public static Calendar parse(String iso_string) {
        try {
            if (iso_string.length() == 18 && iso_string.charAt(8) == 'T') {
                return DateUtil.parseISODateTime(iso_string);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Wrong ISO time: " + iso_string, e);
        }
        throw new RuntimeException("Wrong ISO time: " + iso_string);
    }

    private static Calendar parseISODateTime(String iso_string) {
        String year = iso_string.substring(0, 4);
        String month = iso_string.substring(4, 6);
        String day = iso_string.substring(6, 8);
        String hour = iso_string.substring(9, 11);
        String min = iso_string.substring(11, 13);
        String sec = iso_string.substring(13, 15);
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(min), Integer.parseInt(sec));
        cal.set(14, 0);
        return cal;
    }

    public static Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar stringToCalendar(String str) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.stringToDate(str, DATETIME_TEXT_FORMAT));
        return calendar;
    }

    public static Date stringToDate(String v, String[] formats) throws ParseException {
        Date theDate = DateUtil.internalStringToDate(v, formats, Locale.getDefault());
        if (theDate == null) {
            theDate = DateUtil.internalStringToDate(v, formats, Locale.US);
        }
        if (theDate == null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            dateFormat.setLenient(true);
            theDate = dateFormat.parse(v);
        }
        return theDate;
    }

    private static Date internalStringToDate(String v, String[] formats, Locale locale) {
        Date theDate = null;
        for (String format : formats) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format, locale);
            dateFormat.setLenient(true);
            try {
                theDate = dateFormat.parse(v);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (theDate != null) break;
        }
        return theDate;
    }

    public static String format(Time time, int format) {
        if (time != null) {
            Date date = time.getCalendar().getTime();
            return DateFormat.getDateInstance(format).format(date) + " " + DateFormat.getTimeInstance(format).format(date);
        }
        return "";
    }

    public static String formatSeconds(long seconds) {
        long hour = seconds / 3600L;
        long minute = seconds / 60L - hour * 60L;
        long second = seconds - hour * 3600L - minute * 60L;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public static String formatMilliseconds(long milliseconds) {
        String prefix = DateUtil.formatSeconds(milliseconds / 1000L);
        long millisPart = milliseconds % 1000L;
        return String.format(prefix + ".%03d", millisPart);
    }

    public static void resetTimeFields(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static Calendar optimizedStringToCalendar(String str) {
        Calendar cal = null;
        try {
            if (str.length() == 8 && str.charAt(2) == ':' && str.charAt(5) == ':') {
                int hh = Integer.parseInt(str.substring(0, 2));
                int mm = Integer.parseInt(str.substring(3, 5));
                int ss = Integer.parseInt(str.substring(6));
                cal = Calendar.getInstance();
                cal.set(1970, 0, 1, hh, mm, ss);
                cal.set(14, 0);
            } else if (str.length() == 18 && str.charAt(8) == 'T') {
                cal = DateUtil.parseISODateTime(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return cal;
    }

    @Deprecated
    public static String stringToShortDate(String dateString) throws ParseException {
        return DateFormat.getDateInstance(3).format(DateUtil.stringToCalendar(dateString).getTime());
    }

    @Deprecated
    public static String stringToDateTime(String dateString) throws ParseException {
        return DateFormat.getDateTimeInstance(3, 2).format(DateUtil.stringToCalendar(dateString).getTime());
    }

    public static String convertISOStringToDateString(String dateString) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DATE_TEXT_FORMAT[0]);
        Calendar calendar = DateUtil.optimizedStringToCalendar(dateString);
        return simpleFormat.format(calendar.getTime());
    }

    public static String convertISOStringToDateTimeString(String dateString) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DATETIME_TEXT_FORMAT[0]);
        Calendar calendar = DateUtil.optimizedStringToCalendar(dateString);
        return simpleFormat.format(calendar.getTime());
    }

    public static String convertDateTimeStringToISOString(String dateTime) throws ParseException {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DATETIME_TEXT_FORMAT[0]);
        simpleFormat.setLenient(false);
        ParsePosition pp = new ParsePosition(0);
        Date date = simpleFormat.parse(dateTime, pp);
        if (pp.getIndex() != dateTime.length() || pp.getErrorIndex() != -1) {
            throw new ParseException("Invalid format on date " + dateTime, pp.getErrorIndex());
        }
        return DateUtil.format(date);
    }

    public static String convertDateStringToISOString(String dateString) throws ParseException {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DATE_TEXT_FORMAT[0]);
        simpleFormat.setLenient(false);
        ParsePosition pp = new ParsePosition(0);
        Date date = simpleFormat.parse(dateString, pp);
        if (pp.getIndex() != dateString.length() || pp.getErrorIndex() != -1) {
            throw new ParseException("Invalid format on date " + dateString, pp.getErrorIndex());
        }
        return DateUtil.format(date);
    }

    public static boolean areDatesEqual(Date first, Date second) {
        EREDate firstDate;
        if (first == null || second == null) {
            throw new IllegalArgumentException("Null date not permitted.");
        }
        boolean ret = first == second ? true : (firstDate = EREDateFactory.createFromDate(first)).compareTo(second) == 0;
        return ret;
    }
}

