/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf.multiply;

import ericsson.ere.RatingData;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OneHitMultiplyFee
extends AbstractModifier {
    String myFieldToUse = "";
    double myPricePerItem;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String nodeName = "";
        String nodeValue = "";
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                nodeName = children.item(aa).getNodeName();
                if (children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    nodeValue = value.item(bb).getNodeValue();
                }
                if (nodeName.toLowerCase().equals("Field".toLowerCase())) {
                    this.myFieldToUse = nodeValue;
                    continue;
                }
                if (!nodeName.toLowerCase().equals("Price".toLowerCase())) continue;
                this.myPricePerItem = Double.parseDouble(nodeValue);
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myFieldToUse == null ? 0 : this.myFieldToUse.hashCode());
        long temp = Double.doubleToLongBits(this.myPricePerItem);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OneHitMultiplyFee other = (OneHitMultiplyFee)obj;
        if (this.myFieldToUse == null ? other.myFieldToUse != null : !this.myFieldToUse.equals(other.myFieldToUse)) {
            return false;
        }
        return Double.doubleToLongBits(this.myPricePerItem) == Double.doubleToLongBits(other.myPricePerItem);
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        double numberOfItems = 0.0;
        double price = 0.0;
        if (theData.useTrace()) {
            theData.getTrace().println("\tOneHitMultiplyFee Trying to get field with operand '" + this.myFieldToUse + "'");
        }
        if (theData.getValueObject(this.myFieldToUse) instanceof Double) {
            numberOfItems = (Double)theData.getValueObject(this.myFieldToUse);
        } else if (theData.getValueObject(this.myFieldToUse) instanceof Integer) {
            numberOfItems = ((Integer)theData.getValueObject(this.myFieldToUse)).intValue();
        } else if (theData.getValueObject(this.myFieldToUse) instanceof Long) {
            numberOfItems = ((Long)theData.getValueObject(this.myFieldToUse)).longValue();
        } else if (theData.getValueObject(this.myFieldToUse) instanceof Short) {
            numberOfItems = ((Short)theData.getValueObject(this.myFieldToUse)).shortValue();
        } else {
            if (theData.useTrace()) {
                theData.getTrace().println("\tThe field " + this.myFieldToUse + " is not a Numeric field, ");
                theData.getTrace().println("\tNot possible to to calculate any price.");
            }
            return;
        }
        price = numberOfItems * this.myPricePerItem;
        if (theData.moneyLeft - price * theData.currentDiscount >= -1.0E-7 || theData.moneyLeft == -1.0) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tOneHitMultiplyFee cost = " + numberOfItems + " * (" + this.myPricePerItem + " * " + theData.currentDiscount + ") = " + price * theData.currentDiscount);
            }
            theCost.setValue(theCost.value + theData.allocateCost(price * theData.currentDiscount));
            theTime.setValue(theTime.value + theData.allocateTime(theData.timeLeft));
        } else {
            if (theData.useTrace()) {
                theData.getTrace().println("\tOneHitMultiplyFee Not enough money on account, value set = 0 and timeLeft = 0 ");
            }
            theTime.setValue(0L);
            theData.timeLeft = 0L;
        }
    }
}

