/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf.multiply;

import ericsson.ere.RatingData;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiplyFee
extends AbstractModifier {
    String fieldToUse = "";
    double pricePerItem;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String nodeName = "";
        String nodeValue = "";
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                nodeName = children.item(aa).getNodeName();
                if (children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    nodeValue = value.item(bb).getNodeValue();
                }
                if (nodeName.toLowerCase().equals("Field".toLowerCase())) {
                    this.fieldToUse = nodeValue;
                    continue;
                }
                if (!nodeName.toLowerCase().equals("Price".toLowerCase())) continue;
                this.pricePerItem = Double.parseDouble(nodeValue);
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.fieldToUse == null ? 0 : this.fieldToUse.hashCode());
        long temp = Double.doubleToLongBits(this.pricePerItem);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiplyFee other = (MultiplyFee)obj;
        if (this.fieldToUse == null ? other.fieldToUse != null : !this.fieldToUse.equals(other.fieldToUse)) {
            return false;
        }
        return Double.doubleToLongBits(this.pricePerItem) == Double.doubleToLongBits(other.pricePerItem);
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) {
        double numberOfItems = 0.0;
        double price = 0.0;
        if (theData.useTrace()) {
            theData.getTrace().println("\tMultiplyFee Trying to get field with operand '" + this.fieldToUse + "'");
        }
        if (theData.getValueObject(this.fieldToUse) instanceof Double) {
            numberOfItems = (Double)theData.getValueObject(this.fieldToUse);
        } else if (theData.getValueObject(this.fieldToUse) instanceof Integer) {
            numberOfItems = ((Integer)theData.getValueObject(this.fieldToUse)).intValue();
        } else if (theData.getValueObject(this.fieldToUse) instanceof Long) {
            numberOfItems = ((Long)theData.getValueObject(this.fieldToUse)).longValue();
        } else if (theData.getValueObject(this.fieldToUse) instanceof Short) {
            numberOfItems = ((Short)theData.getValueObject(this.fieldToUse)).shortValue();
        } else {
            if (theData.useTrace()) {
                theData.getTrace().println("\tThe field " + this.fieldToUse + " is not a Numeric field, ");
                theData.getTrace().println("\tNot possible to to calculate any price.");
            }
            return;
        }
        price = numberOfItems * this.pricePerItem;
        if (theData.moneyLeft - price * theData.currentDiscount >= -1.0E-7 || theData.moneyLeft == -1.0) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tMultiplyFee cost = " + numberOfItems + " * (" + this.pricePerItem + " * " + theData.currentDiscount + ") = " + price * theData.currentDiscount);
            }
            theCost.setValue(theCost.value + theData.allocateCost(price * theData.currentDiscount));
        } else {
            if (theData.useTrace()) {
                theData.getTrace().println("\tMultiplyFee Not enough money on account, value set = 0 and timeLeft = 0 ");
            }
            theTime.setValue(0L);
            theData.timeLeft = 0L;
        }
    }
}

