/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.interfaces;

import ericsson.ere.interfaces.DAGNode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractDAGNode
implements DAGNode {
    public static final DAGNode[] EMPTY_LIST = new DAGNode[0];
    private transient ArrayList<DAGNode> myReferers = null;
    protected DAGNode myParent = null;

    @Override
    public abstract DAGNode getChildAt(int var1) throws IndexOutOfBoundsException;

    @Override
    public abstract int getChildCount();

    @Override
    public abstract void insertChildAt(int var1, DAGNode var2);

    @Override
    public abstract void insertLinkAt(int var1, DAGNode var2);

    protected abstract void removeChild(DAGNode var1);

    protected abstract void removeLink(DAGNode var1);

    protected int hashCodeImpl() {
        return 31;
    }

    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public int getIndexOfChild(DAGNode node) {
        int len = this.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (node != this.getChildAt(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DAGNode getParent() {
        return this.myParent;
    }

    @Override
    public void addChild(DAGNode node) {
        this.insertChildAt(this.getChildCount(), node);
    }

    @Override
    public void addLink(DAGNode node) {
        this.insertLinkAt(this.getChildCount(), node);
    }

    @Override
    public void remove(DAGNode node) {
        if (this.getIndexOfChild(node) >= 0) {
            if (node.getParent() == this) {
                this.removeChild(node);
            } else {
                this.removeLink(node);
            }
        } else {
            throw new IllegalArgumentException("Trying to remove non-existent node: " + node + " from " + this);
        }
    }

    @Override
    public DAGNode removeAt(int index) {
        DAGNode node = this.getChildAt(index);
        this.remove(node);
        return node;
    }

    @Override
    public void setParent(DAGNode parent) {
        this.myParent = parent;
    }

    @Override
    public void addReferer(DAGNode ref) {
        if (this.myReferers == null) {
            this.myReferers = new WeakArray();
        }
        this.myReferers.add(ref);
    }

    @Override
    public void removeReferer(DAGNode ref) {
        if (this.myReferers != null) {
            this.myReferers.remove(ref);
            if (this.myReferers.isEmpty()) {
                this.myReferers = null;
            }
        }
    }

    public int getRefererCount() {
        if (this.myReferers == null) {
            return 0;
        }
        return this.myReferers.size();
    }

    @Override
    public DAGNode[] getReferers() {
        if (this.myReferers == null) {
            return EMPTY_LIST;
        }
        return ((WeakArray)this.myReferers).toDAGNodeArray();
    }

    @Override
    public void removeAllReferers() {
        if (this.myReferers != null) {
            this.myReferers = null;
        }
    }

    private static class WeakArray
    extends ArrayList<DAGNode> {
        private ArrayList<WeakReference<DAGNode>> myArray = new ArrayList();

        @Override
        public boolean isEmpty() {
            this.cleanUp();
            return this.myArray.isEmpty();
        }

        @Override
        public boolean add(DAGNode node) {
            this.cleanUp();
            return this.myArray.add(new WeakReference<DAGNode>(node));
        }

        private DAGNode[] toDAGNodeArray() {
            ArrayList<DAGNode> newList = new ArrayList<DAGNode>();
            for (WeakReference<DAGNode> ref : this.myArray) {
                DAGNode node = (DAGNode)ref.get();
                if (node == null) continue;
                newList.add(node);
            }
            return newList.toArray(new DAGNode[0]);
        }

        @Override
        public boolean remove(Object o) {
            this.cleanUp();
            for (WeakReference<DAGNode> ref : this.myArray) {
                DAGNode node = (DAGNode)ref.get();
                if (node == null || !node.equals(o)) continue;
                this.myArray.remove(ref);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            this.cleanUp();
            return this.myArray.size();
        }

        private void cleanUp() {
            Iterator<WeakReference<DAGNode>> iterator = this.myArray.iterator();
            while (iterator.hasNext()) {
                WeakReference<DAGNode> node = iterator.next();
                if (node.get() != null) continue;
                iterator.remove();
            }
        }
    }
}

