/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.util;

import com.ericsson.ere.io.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;

public class FileHandling {
    public static void writeToFile(String str, File out, String charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), charset);
        FileHandling.writeStringToWriter(str, writer);
    }

    public static void writeToFile(String str, File out) throws IOException {
        FileWriter writer = new FileWriter(out);
        FileHandling.writeStringToWriter(str, writer);
    }

    private static void writeStringToWriter(String str, Writer writer) throws IOException {
        try {
            writer.write(str);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File in, File out) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        try {
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        }
        finally {
            sourceChannel.close();
            destinationChannel.close();
        }
    }

    public static StringBuffer fileToStringBuffer(String fileName) throws IOException {
        StringBuffer buf = new StringBuffer();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8");
        IOUtil.readAllAndClose(reader, buf);
        return buf;
    }
}

