/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.ratingperiod.action;

import ericsson.ere.integration.management.EreAction;
import ericsson.ere.integration.management.ratingperiod.action.RatingPeriodAction;
import ericsson.ere.integration.management.ratingplan.action.RatingPlanAction;
import ericsson.ere.integration.management.serviceprovider.action.ServiceProviderAction;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.ServiceProvider;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RatingPeriodCreateAction
extends RatingPeriodAction
implements EreAction {
    @Override
    public String perform(NodeList actionSettings) throws Exception {
        StringBuffer buffer = new StringBuffer();
        try {
            boolean serviceProviderTagFound = false;
            for (int ii = 0; ii < actionSettings.getLength(); ++ii) {
                if (actionSettings.item(ii).getNodeType() != 1 || !actionSettings.item(ii).getNodeName().equals(ServiceProviderAction.TAG_SERVICEPROVIDER)) continue;
                serviceProviderTagFound = true;
                try {
                    ServiceProvider serviceProvider;
                    try {
                        serviceProvider = ServiceProviderAction.getServiceProvider(actionSettings.item(ii), this.getEreManager());
                    }
                    catch (Exception e) {
                        serviceProvider = ServiceProviderAction.createServiceProvider(actionSettings.item(ii), this.getEreManager());
                        this.getEreManager().addServiceProvider(serviceProvider.getName(), serviceProvider);
                        serviceProvider = this.getEreManager().getServiceProvider(serviceProvider.getName());
                    }
                    NodeList ratingPlanList = actionSettings.item(ii).getChildNodes();
                    boolean ratingPlanTagFound = false;
                    for (int aa = 0; aa < ratingPlanList.getLength(); ++aa) {
                        if (ratingPlanList.item(aa).getNodeType() != 1 || !ratingPlanList.item(aa).getNodeName().equals(RatingPlanAction.TAG_RATINGPLAN)) continue;
                        ratingPlanTagFound = true;
                        try {
                            RatingPlan ratingPlan;
                            try {
                                ratingPlan = RatingPlanAction.getRatingPlan(serviceProvider, ratingPlanList.item(aa));
                            }
                            catch (Exception e) {
                                ratingPlan = RatingPlanAction.createRatingPlan(serviceProvider, ratingPlanList.item(aa), this.getEreManager());
                                serviceProvider.addRatingPlan(ratingPlan);
                            }
                            NodeList ratingPeriodList = ratingPlanList.item(aa).getChildNodes();
                            boolean ratingPeriodTagFound = false;
                            for (int bb = 0; bb < ratingPeriodList.getLength(); ++bb) {
                                if (ratingPeriodList.item(bb).getNodeType() != 1 || !ratingPeriodList.item(bb).getNodeName().equals("RatingPeriod")) continue;
                                ratingPeriodTagFound = true;
                                try {
                                    buffer.append(this.checkRatingPeriodTagAndCreate(serviceProvider, ratingPlan, ratingPeriodList.item(bb)));
                                    continue;
                                }
                                catch (Exception e) {
                                    buffer.append(RatingPeriodCreateAction.createErrorTag(e.getMessage()));
                                }
                            }
                            if (ratingPeriodTagFound) continue;
                            buffer.append(RatingPeriodCreateAction.createErrorTag("No <RatingPeriod/> tag found"));
                            continue;
                        }
                        catch (Exception e) {
                            buffer.append(RatingPeriodCreateAction.createErrorTag(e.getMessage()));
                        }
                    }
                    if (ratingPlanTagFound) continue;
                    buffer.append(RatingPeriodCreateAction.createErrorTag("No <RatingPlan/> tag found"));
                    continue;
                }
                catch (Exception e) {
                    buffer.append(RatingPeriodCreateAction.createErrorTag(e.getMessage()));
                }
            }
            if (!serviceProviderTagFound) {
                buffer.append(RatingPeriodCreateAction.createErrorTag("No <ServiceProvider/> tag found"));
            }
        }
        catch (Exception e) {
            buffer.append(RatingPeriodCreateAction.createErrorTag(e.getMessage()));
        }
        return buffer.toString();
    }

    private String checkRatingPeriodTagAndCreate(ServiceProvider serviceProvider, RatingPlan ratingPlan, Node node) throws Exception {
        String startDateAndTime;
        String ratingPeriodName = RatingPeriodCreateAction.getRatingPeriodName(node);
        RatingPeriod ratingPeriod = ratingPlan.getRatingPeriod(ratingPeriodName, startDateAndTime = RatingPeriodCreateAction.getStartDate(node));
        if (ratingPeriod != null) {
            throw new Exception("RatingPeriod '" + ratingPeriod + "' already exists for '" + ratingPlan.getName() + "' for '" + serviceProvider.getName() + "'");
        }
        return RatingPeriodCreateAction.createRatingPeriod(serviceProvider, ratingPlan, node);
    }
}

