/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management;

import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.ManagerAction;
import ericsson.ere.integration.management.RequestParser;
import ericsson.ere.integration.receiver.session.SessionHandler;
import ericsson.ere.integration.util.ObjectRepository;
import ericsson.ere.xml.ElementIterator;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractRequestParser
extends AbstractAction
implements RequestParser {
    private static String TAG_ARGUMENT = "Argument";
    private static String TAG_MO = "Mo";
    private static String ATTR_CLASS = "Class";
    private static String ATTR_NAME = "Name";
    protected Map<String, ManagerAction> myManagers = new HashMap<String, ManagerAction>();

    @Override
    public void init(NodeList settings) throws Exception {
        for (Element settingsElement : new ElementIterator(settings)) {
            if (settingsElement.getNodeName().equals(TAG_ARGUMENT)) {
                this.readArgumentElement(settingsElement);
                continue;
            }
            if (!settingsElement.getNodeName().equals(TAG_MO)) continue;
            String moClassName = settingsElement.getAttribute(ATTR_CLASS);
            String moName = settingsElement.getAttribute(ATTR_NAME);
            try {
                ManagerAction moAction = (ManagerAction)EreClassLoader.createInstance(moClassName);
                if (moAction instanceof AbstractAction) {
                    ((AbstractAction)((Object)moAction)).setEreManager(this.getEreManager());
                    ((AbstractAction)((Object)moAction)).setSessionHandler(this.getSessionHandler());
                }
                if (settingsElement.hasChildNodes()) {
                    moAction.init(settingsElement.getChildNodes());
                } else {
                    moAction.init();
                }
                this.myManagers.put(moName, moAction);
            }
            catch (Exception e) {
                String ename = e.getClass().getSimpleName();
                throw new InstantiationException(ename + ". Failed to instantiate " + moName + " from class " + moClassName + ", reason: \n" + e.getMessage());
            }
        }
    }

    private void readArgumentElement(Element element) {
        if (element.getAttribute("Name").equals("SessionHandler")) {
            try {
                Object obj = ObjectRepository.getInstance().getObject(element);
                if (obj instanceof SessionHandler) {
                    this.mySessionHandler = (SessionHandler)obj;
                }
            }
            catch (Exception e) {
                System.out.println("error reading sessionhandler ..." + e.getMessage());
            }
        }
    }
}

