/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.connector.http;

import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.util.HttpCommunicator;
import com.ericsson.ere.util.TypedKey;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.CanceledEreLoginException;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.defs.EreXmlCommand;
import ericsson.ere.integration.defs.EreXmlCommandHelper;
import ericsson.ere.integration.management.EreProvisioningException;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.Service;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.io.BufferedReader;
import java.net.Socket;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpRequestSender {
    private static final Pattern PROCINSTR_PATTERN = Pattern.compile("<\\?.*\\?>");
    public static final String DISCONNECTED_SESSION_ID = "loggedOut";
    public static final String DEFAULT_SESSION_ID = "0";
    private String myCurrentSessionId = "0";
    private SettingsMap mySettingsMap = null;
    private static final String HTTP_CONTENT_TYPE_TEXT = "text/xml";
    private static final String HTTP_USER_AGENT = "HttpRequestSender";
    private String myRequestURI = "/NewRequest/";
    private boolean myIsInternalEre = false;
    public static final String SETTING_USERNAME = "Username";
    public static final String SETTING_PASSWORD = "Password";
    public static final String SETTING_DEST_HOST = "DestinationHost";
    public static final String SETTING_PORT = "Port";
    public static final String SETTING_SERVER_NAME = "Name";
    public static final String SETTING_TYPE = "type";
    public static final String INTERNAL_ERE = "Internal ERE";

    public HttpRequestSender(SettingsMap settings) {
        this.mySettingsMap = settings;
    }

    private void setSessionId(String sessionId) {
        this.myCurrentSessionId = sessionId;
    }

    public String getSessionId() {
        return this.myCurrentSessionId;
    }

    public String getId() {
        return this.getHost() + ":" + this.getPortAsString();
    }

    private String getHost() {
        return this.mySettingsMap.getParameter(SETTING_DEST_HOST).getValue();
    }

    private String getPortAsString() {
        return this.mySettingsMap.getParameter(SETTING_PORT).getValue();
    }

    private int getPort() throws Exception {
        int portNumber = 0;
        try {
            portNumber = Integer.parseInt(this.getPortAsString());
        }
        catch (NumberFormatException nfe) {
            String msg = this.getPortAsString() + " is not a valid port number.";
            RmaDefs.loggerRatingManager.log(Level.SEVERE, msg);
            throw new Exception(msg);
        }
        return portNumber;
    }

    private String getUserName() {
        return this.mySettingsMap.getParameter(SETTING_USERNAME).getValue();
    }

    private String getPassword() {
        Parameter pwParam = this.mySettingsMap.getParameter(SETTING_PASSWORD);
        return pwParam != null ? pwParam.getValue() : null;
    }

    private Config.UserInfo askForUserInfo() {
        String serverName = this.mySettingsMap.getParameter(SETTING_SERVER_NAME).getValue();
        Config.UserInfo ui = serverName != null && !serverName.equals("") ? DialogFactory.showLoginDialog(serverName, this.getUserName()) : DialogFactory.showLoginDialog(this.getUserName());
        return ui;
    }

    public String sendRequest(String request) throws Exception {
        return this.send(request);
    }

    protected String send(String theRequest) throws Exception {
        if (RmaDefs.loggerRma.isLoggable(Level.FINEST)) {
            RmaDefs.loggerRma.finest("Sending request:\n" + theRequest);
        }
        Socket aSocket = new Socket(this.getHost(), this.getPort());
        aSocket.setSoTimeout(10000);
        HttpCommunicator.HttpClientCommunicator client = new HttpCommunicator.HttpClientCommunicator(aSocket, "UTF-8");
        client.setUserAgent(HTTP_USER_AGENT);
        client.sendPostRequest(this.myRequestURI, theRequest, HTTP_CONTENT_TYPE_TEXT, "Host", this.getHost());
        String response = client.readResponse().intern();
        if (response.indexOf("<?") >= 0) {
            response = PROCINSTR_PATTERN.matcher(response).replaceAll("");
        }
        if (RmaDefs.loggerRma.isLoggable(Level.FINEST)) {
            RmaDefs.loggerRma.finest("Received response:\n" + response);
        }
        return response;
    }

    private void disconnect() throws Exception {
        if (this.isLoggedIn()) {
            this.send(EreXmlCommandHelper.logoutRequest(this.getUserName(), this.getPassword(), this.getSessionId()));
            this.setSessionId(DISCONNECTED_SESSION_ID);
        }
    }

    private boolean isLoggedIn() {
        return !this.myCurrentSessionId.equals(DEFAULT_SESSION_ID) && !this.myCurrentSessionId.equals(DISCONNECTED_SESSION_ID);
    }

    protected void connect() throws Exception {
        String username = this.getUserName();
        String password = this.getPassword();
        while (!this.connect(username, password)) {
            Config.UserInfo loginInfo = this.askForUserInfo();
            if (loginInfo == null) {
                throw new CanceledEreLoginException(null, "User cancelled the login.");
            }
            username = loginInfo.myUsername;
            password = loginInfo.myPassword;
        }
        this.mySettingsMap.setParameter(SETTING_USERNAME, username, 1, false);
        this.mySettingsMap.setParameter(SETTING_PASSWORD, password, 1, false);
    }

    @Deprecated
    public void connectFds(String request) throws Exception {
        throw new UnsupportedOperationException("Not supported in ERE.");
    }

    private boolean connect(String userName, String password) throws Exception {
        if (password == null) {
            return false;
        }
        if (Objects.nonNull(this.mySettingsMap.getParameter(SETTING_TYPE))) {
            this.myIsInternalEre = this.mySettingsMap.getParameter(SETTING_TYPE).getValue().equals(INTERNAL_ERE);
        }
        String request = EreXmlCommand.loginRequest(userName, password, this.myIsInternalEre);
        String loginResponse = this.send(request);
        Element responseElement = XMLUtil.buildDocumentFromString(loginResponse).getDocumentElement();
        Element errorElement = XMLUtil.getNamedElement("Error", responseElement.getChildNodes());
        Element sessionIdElement = XMLUtil.getNamedElement("SessionId", responseElement.getChildNodes());
        if (errorElement == null) {
            if (sessionIdElement == null) {
                RmaDefs.loggerRatingManager.log(Level.SEVERE, "No session ID returned from server " + this.getId() + ". Response is:\n" + loginResponse);
                throw new Exception("No session ID returned from server " + this.getId() + ".");
            }
            this.setSessionId(sessionIdElement.getTextContent());
            return true;
        }
        RmaDefs.loggerRatingManager.log(Level.WARNING, "Error when logging in to " + this.getHost() + ": " + errorElement.getTextContent());
        return false;
    }

    public Element getRatingManagerElement() throws Exception {
        try {
            this.connect();
            Document rmDoc = XMLUtil.buildDocumentFromString(this.send(EreXmlCommandHelper.createRatingManagerGetRequest(this.getSessionId())));
            this.checkResponse(rmDoc);
            Element element = (Element)rmDoc.getElementsByTagName("Manager").item(0);
            return element;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(String serviceName) throws Exception {
        try {
            this.connect();
            String serviceXML = this.send(EreXmlCommandHelper.createServiceGetRequest(serviceName, this.getSessionId()));
            Document serviceDoc = XMLUtil.buildDocumentFromString(serviceXML);
            NodeList list = serviceDoc.getElementsByTagName("ServiceDefinition");
            Element definitionNode = XMLUtil.getNamedElement("ServiceDefinition", list);
            list = serviceDoc.getElementsByTagName("Settings");
            Element conditionNode = XMLUtil.getNamedElement("Settings", list);
            Service service = new Service(serviceName);
            service.startService(definitionNode, conditionNode);
            Service service2 = service;
            return service2;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceXMLString(String serviceName) throws Exception {
        try {
            this.connect();
            String serviceXML = this.send(EreXmlCommandHelper.createServiceGetRequest(serviceName, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(serviceXML));
            String string = serviceXML;
            return string;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getRatingPeriodRuleTree(RatingPeriodProxy ratingPeriodProxy) throws Exception {
        try {
            Element tariffStructureElement;
            this.connect();
            String ratingRuleTreeXML = this.send(EreXmlCommandHelper.createRatingPeriodGetRequest(ratingPeriodProxy, this.getSessionId()));
            Document doc = XMLUtil.buildDocumentFromString(ratingRuleTreeXML);
            this.checkResponse(doc);
            Element element = tariffStructureElement = XMLUtil.getFirstElementNamed("RatingPeriod", doc.getDocumentElement());
            return element;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getRatingPeriodRuleTree(RatingPeriod ratingPeriod) throws Exception {
        try {
            this.connect();
            String ratingRuleTreeXML = this.send(EreXmlCommandHelper.createRatingPeriodGetRequest(ratingPeriod, this.getSessionId()));
            int startPos = ratingRuleTreeXML.indexOf("<?");
            int endPos = ratingRuleTreeXML.indexOf("</TariffStructure>");
            if (startPos < 0) {
                startPos = ratingRuleTreeXML.indexOf("<TariffStructure ");
            }
            String string = ratingRuleTreeXML.substring(startPos, endPos + "</TariffStructure>".length());
            return string;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServiceList() throws Exception {
        try {
            this.connect();
            String serviceListXML = this.send(EreXmlCommandHelper.createServiceListGetRequest(this.getSessionId()));
            Document doc = XMLUtil.buildDocumentFromString(serviceListXML);
            NodeList list = doc.getElementsByTagName("Service");
            String[] array = new String[list.getLength()];
            for (int ii = 0; ii < list.getLength(); ++ii) {
                array[ii] = list.item(ii).getAttributes().getNamedItem(SETTING_SERVER_NAME).getNodeValue();
            }
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.disconnect();
        }
    }

    private void checkResponse(Document responseDoc) throws EreCommunicationException {
        NodeList list = responseDoc.getElementsByTagName("Error");
        if (list.getLength() == 0) {
            return;
        }
        String errMsg = "";
        EreProvisioningException epe = null;
        for (Node item : new NodeListIterable(list)) {
            NodeList epeList;
            for (Node child : new NodeListIterable(item.getChildNodes())) {
                if (child.getNodeValue() == null || child.getNodeValue().trim().length() <= 0) continue;
                errMsg = errMsg + child.getNodeValue() + "\n";
            }
            if (epe != null || (epeList = ((Element)item).getElementsByTagName("EreProvisioningException")).getLength() == 0) continue;
            Element epeElement = (Element)epeList.item(0);
            epe = EreProvisioningException.createFromXML(epeElement);
        }
        throw new EreCommunicationException(null, errMsg, epe);
    }

    public void createServiceProvider(SettingsMap model) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createServiceProviderCreateRequest(model, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    public void removeServiceProvider(ServiceProviderProxy serviceProviderProxy) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createServiceProviderDeleteRequest(serviceProviderProxy, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceProvider(ServiceProviderProxy serviceProviderProxy, SettingsMap newValues) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createServiceProviderSetRequest(serviceProviderProxy, newValues, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRatingPlan(ServiceProviderProxy serviceProviderProxy, SettingsMap model) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingPlanCreateRequest(serviceProviderProxy, model, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    public void removeRatingPlan(RatingPlanProxy ratingPlanProxy) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingPlanDeleteRequest(ratingPlanProxy, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRatingPlan(RatingPlanProxy ratingPlanProxy, SettingsMap newValues) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingPlanSetRequest(ratingPlanProxy, newValues, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRatingPeriod(RatingPeriodProxy ratingPeriodProxy) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingPeriodGetRequest(ratingPeriodProxy, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
            String string = response;
            return string;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRatingPeriod(RatingPlanProxy ratingPlanProxy, SettingsMap model, Element newStructureXML) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingPeriodCreateRequest(ratingPlanProxy, model, newStructureXML, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRatingPeriod(String serviceProviderName, String ratingPlanName, String ratingPeriodName, String startTime, String ratingStructureXml) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingPeriodSetRequest(serviceProviderName, ratingPlanName, ratingPeriodName, startTime, ratingStructureXml, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRatingPeriod(RatingPeriodProxy ratingPeriodProxy, SettingsMap newValues) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingPeriodSetRequest(ratingPeriodProxy, newValues, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    @Deprecated
    public void updateRatingPeriod(String serviceProviderName, String ratingPlanName, String ratingPeriodName, BufferedReader source, long srcLen) throws Exception {
    }

    public void removeRatingPeriod(RatingPeriodProxy ratingPeriodProxy) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingPeriodDeleteRequest(ratingPeriodProxy, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createService(ServiceListProxy serviceListProxy, SettingsMap model, Element newDefinitionXml, Element newConditionXml) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createServiceCreateRequest(serviceListProxy, model, newDefinitionXml, newConditionXml, this.getSessionId()));
            Document responseDoc = XMLUtil.buildDocumentFromString(response);
            Element serviceElement = XMLUtil.getFirstElementNamed("Service", responseDoc.getDocumentElement());
            if (serviceElement != null) {
                if (serviceElement.hasAttribute("DefinitionFile")) {
                    model.getParameter("Service definition file").setValue(serviceElement.getAttribute("DefinitionFile"));
                }
                if (serviceElement.hasAttribute("ConditionLeafClassFile")) {
                    model.getParameter("Service condition file").setValue(serviceElement.getAttribute("ConditionLeafClassFile"));
                }
            }
            this.checkResponse(responseDoc);
        }
        finally {
            this.disconnect();
        }
    }

    public void removeService(ServiceProxy serviceProxy) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createServiceDeleteRequest(serviceProxy, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateService(ServiceProxy serviceProxy, SettingsMap newValues) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createServiceSetRequest(serviceProxy, newValues, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateService(String serviceName, String definitionRef, String conditionRef, String definitionStruct, String conditionStruct, boolean forced) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createServiceSetRequest(serviceName, definitionRef, conditionRef, definitionStruct, conditionStruct, this.getSessionId(), forced));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRatingManager(RatingManagerProxy managerProxy, SettingsMap newValues) throws Exception {
        try {
            this.connect();
            String response = this.send(EreXmlCommandHelper.createRatingManagerSetRequest(managerProxy, newValues, this.getSessionId()));
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRatingPeriodProperties(String serviceName, String providerName, String planName, String periodName, String startTimeAsISOString, TypedKey[] keys, String[] newProperties) throws Exception {
        try {
            this.connect();
            String request = EreXmlCommandHelper.createRatingPeriodSetPropertyRequest(serviceName, providerName, planName, periodName, startTimeAsISOString, keys, newProperties, this.getSessionId());
            String response = this.send(request);
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceProperties(String serviceName, TypedKey[] keys, String[] values) throws Exception {
        try {
            this.connect();
            String request = EreXmlCommandHelper.createServiceSetPropertyRequest(serviceName, keys, values, this.getSessionId());
            String response = this.send(request);
            this.checkResponse(XMLUtil.buildDocumentFromString(response));
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRatingPeriodProperties(String serviceName, String providerName, String planName, String periodName, String startTimeAsISOString, TypedKey[] keys) throws Exception {
        try {
            this.connect();
            String request = EreXmlCommandHelper.createRatingPeriodGetPropertyRequest(serviceName, providerName, planName, periodName, startTimeAsISOString, keys, this.getSessionId());
            String response = this.send(request);
            Document responseDoc = XMLUtil.buildDocumentFromString(response);
            this.checkResponse(responseDoc);
            String[] stringArray = this.splitValuePropertyString(responseDoc.getDocumentElement());
            return stringArray;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServiceProperties(String serviceName, TypedKey[] keys) throws Exception {
        try {
            this.connect();
            String request = EreXmlCommandHelper.createServiceGetPropertyRequest(serviceName, keys, this.getSessionId());
            String response = this.send(request);
            Document responseDoc = XMLUtil.buildDocumentFromString(response);
            this.checkResponse(responseDoc);
            String[] stringArray = this.splitValuePropertyString(responseDoc.getDocumentElement());
            return stringArray;
        }
        finally {
            this.disconnect();
        }
    }

    private String[] splitValuePropertyString(Element responseElement) throws Exception {
        Element propertyElement = XMLUtil.getFirstElementNamed("Property", responseElement);
        String[] values = null;
        if (propertyElement != null) {
            String valueAttr = propertyElement.getAttribute("value");
            values = StringUtil.splitSemiColonSeparatedString(valueAttr);
        }
        return values;
    }

    public boolean isAlive() throws Exception {
        String response = this.send(EreXmlCommandHelper.createIsAliveRequest());
        this.checkResponse(XMLUtil.buildDocumentFromString(response));
        return true;
    }

    protected SettingsMap getSettingsMap() {
        return this.mySettingsMap;
    }

    public void forgetCredentials() {
        this.mySettingsMap.setParameter(SETTING_USERNAME, null, 1, false);
        this.mySettingsMap.setParameter(SETTING_PASSWORD, null, 1, false);
    }
}

