/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.simulation;

import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterModel
extends AbstractTableModel {
    private List<Variable> myVariables;
    private List<Boolean> myBooleans;
    private List<Boolean> myOriginBooleans;
    private String myName = "";
    final String[] COLUMN_NAMES = new String[]{"On", "Name", "Value"};
    final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, String.class, Variable.class};

    public ParameterModel(List<Variable> v) {
        this.myVariables = v;
        int len = v.size();
        this.myBooleans = new ArrayList<Boolean>(len);
        for (int i = 0; i < len; ++i) {
            this.myBooleans.add(new Boolean(true));
        }
        this.resetModified();
    }

    public ParameterModel(List<Variable> vars, List<Boolean> bools) {
        this.myVariables = vars;
        this.myBooleans = bools;
    }

    @Override
    public Class<?> getColumnClass(int i) {
        if (i < this.COLUMN_CLASSES.length) {
            return this.COLUMN_CLASSES[i];
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int i) {
        if (i < this.COLUMN_NAMES.length) {
            return this.COLUMN_NAMES[i];
        }
        return "???";
    }

    @Override
    public int getRowCount() {
        return this.myVariables.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return null;
        }
        if (col >= this.getColumnCount()) {
            return null;
        }
        Variable v = this.myVariables.get(row);
        switch (col) {
            case 0: {
                return this.myBooleans.get(row);
            }
            case 1: {
                return v.getLabel();
            }
            case 2: {
                return v;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return true;
        }
        if (col == 2 && row < this.myVariables.size()) {
            return this.myVariables.get(row).isAllowEdit();
        }
        return false;
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        if (col == 2) {
            this.myVariables.get(row).setValue(val);
            this.fireTableCellUpdated(row, col);
        }
        if (col == 0 && val instanceof Boolean) {
            this.myBooleans.set(row, (Boolean)val);
            this.fireTableCellUpdated(row, col);
        }
    }

    public void writeXML(PrintWriter out) {
        int i;
        int len = this.getRowCount();
        out.println("<ParameterModel name= \"" + this.myName + "\" rows=\"" + len + "\">");
        for (i = 0; i < len; ++i) {
            Variable v = this.myVariables.get(i);
            v.writeXML(out);
        }
        for (i = 0; i < len; ++i) {
            Boolean b = this.myBooleans.get(i);
            out.println("<Boolean>" + b.toString() + "</Boolean>");
        }
        out.println("</ParameterModel>");
    }

    public static ParameterModel create(Node iterator) {
        if ("ParameterModel".equals(iterator.getNodeName())) {
            int rows;
            ArrayList<Variable> variables = new ArrayList<Variable>();
            ArrayList<Boolean> booleans = new ArrayList<Boolean>();
            String name = ((Element)iterator).getAttribute("name");
            NamedNodeMap attr = iterator.getAttributes();
            Node node = attr.getNamedItem("rows");
            if (node != null && (rows = Integer.parseInt(node.getNodeValue())) > 0) {
                variables.ensureCapacity(rows);
                booleans.ensureCapacity(rows);
            }
            NodeList varsAndBools = iterator.getChildNodes();
            for (int i = 0; i < varsAndBools.getLength(); ++i) {
                node = varsAndBools.item(i);
                if (node.getNodeType() != 1) continue;
                if ("Boolean".equals(node.getNodeName())) {
                    Boolean b = Boolean.valueOf(XMLUtil.getFirstTextContent(node));
                    booleans.add(b);
                    continue;
                }
                try {
                    Variable v = Variable.create(node);
                    if (v != null) {
                        variables.add(v);
                        continue;
                    }
                    System.out.println("Unknown node (not a Variable): " + node.getNodeName());
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ERROR creating ParameterModel " + e);
                    e.printStackTrace();
                }
            }
            ParameterModel model = new ParameterModel(variables, booleans);
            model.setName(name);
            return model;
        }
        return null;
    }

    public boolean isModified() {
        int ii;
        for (ii = 0; ii < this.myVariables.size(); ++ii) {
            if (!this.myVariables.get(ii).isModified()) continue;
            return true;
        }
        if (this.myOriginBooleans == null) {
            return true;
        }
        if (this.myBooleans.size() != this.myOriginBooleans.size()) {
            return true;
        }
        for (ii = 0; ii < this.myBooleans.size(); ++ii) {
            if (this.myBooleans.get(ii).booleanValue() == this.myOriginBooleans.get(ii).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void resetModified() {
        for (int ii = 0; ii < this.myVariables.size(); ++ii) {
            this.myVariables.get(ii).resetModified();
        }
        this.myOriginBooleans = new ArrayList<Boolean>();
        for (int i = 0; i < this.myBooleans.size(); ++i) {
            this.myOriginBooleans.add(new Boolean(this.myBooleans.get(i)));
        }
    }

    public List<Variable> getUsedVariableList() {
        ArrayList<Variable> usedVars = new ArrayList<Variable>();
        int len = this.myVariables.size();
        for (int i = 0; i < len; ++i) {
            if (!this.myBooleans.get(i).booleanValue()) continue;
            usedVars.add(this.myVariables.get(i));
        }
        return usedVars;
    }

    public List<Variable> getVariables() {
        return this.myVariables;
    }

    public List<Boolean> getBooleans() {
        return this.myBooleans;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }
}

