/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TreeBuilderAssistant;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureConstants;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.w3c.dom.Node;

public abstract class TariffDAGNode
extends AbstractDAGNode
implements XMLInitializable,
TariffStructureNode,
TariffStructureConstants,
TreeBuilderAssistant {
    protected List<Object> myChildren = null;
    protected ClassRepository myClassRep = null;
    protected TariffDAGModel myDAGModel = null;
    protected boolean myIsLazyInit = true;

    public TariffDAGNode(ClassRepository rep) {
        this.myClassRep = rep;
    }

    @Override
    public int getChildCount() {
        if (this.myChildren == null) {
            return 0;
        }
        return this.myChildren.size();
    }

    public int getClassCount(Class<?> clazz) {
        int counter = 0;
        if (this.myChildren == null) {
            return counter;
        }
        for (int ii = 0; ii < this.myChildren.size(); ++ii) {
            if (this.myChildren.get(ii).getClass() != clazz) continue;
            ++counter;
        }
        return counter;
    }

    public void moveUp(Object child) {
        int childIndex = this.getIndexOfChild((DAGNode)child);
        if (childIndex > 0) {
            this.myChildren.remove(childIndex);
            this.myChildren.add(childIndex - 1, child);
        }
    }

    public void moveDown(Object child) {
        int childIndex = this.getIndexOfChild((DAGNode)child);
        if (childIndex >= 0 && childIndex < this.getChildCount() - 1) {
            this.myChildren.remove(childIndex);
            this.myChildren.add(childIndex + 1, child);
        }
    }

    @Override
    public DAGNode getChildAt(int index) {
        return (DAGNode)this.myChildren.get(index);
    }

    @Override
    public void insertChildAt(int i, DAGNode node) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<Object>();
        }
        this.myChildren.add(i, node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int i, DAGNode node) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<Object>();
        }
        this.myChildren.add(i, node);
        node.addReferer(this);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        throw new IllegalArgumentException("Node replacement not supported by TariffDAGNode");
    }

    @Override
    @Deprecated
    public void removeChild(DAGNode node) {
        this.myChildren.remove(node);
        node.setParent(null);
    }

    @Override
    @Deprecated
    public void removeLink(DAGNode node) {
        this.myChildren.remove(node);
        node.removeReferer(this);
    }

    public TariffDAGModel getTreeModel() {
        return this.myDAGModel;
    }

    public void setTreeModel(TariffDAGModel m) {
        this.myDAGModel = m;
        int len = this.getChildCount();
        for (int i = 0; i < len; ++i) {
            ((TariffDAGNode)this.getChildAt(i)).setTreeModel(m);
        }
    }

    @Override
    public abstract int getNodeType();

    @Override
    public abstract String getNodeId();

    public abstract String getNodeName();

    public abstract String getTypename();

    @Override
    public abstract boolean getAllowsChildren();

    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    public boolean isLazyInit() {
        return this.myIsLazyInit;
    }

    public abstract XMLInitializable init(Node var1, boolean var2) throws Exception;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        return this.init(iterator, false);
    }

    public abstract String getDescription();

    public abstract String getAdditionalInfo();

    public TableModel getTableModel() {
        return null;
    }

    public abstract List<Variable> getVariablesForEditing(VarTableModel var1);

    public abstract void editingFinished(List<Variable> var1, boolean var2);

    public abstract Map<String, Object> getParameters();

    public abstract void print(PrintWriter var1, int var2, String var3);

    public abstract boolean isModified();

    public abstract void resetModified();

    public abstract boolean isNodeValid();

    public abstract String getProfileClass();

    public int getChildIndexWithType(TariffStructureNode node, int type) {
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            TariffStructureNode n = (TariffStructureNode)node.getChildAt(i);
            if (n.getNodeType() != type) continue;
            return i;
        }
        return -1;
    }

    public void setUndo(Object o) {
    }

    @Override
    public void remove(DAGNode node) {
        if (node instanceof TariffDAGNode && this.getIndexOfChild(node) >= 0) {
            ((TariffDAGNode)node).recPreRemove();
            super.remove(node);
        } else {
            super.remove(node);
        }
    }

    private void recPreRemove() {
        if (!this.isLink()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ((TariffDAGNode)this.getChildAt(i)).recPreRemove();
            }
        }
        this.preRemove();
    }

    protected void preRemove() {
    }
}

