/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.AbstractTreeModel;
import ericsson.ere.gui.ratingrules.nodes.DefaultTariffDAGModelAddPolicy;
import ericsson.ere.gui.ratingrules.nodes.NodeMovedEvent;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModelAddPolicy;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.ratingrules.nodes.TreeBuilderAssistant;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.ratingrules.AmbiguousLinkTargetException;
import ericsson.ere.ratingrules.LinkResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

public class TariffDAGModel
extends AbstractTreeModel {
    protected JTree myTree = null;
    protected TariffStructureNode myRoot = null;
    private TariffDAGModelAddPolicy myPolicy = null;
    private SettingsMap mySettings = new SettingsMap();
    private boolean myIsMovingNode;

    public TariffDAGModel(JTree ownerTree, TariffStructureNode root) {
        this(ownerTree, root, new DefaultTariffDAGModelAddPolicy());
    }

    public TariffDAGModel(JTree ownerTree, TariffStructureNode root, TariffDAGModelAddPolicy policy) {
        this.myTree = ownerTree;
        this.myRoot = root;
        this.myPolicy = policy;
    }

    public void tearDown() {
        this.myRoot = null;
        this.myTree = null;
    }

    public JTree getOwnerTree() {
        return this.myTree;
    }

    public void setOwnerTree(JTree tree) {
        this.myTree = tree;
    }

    public SettingsMap getSettings() {
        return this.mySettings;
    }

    public void updateSettings(SettingsMap settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Cannot set a null settings map.");
        }
        if (this.mySettings != settings) {
            this.mySettings.mergeParametersFrom(settings);
            for (Object propKey : settings.getPropertiesKeySet()) {
                String key = (String)propKey;
                this.mySettings.setProperty(key, settings.getProperty(key));
            }
            this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
        }
    }

    @Override
    public Object getRoot() {
        return this.myRoot;
    }

    public TreePath getPathToRoot(DAGNode node) {
        return DAGUtil.getPathToRoot(node);
    }

    @Override
    public Object getChild(Object parent, int i) {
        return ((DAGNode)parent).getChildAt(i);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((DAGNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object parent) {
        return !((TariffDAGNode)parent).getAllowsChildren();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object v) {
        this.nodeChanged((DAGNode)path.getLastPathComponent());
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        DAGNode p = (DAGNode)parent;
        DAGNode c = (DAGNode)child;
        int len = p.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (p.getChildAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public List<?> addTariffStrucureNodeAsChild(Object[] pathToTarget, TariffStructureNode nodeToAdd) {
        return this.addTariffStrucureNodeAsChild(pathToTarget, nodeToAdd, 0);
    }

    public List<?> addTariffStrucureNodeAsChild(Object[] pathToTarget, TariffStructureNode nodeToAdd, int preferredIndex) {
        if (nodeToAdd == null) {
            throw new IllegalArgumentException("The parameter node cannot be null");
        }
        if (pathToTarget.length < 1) {
            throw new IllegalArgumentException("The path array must contain at least one node.");
        }
        TariffStructureNode tail = (TariffStructureNode)pathToTarget[pathToTarget.length - 1];
        this.checkForAmbiguousLink(tail, nodeToAdd);
        int index = this.myPolicy.getIndexForChild(tail, nodeToAdd, preferredIndex);
        tail.insertChildAt(index, nodeToAdd);
        List<Object> pathToParent = Arrays.asList(pathToTarget);
        this.resolveLink(nodeToAdd, pathToParent, false);
        this.fireTreeNodesInsertedFor(nodeToAdd);
        return pathToParent;
    }

    private void checkForAmbiguousLink(TariffStructureNode nodeToCheck, TariffStructureNode nodeToAdd) throws AmbiguousLinkTargetException {
        for (int i = 0; i < nodeToCheck.getChildCount(); ++i) {
            TariffStructureNode child = (TariffStructureNode)nodeToCheck.getChildAt(i);
            if (child.getReferers().length <= 0) continue;
            String name = child.getNodeId();
            if (!nodeToAdd.getNodeId().equals(name)) continue;
            throw new AmbiguousLinkTargetException("Adding this node would make the link to '" + child.getNodeId() + "' ambiguous", child.getNodeId(), child);
        }
    }

    public List<?> addTariffStrucureNodeAsSibling(Object[] pathToTarget, TariffStructureNode nodeToAdd) {
        if (pathToTarget.length < 2) {
            throw new IllegalArgumentException("The path array must contain at least two nodes.");
        }
        TariffStructureNode tail = (TariffStructureNode)pathToTarget[pathToTarget.length - 1];
        TariffStructureNode parent = (TariffStructureNode)pathToTarget[pathToTarget.length - 2];
        int preferredIndex = parent.getIndexOfChild(tail) + 1;
        return this.addTariffStrucureNodeAsChild(Arrays.copyOfRange(pathToTarget, 0, pathToTarget.length - 1), nodeToAdd, preferredIndex);
    }

    public List<?> addTariffStrucureNodeDefault(Object[] pathToTarget, TariffStructureNode nodeToAdd) {
        if (pathToTarget.length < 1) {
            throw new IllegalArgumentException("The path array must contain at least one node.");
        }
        TariffStructureNode tail = (TariffStructureNode)pathToTarget[pathToTarget.length - 1];
        TariffDAGModelAddPolicy.AddMode[] currentPolicyArray = this.myPolicy.getDefaultAddPolicy(tail, nodeToAdd);
        block4: for (int i = 0; i < currentPolicyArray.length; ++i) {
            switch (currentPolicyArray[i]) {
                case ADD_AS_CHILD: {
                    if (!this.allowsAddTariffStructureNodeAsChild(pathToTarget, nodeToAdd)) continue block4;
                    return this.addTariffStrucureNodeAsChild(pathToTarget, nodeToAdd);
                }
                case ADD_AS_SIBLING: {
                    if (!this.allowsAddTariffStructureNodeAsSibling(pathToTarget, nodeToAdd)) continue block4;
                    return this.addTariffStrucureNodeAsSibling(pathToTarget, nodeToAdd);
                }
            }
        }
        throw new AssertionError();
    }

    public boolean allowsAddTariffStructureNodeAsChild(Object[] pathToTarget, TariffStructureNode nodeToAdd) {
        if (nodeToAdd == null) {
            throw new IllegalArgumentException("The parameter node cannot be null");
        }
        return this.allowsAddTariffStructureNodeAsChild(pathToTarget, nodeToAdd, nodeToAdd.getNodeType(), 0);
    }

    public boolean allowsAddTariffStructureNodeAsChild(Object[] pathToTarget, int nodeToAddType) {
        return this.allowsAddTariffStructureNodeAsChild(pathToTarget, null, nodeToAddType, 0);
    }

    public boolean allowsAddTariffStructureNodeAsChild(Object[] pathToTarget, TariffStructureNode nodeToAdd, int nodeToAddType, int preferredIndex) {
        if (pathToTarget == null || pathToTarget.length < 1) {
            return false;
        }
        TSElement tsElementToAdd = null;
        if (nodeToAdd != null) {
            if (nodeToAdd instanceof TSElement) {
                tsElementToAdd = (TSElement)nodeToAdd;
            } else {
                throw new IllegalArgumentException("The parameter node must be an instance TSElement");
            }
        }
        TariffStructureNode tail = (TariffStructureNode)pathToTarget[pathToTarget.length - 1];
        if (this.checkReadOnlyPath(pathToTarget, pathToTarget.length) || tail.isLink()) {
            return false;
        }
        boolean allow = true;
        if (tail instanceof TreeBuilderAssistant) {
            if (nodeToAdd != null && nodeToAdd.isLink()) {
                allow = ((TreeBuilderAssistant)((Object)tail)).allowsAddLink(tsElementToAdd);
            }
            if (allow) {
                switch (nodeToAddType) {
                    case 1: {
                        allow = ((TreeBuilderAssistant)((Object)tail)).allowsAddNode(tsElementToAdd);
                        break;
                    }
                    case 2: {
                        allow = ((TreeBuilderAssistant)((Object)tail)).allowsAddCondition(tsElementToAdd);
                        break;
                    }
                    case 3: {
                        allow = ((TreeBuilderAssistant)((Object)tail)).allowsAddModifier(tsElementToAdd);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        if (allow) {
            allow = this.myPolicy.getAllowAddAsChild(tail, nodeToAddType, preferredIndex);
        }
        return allow;
    }

    public boolean allowsAddTariffStructureNodeAsSibling(Object[] pathToTarget, TariffStructureNode nodeToAdd) {
        if (pathToTarget == null || pathToTarget.length < 2) {
            return false;
        }
        if (nodeToAdd == null) {
            throw new IllegalArgumentException("The parameter node cannot be null");
        }
        TariffStructureNode tail = (TariffStructureNode)pathToTarget[pathToTarget.length - 1];
        TariffStructureNode parent = (TariffStructureNode)pathToTarget[pathToTarget.length - 2];
        int preferredIndex = parent.getIndexOfChild(tail) + 1;
        boolean allow = this.allowsAddTariffStructureNodeAsChild(Arrays.copyOfRange(pathToTarget, 0, pathToTarget.length - 1), nodeToAdd, nodeToAdd.getNodeType(), preferredIndex);
        return allow;
    }

    public boolean allowsAddTariffStructureNodeAsSibling(Object[] pathToTarget, int nodeToAddType) {
        if (pathToTarget == null || pathToTarget.length < 2) {
            return false;
        }
        TariffStructureNode tail = (TariffStructureNode)pathToTarget[pathToTarget.length - 1];
        TariffStructureNode parent = (TariffStructureNode)pathToTarget[pathToTarget.length - 2];
        int preferredIndex = parent.getIndexOfChild(tail) + 1;
        return this.allowsAddTariffStructureNodeAsChild(Arrays.copyOfRange(pathToTarget, 0, pathToTarget.length - 1), null, nodeToAddType, preferredIndex);
    }

    public boolean allowsAddTariffStructureNodeDefault(Object[] pathToTarget, TariffStructureNode nodeToAdd) {
        if (pathToTarget.length < 1) {
            return false;
        }
        TariffStructureNode tail = (TariffStructureNode)pathToTarget[pathToTarget.length - 1];
        TariffDAGModelAddPolicy.AddMode[] currentPolicyArray = this.myPolicy.getDefaultAddPolicy(tail, nodeToAdd);
        boolean addAllowed = false;
        block4: for (int i = 0; i < currentPolicyArray.length && !addAllowed; ++i) {
            switch (currentPolicyArray[i]) {
                case ADD_AS_CHILD: {
                    if (!this.allowsAddTariffStructureNodeAsChild(pathToTarget, nodeToAdd)) continue block4;
                    addAllowed = this.allowsAddTariffStructureNodeAsChild(pathToTarget, nodeToAdd);
                    continue block4;
                }
                case ADD_AS_SIBLING: {
                    if (!this.allowsAddTariffStructureNodeAsSibling(pathToTarget, nodeToAdd)) continue block4;
                    addAllowed = this.allowsAddTariffStructureNodeAsSibling(pathToTarget, nodeToAdd);
                }
            }
        }
        return addAllowed;
    }

    public int gaugeDepth(DAGNode node) {
        int max = 0;
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            max = Math.max(max, this.gaugeDepth(node.getChildAt(i)));
        }
        return max + 1;
    }

    public boolean allowsMoveUp(Object[] path) {
        if (path == null || path.length < 2) {
            return false;
        }
        if (this.checkReadOnlyPath(path, path.length - 1)) {
            return false;
        }
        TariffStructureNode parent = (TariffStructureNode)path[path.length - 2];
        TariffStructureNode tail = (TariffStructureNode)path[path.length - 1];
        int childIndex = parent.getIndexOfChild(tail);
        if (childIndex == 0) {
            return false;
        }
        TariffStructureNode preceding = (TariffStructureNode)parent.getChildAt(childIndex - 1);
        if (tail.getNodeType() == preceding.getNodeType()) {
            return true;
        }
        if (tail.getNodeType() == 1 && preceding.getNodeType() == 3) {
            return true;
        }
        return tail.getNodeType() == 3 && preceding.getNodeType() == 1;
    }

    public boolean allowsMoveDown(Object[] path) {
        if (path == null || path.length < 2) {
            return false;
        }
        if (this.checkReadOnlyPath(path, path.length - 1)) {
            return false;
        }
        TariffStructureNode parent = (TariffStructureNode)path[path.length - 2];
        TariffStructureNode tail = (TariffStructureNode)path[path.length - 1];
        int childIndex = parent.getIndexOfChild(tail);
        if (childIndex == parent.getChildCount() - 1) {
            return false;
        }
        TariffStructureNode succeeding = (TariffStructureNode)parent.getChildAt(childIndex + 1);
        if (tail.getNodeType() == succeeding.getNodeType()) {
            return true;
        }
        if (tail.getNodeType() == 1 && succeeding.getNodeType() == 3) {
            return true;
        }
        return tail.getNodeType() == 3 && succeeding.getNodeType() == 1;
    }

    public void resolveLink(TariffStructureNode node, List<?> context) {
        this.resolveLink(node, context, true);
    }

    private void resolveLink(TariffStructureNode node, List<?> context, boolean doFireRemove) {
        LinkResolver resolver = new LinkResolver(this.myRoot, context);
        try {
            DAGUtil.visitPreorder(node, resolver);
        }
        catch (IllegalArgumentException x) {
            List<TariffStructureNode> toBeUndone = resolver.getLinkHistory();
            TariffStructureNode tail = context.get(context.size() - 1);
            int index = tail.getIndexOfChild(node);
            int len = toBeUndone.size();
            for (int i = 0; i < len; ++i) {
                DAGNode link = toBeUndone.get(i);
                DAGNode target = link.getChildAt(0);
                assert (target != null);
                target.removeReferer(link);
            }
            tail.remove(node);
            if (doFireRemove) {
                ArrayList<List<DAGNode>> pathsToRoot = new ArrayList<List<DAGNode>>();
                DAGUtil.getPathsToRoot(tail, this.myRoot, new ArrayList<DAGNode>(100), pathsToRoot);
                int len2 = pathsToRoot.size();
                for (int i = 0; i < len2; ++i) {
                    List rootpath = (List)pathsToRoot.get(i);
                    Object ownerOfDead = rootpath.get(rootpath.size() - 1);
                    if (ownerOfDead != tail) {
                        throw new IllegalArgumentException("Expected ownerOfDead == tail, found " + ownerOfDead + ", rather than " + tail);
                    }
                    Object[] p = rootpath.toArray();
                    if (p.length == 0) {
                        p = null;
                        index = 0;
                    }
                    int[] indices = new int[]{index};
                    Object[] children = new Object[]{node};
                    this.fireTreeNodesRemoved(this, p, indices, children);
                }
            }
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException("Error when resolving links.", x);
        }
    }

    protected void nodeChanged(DAGNode node) {
        this.nodeChanged(node, false);
    }

    protected void nodeChanged(DAGNode node, boolean fireChangeToRoot) {
        ArrayList<List<DAGNode>> result = new ArrayList<List<DAGNode>>();
        DAGUtil.getPathsToRoot(node, this.myRoot, new ArrayList<DAGNode>(100), result);
        HashSet<ObjectPath> firedPaths = new HashSet<ObjectPath>();
        for (int i = 0; i < result.size(); ++i) {
            List pathlist = (List)result.get(i);
            if (pathlist == null) continue;
            if (pathlist.remove(pathlist.size() - 1) != node) {
                RmaDefs.loggerRatingPeriod.warning("Assertion failed: pathlist.remove(pathlist.size() - 1) != node");
                continue;
            }
            if (pathlist.size() == 0) {
                this.fireTreeNodesChanged(this, new Object[]{node}, null, new Object[]{node});
                continue;
            }
            DAGNode parent = (DAGNode)pathlist.get(pathlist.size() - 1);
            if (parent instanceof TSLink) {
                TariffStructureNode tgt = (TariffStructureNode)parent.getChildAt(0);
                String target = ((TSLink)parent).getPathToRoot(tgt);
                if (!((TSLink)parent).getTarget().equals(target)) {
                    ((TSLink)parent).setParameters("Target", target);
                }
            }
            this.fireChangedEvent(pathlist.toArray(new DAGNode[pathlist.size()]), pathlist.size() - 1, node, fireChangeToRoot, firedPaths);
        }
        HashMap<DAGNode, DAGNode> linksToSubNodes = new HashMap<DAGNode, DAGNode>();
        DAGUtil.getLinksToTargets(node, linksToSubNodes);
        for (Map.Entry linkEntry : linksToSubNodes.entrySet()) {
            try {
                DAGNode target = (DAGNode)linkEntry.getValue();
                TreePath path = DAGUtil.getPathToRoot(target);
                String targetPath = DAGUtil.getTreePathToString(path);
                if (((TSLink)linkEntry.getKey()).getTarget().equals(targetPath)) continue;
                ((TSLink)linkEntry.getKey()).setParameters("Target", targetPath);
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "ratingRuleFrame", 2, "Failed to update link targets in links pointing to elements in the sub tree of the changed element.", true);
            }
        }
    }

    void fireChangedEvent(DAGNode[] pathlist, int parentIndex, DAGNode node, boolean fireChangeToRoot, Set<ObjectPath> alreadyFired) {
        ObjectPath consideredPath = new ObjectPath(pathlist, parentIndex, node);
        boolean hasFired = alreadyFired.contains(consideredPath);
        if (parentIndex < 0) {
            if (!hasFired) {
                alreadyFired.add(consideredPath);
                this.fireTreeNodesChanged(this, new Object[]{pathlist[0]}, null, new Object[]{pathlist[0]});
            }
            return;
        }
        DAGNode parent = pathlist[parentIndex];
        if (!hasFired) {
            int[] indices = new int[]{parent.getIndexOfChild(node)};
            Object[] children = new Object[]{node};
            Object[] newArr = parentIndex + 1 == pathlist.length ? pathlist : Arrays.copyOf(pathlist, parentIndex + 1);
            alreadyFired.add(consideredPath);
            this.fireTreeNodesChanged(this, newArr, indices, children);
        }
        if (fireChangeToRoot) {
            this.fireChangedEvent(pathlist, parentIndex - 1, parent, true, alreadyFired);
        }
    }

    public void insertChildAt(DAGNode parent, int index, DAGNode child) {
        parent.insertChildAt(index, child);
        ArrayList<List<DAGNode>> result = new ArrayList<List<DAGNode>>();
        DAGUtil.getPathsToRoot(parent, this.myRoot, new ArrayList<DAGNode>(100), result);
        this.fireTreeNodesInsertedFor(child);
    }

    protected final void fireTreeNodesInsertedFor(DAGNode node) {
        DAGNode parent = node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("No parent");
        }
        int index = this.getIndexOfChild(parent, node);
        ArrayList<List<DAGNode>> result = new ArrayList<List<DAGNode>>();
        DAGUtil.getPathsToRoot(parent, this.myRoot, new ArrayList<DAGNode>(100), result);
        int[] indices = new int[]{index};
        Object[] children = new Object[]{node};
        for (int i = 0; i < result.size(); ++i) {
            List pathlist = (List)result.get(i);
            if (pathlist == null) continue;
            Object[] path = pathlist.toArray();
            if (parent != path[path.length - 1]) {
                RmaDefs.loggerRatingPeriod.warning("Assertion failed! parent != path.tail");
            }
            this.fireTreeNodesInserted(this, path, indices, children);
        }
    }

    public boolean allowsDelete(Object[] deletionPath) {
        boolean isPhysicalRemoval;
        if (deletionPath.length < 2) {
            return false;
        }
        if (this.checkReadOnlyPath(deletionPath, deletionPath.length - 1)) {
            return false;
        }
        DAGNode toBeDeleted = (DAGNode)deletionPath[deletionPath.length - 1];
        DAGNode parent = (DAGNode)deletionPath[deletionPath.length - 2];
        if (((TariffDAGNode)toBeDeleted).getTypename().equals("Defs")) {
            return false;
        }
        boolean bl = isPhysicalRemoval = parent == toBeDeleted.getParent();
        if (isPhysicalRemoval) {
            HashSet<DAGNode> allChildren = new HashSet<DAGNode>();
            DAGUtil.getChildSet(toBeDeleted, allChildren);
            HashMap<DAGNode, DAGNode> refereeByReferer = new HashMap<DAGNode, DAGNode>();
            DAGUtil.getLinksToTargets(toBeDeleted, refereeByReferer);
            Set referees = refereeByReferer.keySet();
            for (Object o : referees) {
                if (allChildren.contains(o)) continue;
                return false;
            }
        }
        return true;
    }

    public void delete(Object[] deletionPath) {
        boolean isPhysicalRemoval;
        if (deletionPath == null || deletionPath.length < 1) {
            throw new IllegalArgumentException("Path not found: " + Arrays.toString(deletionPath));
        }
        if (deletionPath.length == 1) {
            if (deletionPath[0] == this.myRoot) {
                this.myRoot = null;
                this.fireTreeNodesRemoved(this, deletionPath, null, null);
            } else {
                throw new IllegalArgumentException("Root element not found: " + deletionPath[0]);
            }
        }
        DAGNode toBeDeleted = (DAGNode)deletionPath[deletionPath.length - 1];
        DAGNode parent = (DAGNode)deletionPath[deletionPath.length - 2];
        int index = parent.getIndexOfChild(toBeDeleted);
        boolean bl = isPhysicalRemoval = parent == toBeDeleted.getParent();
        if (isPhysicalRemoval) {
            HashSet<DAGNode> allChildren = new HashSet<DAGNode>();
            DAGUtil.getChildSet(toBeDeleted, allChildren);
            HashMap<DAGNode, DAGNode> refereeByReferer = new HashMap<DAGNode, DAGNode>();
            DAGUtil.getLinksToTargets(toBeDeleted, refereeByReferer);
            Set referees = refereeByReferer.keySet();
            for (Object o : referees) {
                if (allChildren.contains(o)) continue;
                return;
            }
        }
        ArrayList<List<DAGNode>> pathsToRoot = new ArrayList<List<DAGNode>>();
        DAGUtil.getPathsToRoot(parent, this.myRoot, new ArrayList<DAGNode>(100), pathsToRoot);
        parent.remove(toBeDeleted);
        if (isPhysicalRemoval) {
            this.removeReferences(toBeDeleted);
        }
        for (int i = 0; i < pathsToRoot.size(); ++i) {
            List path = (List)pathsToRoot.get(i);
            Object ownerOfDead = path.get(path.size() - 1);
            if (ownerOfDead != parent) {
                throw new IllegalArgumentException("Expected ownerOfDead == parent, found " + ownerOfDead + ", rather than " + parent);
            }
            Object[] p = path.toArray();
            if (p.length == 0) {
                p = null;
                index = 0;
            }
            int[] indices = new int[]{index};
            Object[] children = new Object[]{toBeDeleted};
            this.fireTreeNodesRemoved(this, p, indices, children);
        }
    }

    public void printPath(DAGNode[] path) {
        for (int i = 0; i < path.length; ++i) {
            System.out.print("/" + path[i]);
        }
        System.out.println("");
    }

    public void moveUp(Object[] path) {
        this.moveDirection(path, true);
    }

    public void moveDown(Object[] path) {
        this.moveDirection(path, false);
    }

    private void moveDirection(Object[] path, boolean up) {
        boolean allows;
        if (path == null || path.length < 2) {
            return;
        }
        TariffStructureNode tail = (TariffStructureNode)path[path.length - 1];
        TariffDAGNode parent = (TariffDAGNode)path[path.length - 2];
        int indexBefore = parent.getIndexOfChild(tail);
        boolean bl = allows = up ? this.allowsMoveUp(path) : this.allowsMoveDown(path);
        if (allows) {
            if (up) {
                parent.moveUp(tail);
            } else {
                parent.moveDown(tail);
            }
            int indexAfter = parent.getIndexOfChild(tail);
            ArrayList<List<DAGNode>> result = new ArrayList<List<DAGNode>>();
            DAGUtil.getPathsToRoot(parent, this.myRoot, new ArrayList<DAGNode>(100), result);
            int[] indices = new int[]{indexBefore};
            Object[] children = new Object[]{tail};
            int[] indices2 = new int[]{indexAfter};
            Object[] children2 = new Object[]{tail};
            for (int i = 0; i < result.size(); ++i) {
                List pathlist = (List)result.get(i);
                if (pathlist == null) continue;
                Object[] p = pathlist.toArray();
                this.myIsMovingNode = true;
                this.fireTreeNodesRemoved(this, p, indices, children);
                this.fireTreeNodesInserted(this, p, indices2, children2);
                this.myIsMovingNode = false;
            }
        }
    }

    @Override
    protected TreeModelEvent createInsertEvent(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent theEvent = this.myIsMovingNode ? new NodeMovedEvent(source, path, childIndices, children) : super.createInsertEvent(source, path, childIndices, children);
        return theEvent;
    }

    private void removeReferences(DAGNode curr) {
        for (int i = 0; i < curr.getChildCount(); ++i) {
            DAGNode child = curr.getChildAt(i);
            if (child.getParent() == curr) {
                this.removeReferences(child);
                continue;
            }
            child.removeReferer(curr);
        }
    }

    private boolean checkReadOnlyPath(Object[] path, int len) {
        for (int i = 0; i < len; ++i) {
            TariffDAGNode node = (TariffDAGNode)path[i];
            if (!node.isLocked()) continue;
            return true;
        }
        return false;
    }

    private static class ObjectPath {
        private Object[] myPath;
        private int myParentIndex;
        private Object myTail;

        ObjectPath(Object[] path, int parentIndex, Object tail) {
            if (path == null) {
                throw new IllegalArgumentException("Path array must be non-null.");
            }
            this.myPath = path;
            this.myParentIndex = parentIndex < -1 ? -1 : parentIndex;
            this.myTail = tail;
        }

        public int hashCode() {
            int prime = 31;
            int result = this.hashRange(this.myPath, 0, this.myParentIndex);
            result = 31 * result + (this.myTail == null ? 0 : this.myTail.hashCode());
            return result;
        }

        private int hashRange(Object[] a, int begin, int endInclusive) {
            if (a == null) {
                return 0;
            }
            int result = 1;
            for (int i = begin; i <= endInclusive && i < a.length; ++i) {
                result = 31 * result + (a[i] == null ? 0 : a[i].hashCode());
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ObjectPath other = (ObjectPath)obj;
            if (!this.equalsRange(this.myPath, other.myPath, 0, this.myParentIndex)) {
                return false;
            }
            return !(this.myTail == null ? other.myTail != null : !this.myTail.equals(other.myTail));
        }

        private boolean equalsRange(Object[] a, Object[] a2, int begin, int endInclusive) {
            if (a == a2) {
                return true;
            }
            if (a == null || a2 == null) {
                return false;
            }
            if (endInclusive >= a.length || endInclusive >= a2.length) {
                return false;
            }
            for (int i = begin; i <= endInclusive; ++i) {
                Object o1 = a[i];
                Object o2 = a2[i];
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String str = "[";
            for (int i = 0; i <= this.myParentIndex; ++i) {
                if (i > 0) {
                    str = str + ", ";
                }
                str = str + String.valueOf(this.myPath[i]);
            }
            if (this.myParentIndex >= 0) {
                str = str + ", ";
            }
            str = str + String.valueOf(this.myTail);
            str = str + "]";
            return str;
        }
    }
}

