/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.util.StringUtil;
import java.util.Map;

public class ParameterPredicate
implements NodePredicate {
    static final long serialVersionUID = 1L;
    public static final String[] OPERATORS = new String[]{"equals", "not equals", "greater than", "less than", "contains", "starts with", "ends with"};
    public static final int EQUALS = 0;
    public static final int NOT_EQUAL_TO = 1;
    public static final int GREATER_THAN = 2;
    public static final int LESS_THAN = 3;
    public static final int CONTAINS = 4;
    public static final int STARTS_WITH = 5;
    public static final int ENDS_WITH = 6;
    private final String myParameterName;
    private final int myOperator;
    private final String myMatch;

    public ParameterPredicate(String parameter, int operator, String match) {
        this.myParameterName = parameter;
        this.myOperator = operator;
        this.myMatch = match == null ? null : match.toLowerCase();
    }

    @Override
    public boolean test(TariffDAGNode node) {
        Map<String, Object> params = null;
        try {
            params = node.getParameters();
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "ratingperiod", 0, "Unexpected response when requesting parameter on node during search.", false);
            return false;
        }
        for (String key : params.keySet()) {
            Object o;
            if (key.indexOf(this.myParameterName) < 0 || !this.evaluate(o = params.get(key))) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateNull() {
        boolean matchIsEmpty = false;
        if (this.myMatch == null || "".equals(this.myMatch)) {
            matchIsEmpty = true;
        }
        if (this.myOperator == 1) {
            return !matchIsEmpty;
        }
        return matchIsEmpty;
    }

    /*
     * Unable to fully structure code
     */
    private boolean evaluate(Object v) {
        block14: {
            rc = false;
            if (v == null) {
                return this.evaluateNull();
            }
            str = v.toString().toLowerCase();
            if (StringUtil.isEmptyString(this.myMatch)) break block14;
            switch (this.myOperator) {
                case 0: 
                case 1: {
                    if (!(v instanceof Number)) ** GOTO lbl19
                    try {
                        match = Double.parseDouble(this.myMatch);
                        val = ((Number)v).doubleValue();
                        if (Math.abs(match - val) < 1.0E-10) {
                            rc = true;
                        }
                        ** GOTO lbl20
                    }
                    catch (NumberFormatException x) {
                        rc = false;
                    }
                    ** GOTO lbl20
lbl19:
                    // 1 sources

                    rc = str.equals(this.myMatch);
lbl20:
                    // 4 sources

                    if (this.myOperator != 1) break;
                    rc = rc == false;
                    break;
                }
                case 2: 
                case 3: {
                    try {
                        match = Double.parseDouble(this.myMatch);
                        val = Double.parseDouble(str);
                        if (this.myOperator == 2) {
                            rc = val > match;
                            break;
                        }
                        rc = val < match;
                    }
                    catch (NumberFormatException x) {
                        rc = false;
                    }
                    break;
                }
                case 4: {
                    rc = str.indexOf(this.myMatch) >= 0;
                    break;
                }
                case 5: {
                    rc = str.startsWith(this.myMatch);
                    break;
                }
                case 6: {
                    rc = str.endsWith(this.myMatch);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation in ParameterPredicate: " + this.myOperator);
                }
            }
        }
        return rc;
    }

    public String getParameterName() {
        return this.myParameterName;
    }

    public int getOperator() {
        return this.myOperator;
    }

    public String getParameterValue() {
        return this.myMatch;
    }
}

