/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.TariffStructureConstants;
import ericsson.ere.xml.XMLUtil;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil
implements TariffStructureConstants {
    public static void cachedPrint(TariffDAGNode tsNode, Node domData, PrintWriter out, int indentLevel, String indentMarker) {
        Object child;
        int i;
        if (indentMarker.length() > 0) {
            for (int i2 = 0; i2 < indentLevel; ++i2) {
                out.print(indentMarker);
            }
        }
        NamedNodeMap attrs = null;
        if (domData.hasAttributes()) {
            attrs = domData.getAttributes();
        }
        NodeList children = domData.getChildNodes();
        out.print("<");
        out.print(domData.getNodeName());
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i3 = 0; i3 < len; ++i3) {
                Node attr = attrs.item(i3);
                out.print(" ");
                out.print(attr.getNodeName());
                out.print("=\"");
                out.print(XMLUtil.escape(attr.getNodeValue()));
                out.print("\"");
            }
        }
        out.print(">");
        int len = children.getLength();
        if (len > 0) {
            if (children.item(0).getNodeType() != 3) {
                out.println();
            }
            for (i = 0; i < len; ++i) {
                child = children.item(i);
                String name = child.getNodeName();
                boolean ignored = false;
                for (int j = 0; j < TREE_TAGS.length; ++j) {
                    if (!TREE_TAGS[j].equals(name)) continue;
                    ignored = true;
                }
                if (ignored) continue;
                DOMUtil.printDOMNode((Node)child, out, indentLevel + 1, indentMarker);
                if (i != 0 || len <= 1 || child.getNodeType() != 3) continue;
                out.println();
            }
        }
        len = tsNode.getChildCount();
        for (i = 0; i < len; ++i) {
            child = (TariffDAGNode)tsNode.getChildAt(i);
            ((TariffDAGNode)child).print(out, indentLevel + 1, indentMarker);
        }
        if (indentMarker.length() > 0) {
            for (i = 0; i < indentLevel; ++i) {
                out.print(indentMarker);
            }
        }
        out.print("</");
        out.print(domData.getNodeName());
        out.println(">");
    }

    public static void printDOMNode(Node node, PrintWriter out, int indentLevel, String indentMarker) {
        XMLUtil.printDOMNode(node, out, indentLevel, indentMarker);
    }

    public static Node adoptNode(Document doc, Node node) {
        return XMLUtil.adoptNode(doc, node);
    }
}

