/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.ere.util.BooleanPredicate;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;

public class BooleanTest
implements NodePredicate {
    static final long serialVersionUID = 1L;
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NOT = "NOT";
    private String myOp;
    private NodePredicate[] myPred;
    private transient BooleanPredicate<TariffDAGNode> myTestPredicate;

    public BooleanTest(String op, List<NodePredicate> predicates) {
        if (predicates == null || predicates.isEmpty()) {
            throw new IllegalArgumentException("Empty predicate list");
        }
        if (op == null || !op.equals(AND) && !op.equals(OR) && !op.equals(NOT)) {
            throw new IllegalArgumentException("Unknown operation: " + op);
        }
        this.myOp = op;
        if (this.myOp.equals(NOT) && predicates.size() > 1) {
            throw new IllegalArgumentException("NOT Operation requires a single predicate");
        }
        this.myPred = predicates.toArray(new NodePredicate[predicates.size()]);
        this.createTestPredicate();
    }

    private void createTestPredicate() {
        BooleanPredicate.Operation op = this.myOp.equals(AND) ? BooleanPredicate.Operation.AND : (this.myOp.equals(OR) ? BooleanPredicate.Operation.OR : BooleanPredicate.Operation.NOT);
        this.myTestPredicate = new BooleanPredicate(op, Arrays.asList(this.myPred));
    }

    @Override
    public boolean test(TariffDAGNode node) {
        return this.myTestPredicate.test(node);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.createTestPredicate();
    }

    public NodePredicate[] getPredicates() {
        return this.myPred;
    }

    public String getOperation() {
        return this.myOp;
    }
}

