/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.selectiontree.SelectionTreeNodeFactoryImpl;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.ratingrules.RatingBuilderErrorHandler;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.w3c.dom.Element;

class TrafficTreeStructureHolder
implements TreeModelListener {
    private final SelectionTree mySelectionTree;
    private Future<TariffStructure> myCachedTreeStructure;
    private static final ScheduledExecutorService myScheduler = Executors.newScheduledThreadPool(2, new BackgroundThreadFactory());
    private final ClassRepository myRepository;
    private final String myRatingPlan;

    TrafficTreeStructureHolder(SelectionTree tree, ClassRepository repository, String ratingPlan) {
        this.mySelectionTree = tree;
        this.myRepository = repository;
        this.myRatingPlan = ratingPlan;
        tree.getTreeRoot().getTreeModel().addTreeModelListener(this);
        tree.getTreeComponent().addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TreeModel oldModel = (TreeModel)evt.getOldValue();
                TreeModel newModel = (TreeModel)evt.getNewValue();
                oldModel.removeTreeModelListener(TrafficTreeStructureHolder.this);
                newModel.addTreeModelListener(TrafficTreeStructureHolder.this);
                TrafficTreeStructureHolder.this.invalidateCachedStructure();
            }
        });
    }

    TariffStructure getSelectionTreeStructure() throws Exception {
        if (this.myCachedTreeStructure == null) {
            return this.buildStructure();
        }
        try {
            return this.myCachedTreeStructure.get();
        }
        catch (ExecutionException ee) {
            throw (Exception)ee.getCause();
        }
    }

    private void invalidateCachedStructure() {
        if (this.myCachedTreeStructure != null) {
            this.myCachedTreeStructure.cancel(true);
            this.myCachedTreeStructure = null;
        }
    }

    void prepareTreeStructure() {
        if (this.myCachedTreeStructure != null) {
            return;
        }
        this.myCachedTreeStructure = myScheduler.submit(new Callable<TariffStructure>(){

            @Override
            public TariffStructure call() throws Exception {
                return TrafficTreeStructureHolder.this.buildStructure();
            }
        });
    }

    private TariffStructure buildStructure() throws Exception {
        TSTariffStructure node = this.mySelectionTree.getTreeRoot();
        Element root = (Element)node.getUpdatedXMLConfiguration();
        SelectionTreeNodeFactoryImpl nodeFactory = new SelectionTreeNodeFactoryImpl(this.myRepository, this.myRatingPlan){

            @Override
            public TariffStructureNode finish(TariffStructureNode structure) {
                return structure;
            }
        };
        RatingBuilderErrorHandler errorHandler = new RatingBuilderErrorHandler();
        RatingRuleBuilder builder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        TariffStructure rStructure = (TariffStructure)builder.buildFromElement(root, null);
        return rStructure;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.invalidateCachedStructure();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.invalidateCachedStructure();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.invalidateCachedStructure();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.invalidateCachedStructure();
    }

    private static class BackgroundThreadFactory
    implements ThreadFactory {
        final AtomicInteger myNum = new AtomicInteger(0);
        final ThreadGroup myGroup;

        BackgroundThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.myGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.myGroup, r, "tree-builder-thread-" + this.myNum.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(3);
            return t;
        }
    }
}

