/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.defs.FieldDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;

public class ClassRepositoryGui {
    private ClassRepository repository;

    public ClassRepositoryGui(ClassRepository repository) {
        this.repository = repository;
    }

    public JComboBox getConditionSelect() {
        return new JComboBox<Object>(this.repository.getDefinedConditionList().toArray());
    }

    public JComboBox getConditionComboBox(String selected) {
        JComboBox<Object> comboBox = new JComboBox<Object>(this.repository.getDefinedConditionList().toArray());
        comboBox.setSelectedItem(selected);
        return comboBox;
    }

    public JComboBox getModifierComboBox(String selected) {
        JComboBox<Object> comboBox = new JComboBox<Object>(this.repository.getModifierList().toArray());
        comboBox.setSelectedItem(selected);
        return comboBox;
    }

    public JComboBox getFieldCombo(String selected, int dataType) {
        ArrayList<String> vector = new ArrayList<String>();
        List<FieldDefinition> defs = this.repository.getFieldDefinitions();
        for (int ii = 0; ii < defs.size(); ++ii) {
            FieldDefinition current = defs.get(ii);
            if (current.getDatatype() != dataType) continue;
            vector.add(current.getFieldName());
        }
        JComboBox<Object> comboBox = new JComboBox<Object>(vector.toArray());
        comboBox.setSelectedItem(selected);
        return comboBox;
    }

    public JComboBox geNumerictFieldCombo(String selected) {
        ArrayList<String> vector = new ArrayList<String>();
        List<FieldDefinition> defs = this.repository.getFieldDefinitions();
        for (int ii = 0; ii < defs.size(); ++ii) {
            FieldDefinition current = defs.get(ii);
            if (current.getDatatype() != 10 && current.getDatatype() != 12 && current.getDatatype() != 11) continue;
            vector.add(current.getFieldName());
        }
        JComboBox<Object> comboBox = new JComboBox<Object>(vector.toArray());
        comboBox.setSelectedItem(selected);
        return comboBox;
    }

    public JComboBox getDataTypesCombo(String selected) {
        JComboBox<String> combo = new JComboBox<String>(EreDefs.dataTypeArray);
        combo.setSelectedItem(selected);
        return combo;
    }

    public JComboBox getBaseConditionCombo(String selected) {
        JComboBox<Object> combo = new JComboBox<Object>(this.repository.getBaseConditionList().toArray());
        combo.setSelectedItem(selected);
        return combo;
    }
}

