/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.defs.STQRepositories;
import com.ericsson.ere.defs.STQRepository;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.util.ClosableVarPanel;
import com.ericsson.ere.swing.AbstractListModelBasedPanel;
import com.ericsson.vareditor.TitleRenderer;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.AbstractSearchPanel;
import ericsson.ere.gui.ratingrules.FindPalette;
import ericsson.ere.gui.ratingrules.SelectorPanel;
import ericsson.ere.gui.ratingrules.SelectorType;
import ericsson.ere.gui.ratingrules.nodes.BooleanTest;
import ericsson.ere.gui.ratingrules.nodes.Finder;
import ericsson.ere.gui.ratingrules.nodes.FinderResultListCellRenderer;
import ericsson.ere.gui.ratingrules.nodes.FinderResultListSelectionListener;
import ericsson.ere.gui.ratingrules.nodes.NodeIdMatch;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.util.ArrayListModel;
import ericsson.ere.gui.util.GuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreeModel;

public class AdvancedSearchPanel
extends AbstractSearchPanel {
    private JPanel myPredicatePanel;
    private ArrayListModel<FindPalette.PredicateHolder> myPredicateModel;
    private Action myRemovePredicateAction = new RemovePredicateAction();
    private JComboBox myOperation = new JComboBox<String>(FindPalette.OPERATIONS);
    private JComponent myAddPredicateButton;
    private JButton myFindButton;
    private SelectionTree myTree;
    private JCheckBox myLinkChecked;
    private JCheckBox myRootChecked;
    private JCheckBox myInverseChecked;
    private JLabel myEmptySearchResultLabel;
    private int myMaxNumberOfPredicates = 7;
    private EventListener myListener;
    private JList mySearchResultList;

    private AdvancedSearchPanel(final Vector<String> selectors, int maximumNumberOfPredicates) {
        this.setLayout(new BorderLayout());
        this.myMaxNumberOfPredicates = maximumNumberOfPredicates;
        EventHandler handler = new EventHandler();
        this.myRemovePredicateAction.setEnabled(false);
        this.myAddPredicateButton = new JButton(new AddPredicateAction());
        this.myPredicateModel = new ArrayListModel();
        this.myPredicateModel.addListDataListener(handler);
        this.myPredicatePanel = new SelectorPanelContainer(){

            @Override
            protected Vector<String> getOrCreateSelectors() {
                return selectors;
            }
        };
        this.myPredicatePanel.addContainerListener(handler);
        JPanel predicatePanel = this.createPredicatePanel();
        ClosableVarPanel cvp = new ClosableVarPanel(new PredicatePanelRenderer("of the following statements in one element"), false, Arrays.asList(predicatePanel), false);
        this.add((Component)cvp, "Center");
        this.myPredicateModel.add(new FindPalette.PredicateHolder(this.createDefaultEmptyPredicate()));
    }

    private AdvancedSearchPanel(Action searchAction, SelectionTree tree) {
        this.setLayout(new GridBagLayout());
        EventHandler handler = new EventHandler();
        this.myRemovePredicateAction.setEnabled(false);
        this.myAddPredicateButton = new JButton(new AddPredicateAction());
        this.myPredicateModel = new ArrayListModel();
        this.myPredicateModel.addListDataListener(handler);
        this.myPredicatePanel = new SelectorPanelContainer();
        this.myPredicatePanel.addContainerListener(handler);
        Insets insets = new Insets(5, 5, 0, 5);
        JPanel predicatePanel = this.createPredicatePanel();
        ClosableVarPanel cvp = new ClosableVarPanel(new PredicatePanelRenderer(), false, Arrays.asList(predicatePanel), false);
        this.add((Component)cvp, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        Box buttonBox = this.createButtonBox(searchAction);
        this.add((Component)buttonBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 512, 2, insets, 0, 0));
        JScrollPane resultScrollPanel = this.createResultList(tree);
        this.add((Component)resultScrollPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.myPredicateModel.add(new FindPalette.PredicateHolder(this.createDefaultEmptyPredicate()));
    }

    public static AdvancedSearchPanel buildPanelWithPredicates(Vector<String> selectors, int maximumNumberOfPredicates) {
        return new AdvancedSearchPanel(selectors, maximumNumberOfPredicates);
    }

    public static AdvancedSearchPanel buildPanelWithPredicatesAndResultView(Action searchAction, SelectionTree tree) {
        return new AdvancedSearchPanel(searchAction, tree);
    }

    private JPanel createPredicatePanel() {
        JPanel predicatePanel = new JPanel(new GridBagLayout());
        predicatePanel.add((Component)this.myPredicatePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
        predicatePanel.add((Component)this.myAddPredicateButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 0, 5, 5), 0, 0));
        return predicatePanel;
    }

    private JScrollPane createResultList(SelectionTree tree) {
        this.myTree = tree;
        this.mySearchResultList = new JList();
        this.mySearchResultList.getSelectionModel().setSelectionMode(0);
        this.mySearchResultList.setCellRenderer(new FinderResultListCellRenderer());
        this.mySearchResultList.addListSelectionListener(new FinderResultListSelectionListener(this.myTree.getTreeComponent(), this.mySearchResultList));
        JScrollPane scrollPanel = new JScrollPane(this.mySearchResultList);
        return scrollPanel;
    }

    private Box createButtonBox(Action searchAction) {
        this.myLinkChecked = new JCheckBox(FindPalette.LINKS_LBL);
        this.myRootChecked = new JCheckBox(FindPalette.ROOT_LBL, true);
        this.myInverseChecked = new JCheckBox(FindPalette.INVERSE_LBL);
        this.myFindButton = new JButton(searchAction);
        this.myEmptySearchResultLabel = new JLabel(RmaDefs.getStringResource("ratingrules.find.no.matches"));
        this.myEmptySearchResultLabel.setVisible(false);
        this.myEmptySearchResultLabel.setForeground(Color.RED);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(this.myRootChecked);
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(this.myLinkChecked);
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(this.myInverseChecked);
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(this.myEmptySearchResultLabel);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.myFindButton);
        return buttonBox;
    }

    private JComponent createRemoveButton() {
        return this.createToolbarButton(this.myRemovePredicateAction);
    }

    private JComponent createToolbarButton(Action a) {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setOpaque(false);
        toolbar.setBorder(BorderFactory.createEmptyBorder());
        toolbar.setBorderPainted(false);
        toolbar.add(a);
        return toolbar;
    }

    private NodePredicate createDefaultEmptyPredicate() {
        return new NodeIdMatch("", 1, false);
    }

    public boolean isLinkChecked() {
        return this.myLinkChecked.isSelected();
    }

    public boolean isRootChecked() {
        return this.myRootChecked.isSelected();
    }

    public boolean isInverseChecked() {
        return this.myInverseChecked.isSelected();
    }

    public Object getSelectedOperation() {
        return this.myOperation.getSelectedItem();
    }

    public ArrayListModel<FindPalette.PredicateHolder> getPredicateModel() {
        return this.myPredicateModel;
    }

    public void populatePanel(BooleanTest predicate) {
        NodePredicate[] predicates;
        if (predicate == null) {
            predicates = new NodePredicate[]{this.createDefaultEmptyPredicate()};
        } else {
            predicates = predicate.getPredicates();
            if ("OR".equals(predicate.getOperation())) {
                this.myOperation.setSelectedIndex(1);
            }
        }
        this.myPredicateModel.clear();
        for (NodePredicate p : predicates) {
            FindPalette.PredicateHolder ph = new FindPalette.PredicateHolder(p);
            SelectorPanel selectorPanel = ((SelectorPanelContainer)this.myPredicatePanel).createComponentForValue(ph);
            selectorPanel.init(p);
            ph.selectorPanel = selectorPanel;
            this.myPredicateModel.add(ph);
        }
        this.addPanelChangeListener(this.myListener);
    }

    @Override
    public void setResultModel(ListModel model) {
        this.mySearchResultList.setModel(model);
    }

    public BooleanTest createAdvancedPredicate() {
        ArrayList<NodePredicate> predicates = new ArrayList<NodePredicate>();
        for (FindPalette.PredicateHolder ph : this.getPredicateModel()) {
            predicates.add(ph.selectorPanel.createPredicate());
        }
        boolean allSelected = FindPalette.OPERATIONS[0].equals(this.getSelectedOperation());
        return (BooleanTest)Finder.createComplexPredicate(predicates, allSelected);
    }

    public void addPanelChangeListener(EventListener listener) {
        this.myListener = listener;
        this.myOperation.addItemListener((ItemListener)listener);
        for (FindPalette.PredicateHolder ph : this.myPredicateModel) {
            ph.selectorPanel.addPanelChangeListener(listener);
        }
        ((JButton)this.myAddPredicateButton).addActionListener((ActionListener)listener);
    }

    public void showEmptyResult(boolean visible) {
        this.myEmptySearchResultLabel.setVisible(visible);
    }

    private class RemovePredicateAction
    extends AbstractAction {
        RemovePredicateAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("new_tableDeleteRow.gif"));
            this.putValue("ShortDescription", RmaDefs.getStringResource("ratingrules.find.labels.matcher.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectorPanel sp = GuiUtil.getClosestParentOfClass((Component)e.getSource(), SelectorPanel.class);
            FindPalette.PredicateHolder predicateToRemove = null;
            for (FindPalette.PredicateHolder holder : AdvancedSearchPanel.this.myPredicateModel) {
                if (holder.selectorPanel != sp) continue;
                predicateToRemove = holder;
                break;
            }
            if (predicateToRemove != null) {
                AdvancedSearchPanel.this.myPredicateModel.remove(predicateToRemove);
            }
        }
    }

    private class AddPredicateAction
    extends AbstractAction {
        AddPredicateAction() {
            this.putValue("Name", RmaDefs.getStringResource("ratingrules.find.labels.matcher.add"));
            this.putValue("SmallIcon", RmaDefs.getImageIcon("new_tableAddRowBelow.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedSearchPanel.this.myPredicateModel.add(new FindPalette.PredicateHolder(AdvancedSearchPanel.this.createDefaultEmptyPredicate()));
        }
    }

    private class EventHandler
    extends ContainerAdapter
    implements ListDataListener {
        private EventHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.refresh();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.refresh();
        }

        private void refresh() {
            AdvancedSearchPanel.this.myPredicatePanel.revalidate();
            AdvancedSearchPanel.this.myPredicatePanel.repaint();
            AdvancedSearchPanel.this.myAddPredicateButton.setVisible(AdvancedSearchPanel.this.myPredicateModel.size() < AdvancedSearchPanel.this.myMaxNumberOfPredicates);
            AdvancedSearchPanel.this.myRemovePredicateAction.setEnabled(AdvancedSearchPanel.this.myPredicateModel.size() > 1);
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof SelectorPanel) {
                ((SelectorPanel)c).activated();
            }
        }
    }

    private class SelectorPanelContainer
    extends AbstractListModelBasedPanel<FindPalette.PredicateHolder, SelectorPanel> {
        private Vector<String> mySelectors;

        private SelectorPanelContainer() {
            super(AdvancedSearchPanel.this.myPredicateModel, 5);
        }

        @Override
        protected SelectorPanel createComponentForValue(FindPalette.PredicateHolder value) {
            SelectorPanel panel;
            NodePredicate predicate = value.predicate;
            SelectorType st = SelectorType.lookup(predicate);
            value.selectorPanel = panel = st.createPanel(predicate, this.createSelectorPicker(st, value), AdvancedSearchPanel.this.createRemoveButton());
            return panel;
        }

        protected Vector<String> getOrCreateSelectors() {
            if (this.mySelectors == null) {
                this.mySelectors = new Vector<String>(Arrays.asList(FindPalette.DEFAULT_SELECTORS));
                if (this.shouldIncludeSTQSelectors()) {
                    this.mySelectors.addAll(Arrays.asList(FindPalette.STQ_SELECTORS));
                }
                if (this.shouldIncludeProductTagSelectors()) {
                    this.mySelectors.addAll(Arrays.asList(FindPalette.PRODUCT_TAG_SELECTORS));
                }
            }
            return this.mySelectors;
        }

        private boolean shouldIncludeSTQSelectors() {
            TreeModel model = AdvancedSearchPanel.this.myTree.getTreeComponent().getModel();
            STQRepository stqRepository = STQRepositories.getRepositoryForTreeModel(model);
            return !stqRepository.isRepositoryEmpty();
        }

        private boolean shouldIncludeProductTagSelectors() {
            return Boolean.parseBoolean(AdvancedSearchPanel.this.myTree.getSetting("multi-data-update"));
        }

        private JComponent createSelectorPicker(SelectorType selectorType, FindPalette.PredicateHolder predicateHolder) {
            JComboBox<String> sel = new JComboBox<String>(this.getOrCreateSelectors());
            sel.setSelectedItem(selectorType.text());
            sel.setAction(new SelectorPickerAction(predicateHolder));
            return sel;
        }

        private class SelectorPickerAction
        extends AbstractAction {
            private FindPalette.PredicateHolder myPredicateHolderToReplace;

            private SelectorPickerAction(FindPalette.PredicateHolder predicate) {
                this.myPredicateHolderToReplace = predicate;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String item = (String)((JComboBox)e.getSource()).getSelectedItem();
                if (item != null) {
                    SelectorType st = SelectorType.lookup(item);
                    int index = AdvancedSearchPanel.this.myPredicateModel.indexOf(this.myPredicateHolderToReplace);
                    AdvancedSearchPanel.this.myPredicateModel.set(index, new FindPalette.PredicateHolder(st.createNewPredicate()));
                }
            }
        }
    }

    private class PredicatePanelRenderer
    extends JPanel
    implements TitleRenderer {
        private JLabel myDummyLabel;

        PredicatePanelRenderer() {
            super(new FlowLayout(3, 5, 0));
            this.myDummyLabel = new JLabel();
            this.initPanel(FindPalette.MATCHCONT_LBL);
        }

        PredicatePanelRenderer(String textAfterOperations) {
            super(new FlowLayout(3, 5, 0));
            this.myDummyLabel = new JLabel();
            this.initPanel(textAfterOperations);
        }

        private void initPanel(String textAfterOperation) {
            this.add(new JLabel(FindPalette.MATCH_LBL));
            this.add(AdvancedSearchPanel.this.myOperation);
            this.add(new JLabel(textAfterOperation));
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public JLabel getLabel() {
            return this.myDummyLabel;
        }

        @Override
        public String getLabelText() {
            return "";
        }

        @Override
        public String getTitle() {
            return "";
        }

        @Override
        public void setLabelText(String text) {
        }
    }
}

