/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log.logtable;

import com.ericsson.ere.swing.table.FilterableTableModel;
import ericsson.vareditor.variable.validator.TableVariableValidator;
import java.util.regex.Pattern;

public class NumberListTableModel
extends FilterableTableModel<String> {
    private String mySearchFilter = "";
    private TableVariableValidator myValidator;

    public NumberListTableModel(TableVariableValidator val) {
        this.myValidator = val;
    }

    public NumberListTableModel(String value, TableVariableValidator val) {
        this.myValidator = val;
        this.populateModel(value);
    }

    public NumberListTableModel(String value, TableVariableValidator val, Pattern delimiter) {
        this.myValidator = val;
        this.populateModel(value, delimiter);
    }

    public void add(String str) {
        if (this.mySearchFilter.equals("")) {
            super.protAdd(str);
        } else {
            this.myEntries.add(str);
            this.myVisibleEntries.add(str);
            this.fireTableDataChanged();
        }
    }

    public void populateModel(String str) {
        this.populateModel(str, Pattern.compile(","));
    }

    private void populateModel(String str, Pattern delimiter) {
        this.clearAllEntries();
        String[] input = delimiter.split(str);
        for (int i = 0; i < input.length; ++i) {
            if (input[i].equals("") || this.myValidator.isValueInModel(input[i], this.getValueString())) continue;
            super.protAdd(input[i]);
        }
    }

    @Override
    protected boolean shouldEntryBeVisible(String str, int index) {
        if (this.mySearchFilter.equals("")) {
            return true;
        }
        return this.myValidator.isValueInModel(this.mySearchFilter, str);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myVisibleEntries.get(rowIndex);
    }

    public String getValueString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.myEntries.size(); ++i) {
            builder.append((String)this.myEntries.get(i));
            if (i + 1 == this.myEntries.size()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    @Override
    public void refresh() {
    }

    public void setSearchFilter(String str) {
        this.mySearchFilter = str;
        this.updateVisibleEntries();
    }

    public String getSearchFilter() {
        return this.mySearchFilter;
    }

    public TableVariableValidator getValidator() {
        return this.myValidator;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String get = (String)this.myVisibleEntries.get(rowIndex);
        if (this.mySearchFilter.equals("")) {
            this.myEntries.set(rowIndex, (String)value);
        } else {
            for (int i = 0; i < this.myEntries.size(); ++i) {
                if (!((String)this.myEntries.get(i)).equals(get)) continue;
                this.myEntries.set(i, (String)value);
                break;
            }
        }
        this.myVisibleEntries.set(rowIndex, (String)value);
    }
}

