/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log.logtable;

import com.ericsson.ere.swing.table.FilterableTableModel;
import com.ericsson.ere.util.CompressedString;
import ericsson.ere.gui.log.LogEntryReader;
import ericsson.ere.gui.log.logtable.LogTableEntry;
import ericsson.ere.gui.log.logtable.LogTableModelInterface;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class FileBackedLogTableModel
extends FilterableTableModel<LogTableEntry>
implements LogTableModelInterface {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
    private String myLocationFilter = "";
    private String mySearchFilter = "";
    private int myMaxEntries = 300;
    private File myBackingFile;
    static final String COL_ENTRY = "Entry";
    static final String COL_TIME = "Time";
    static final String COL_LOCATION = "Location";
    static final String COL_LEVEL = "Level";
    static final String COL_MESSAGE = "Message";
    static final String[] colNames = new String[]{"Entry", "Time", "Location", "Level", "Message"};

    public FileBackedLogTableModel(File backingFile) {
        this.myBackingFile = backingFile;
    }

    protected void populateModel() {
        if (this.myBackingFile == null) {
            return;
        }
        LinkedList<LogTableEntry> entries = new LinkedList<LogTableEntry>();
        try {
            LogEntryReader.LogEntry entry;
            LogEntryReader reader = new LogEntryReader(this.myBackingFile);
            for (int logEntryRows = 0; logEntryRows < this.myMaxEntries && (entry = reader.readLogEntry()) != null; ++logEntryRows) {
                LogTableEntry ltentry = this.entryFromLogEntry(entry);
                entries.add(0, ltentry);
            }
        }
        catch (IOException e) {
            LogRecord record = new LogRecord(Level.WARNING, "Failed to read from the log file: " + e.getMessage());
            record.setSourceClassName(this.getClass().getName());
            record.setSourceMethodName("populateModelFromFile");
            entries.add(this.entryFromRecord(record));
        }
        this.myEntries.clear();
        this.myEntries.addAll(entries);
        this.updateVisibleEntries();
    }

    @Override
    public String getColumnName(int column) {
        return colNames[column];
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            LogTableEntry tEntry = (LogTableEntry)this.myVisibleEntries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return tEntry.sequenceNumber;
                }
                case 1: {
                    return tEntry.timeString;
                }
                case 2: {
                    return tEntry.source;
                }
                case 3: {
                    return tEntry.level;
                }
                case 4: {
                    return tEntry.message.getPreview();
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    private LogTableEntry entryFromRecord(LogRecord record) {
        LogTableEntry tEntry = new LogTableEntry();
        Date date = new Date(record.getMillis());
        tEntry.timeString = this.formatter.format(date);
        tEntry.timeInMillis = record.getMillis();
        tEntry.source = record.getSourceClassName() + "::" + record.getSourceMethodName();
        tEntry.level = record.getLevel();
        tEntry.levelString = tEntry.level.getName();
        tEntry.getLoggerName = record.getLoggerName();
        tEntry.message = new CompressedString(record.getMessage());
        tEntry.sequenceNumber = record.getSequenceNumber();
        return tEntry;
    }

    private LogTableEntry entryFromLogEntry(LogEntryReader.LogEntry entry) {
        LogTableEntry tEntry = new LogTableEntry();
        Date date = new Date(entry.getMillis());
        tEntry.timeString = this.formatter.format(date);
        tEntry.timeInMillis = entry.getMillis();
        tEntry.source = entry.getSource().replace(" ", "::");
        tEntry.level = entry.getLevel();
        tEntry.levelString = tEntry.level.getName();
        tEntry.getLoggerName = null;
        tEntry.message = new CompressedString(entry.getMessage());
        tEntry.sequenceNumber = entry.getSequenceNumber();
        return tEntry;
    }

    @Override
    protected boolean shouldEntryBeVisible(LogTableEntry tEntry, int index) {
        if (index < this.myEntries.size() - this.myMaxEntries) {
            return false;
        }
        return tEntry.source.contains(this.myLocationFilter) && (tEntry.message.getPreview().contains(this.mySearchFilter) || tEntry.message.toString().contains(this.mySearchFilter));
    }

    @Override
    public void setMaxEntries(int maxEntries) {
        if (maxEntries != this.myMaxEntries) {
            if (maxEntries < this.myMaxEntries) {
                this.myMaxEntries = maxEntries;
                this.updateVisibleEntries();
            } else {
                this.myMaxEntries = maxEntries;
                this.populateModel();
            }
        }
    }

    @Override
    public void limitVisibleLocation(String text) {
        this.myLocationFilter = text;
        this.updateVisibleEntries();
    }

    @Override
    public void limitVisibleSearch(String text) {
        this.mySearchFilter = text;
        this.updateVisibleEntries();
    }

    @Override
    public void clearLogEntry(LogTableEntry anyEntry) {
        int index = this.myVisibleEntries.indexOf(anyEntry);
        this.myEntries.remove(anyEntry);
        this.myVisibleEntries.remove(anyEntry);
        if (index >= 0) {
            this.fireTableRowsDeleted(index, index);
        }
    }

    @Override
    public void add(LogRecord obj) {
        LogTableEntry tEntry = this.entryFromRecord(obj);
        super.protAdd(tEntry);
        while (this.getRowCount() > this.myMaxEntries) {
            this.myVisibleEntries.remove(0);
            this.fireTableRowsDeleted(0, 0);
        }
    }

    @Override
    public void refresh() {
        this.populateModel();
    }
}

