/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.log.LogHandler;
import ericsson.ere.gui.log.logfile.LogFile;
import ericsson.ere.gui.log.logfile.PlainFileFormatter;
import ericsson.ere.gui.log.logfile.TempLogFileFormatter;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.XMLFormatter;

public final class LogConfig {
    private static final LogConfig INSTANCE = new LogConfig();
    public static final Level DEFAULT_LEVEL = Level.INFO;
    private LogHandler myLogHandler = new LogHandler();
    private File myTempLogFile;
    private LogFile myLogFileHandler;
    private LogFile myTempLogFileHandler;
    private boolean myIsConfigured = false;

    private LogConfig() {
    }

    public static LogConfig getInstance() {
        return INSTANCE;
    }

    public synchronized void configureLogging() {
        this.myIsConfigured = true;
        this.cleanupTemporaryLogging();
        this.createTemporaryLogFile();
        this.updateConfigurationWithTempLogFile();
    }

    private void cleanupTemporaryLogging() {
        if (this.myTempLogFileHandler != null) {
            this.myTempLogFileHandler.close();
            this.myLogHandler.removeOutput(this.myTempLogFileHandler);
            this.myTempLogFile.delete();
            this.myTempLogFile = null;
        }
    }

    private void createTemporaryLogFile() {
        try {
            this.myTempLogFile = this.createTempLogFile();
        }
        catch (IOException ex) {
            System.err.println("Failed to create the temporary log file. Logging will be disabled.");
            ex.printStackTrace(System.err);
            this.myTempLogFile = null;
        }
    }

    private File createTempLogFile() throws IOException {
        File f = File.createTempFile("rma_temp_log", null);
        f.deleteOnExit();
        return f;
    }

    public LogHandler getHandler() {
        this.checkConfigured();
        return this.myLogHandler;
    }

    public synchronized void updateConfiguration() {
        this.checkConfigured();
        Properties prop = RmaDefs.getInstance().properties;
        if (this.myLogFileHandler != null) {
            this.myLogFileHandler.close();
            this.myLogHandler.removeOutput(this.myLogFileHandler);
            this.myLogFileHandler = null;
        }
        String logLevelText = prop.getProperty(RmaDefs.PROP_LOG_LEVEL, DEFAULT_LEVEL.toString());
        Level level = Level.parse(logLevelText);
        LogHandler handler = LogConfig.getInstance().getHandler();
        handler.setLevel(level);
        handler.reRegisterLevel(level);
        String useFile = prop.getProperty(RmaDefs.PROP_LOG_USE_FILE, "false");
        if (Boolean.parseBoolean(useFile)) {
            String fileFormat = prop.getProperty(RmaDefs.PROP_LOG_FILE_FORMAT, "Plain");
            String fn = prop.getProperty(RmaDefs.PROP_LOG_FILENAME);
            if (fn != null && fn.length() > 0) {
                File file = new File(fn);
                Formatter tFormatter = "xml".equalsIgnoreCase(fileFormat) ? new XMLFormatter() : new PlainFileFormatter();
                this.myLogFileHandler = new LogFile(file, tFormatter);
                this.myLogHandler.addOutput(this.myLogFileHandler);
            }
        }
    }

    private void updateConfigurationWithTempLogFile() {
        this.updateConfiguration();
        if (this.myTempLogFile != null) {
            TempLogFileFormatter tempFileFormatter = new TempLogFileFormatter();
            this.myTempLogFileHandler = new LogFile(this.myTempLogFile, tempFileFormatter, false);
            this.myLogHandler.addOutput(this.myTempLogFileHandler);
        }
    }

    File getTemporaryLogFile() {
        this.checkConfigured();
        return this.myTempLogFile;
    }

    private void checkConfigured() {
        if (!this.myIsConfigured) {
            throw new IllegalStateException("Logging has not been configured.");
        }
    }
}

