/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui;

import com.ericsson.ere.defs.SettingsRepository;
import com.ericsson.ere.gui.util.SystemPropertyUtil;
import com.ericsson.ere.io.IOCloser;
import com.ericsson.ere.util.HashUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.Rma;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.ElementIterator;
import ericsson.ere.xml.XMLUtil;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Config {
    public static final String SYSTEM_PROP_RMA_CONFIG_PREFIX = "rma.config.";
    public static final String ROOT_TAG = "RmaConfig";
    public static final String TMA_LOCAL_ROOT_TAG = "TmaLocalConfig";
    public static final String USER_CONFIG_DIR = File.separatorChar + ".rma";
    public static final String NODE_CONFIG_FILE = "NodeConfiguration.xml";
    public static final String CONNECTOR_TYPE_FILE = "ConnectorTypes.xml";
    public static final String NODE_TYPE_FILE = "NodeTypes.xml";
    public static final String RMA_PROPERTIES_FILE = "RmaProperties.xml";
    public static final String UTILITIES_FILE = "Utilities.xml";
    public static final String DATABASE_CONFIG_FILE = "DatabaseConfig.xml";
    public static final String DEFAULT_SERVICE_CONDITION_FILE = "DefaultServiceCondition.xml";
    public static final String LOCAL_PROPERTIES_FILE = "LocalProperties.xml";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_ENC = "enc";
    private static final String TAG_PARAMETER = "Parameter";
    private static final String ATTR_PASSWORD = "Password";
    static Config myInstance = new Config();
    Hashtable<String, Vector<Node>> myConfig = new Hashtable();
    Hashtable<String, String> localProperties = new Hashtable();
    Hashtable<String, UserInfo> myUsers = new Hashtable();
    private SettingsRepository mySettings = new SettingsRepository();
    private PropertyChangeSupport myListeners = new PropertyChangeSupport(this);

    private Config() {
    }

    private void saveConfigData(String file, String data) throws IOException {
        try (FileWriter out = new FileWriter(this.asFile(file));){
            out.write(data);
        }
    }

    private Node getPasswordNode(Element rootElement) {
        NodeListIterable nodeIterator = new NodeListIterable(rootElement.getElementsByTagName(TAG_PARAMETER), 1);
        for (Node node : nodeIterator) {
            String name = ((Element)node).getAttribute(ATTR_NAME).trim();
            if (!name.equals(ATTR_PASSWORD)) continue;
            return node;
        }
        return null;
    }

    private boolean isConfigUpdated(Element passwordElement) {
        String enc = passwordElement.getAttribute(ATTR_ENC);
        if (Objects.isNull(enc) || enc.isEmpty()) {
            return this.isPasswordAndEncAttributeUpdated(passwordElement);
        }
        if (!enc.equals(Boolean.TRUE.toString())) {
            RmaDefs.loggerRma.warning("Invalid value for enc in node configuration. Fixing it.");
            passwordElement.setAttribute(ATTR_ENC, Boolean.TRUE.toString());
            return true;
        }
        return false;
    }

    private boolean isPasswordAndEncAttributeUpdated(Element passwordElement) {
        String password = passwordElement.getAttribute(ATTR_VALUE);
        if (!password.isEmpty()) {
            password = HashUtil.hash(password.toCharArray());
            passwordElement.setAttribute(ATTR_VALUE, password);
            passwordElement.setAttribute(ATTR_ENC, Boolean.TRUE.toString());
            return true;
        }
        RmaDefs.loggerRma.warning("Empty password value in node configuration. Please reset the password.");
        return false;
    }

    public static Config getInstance() {
        return myInstance;
    }

    public void readConfig() {
        LinkedList<Object> configItems = new LinkedList<Object>();
        for (Object key : System.getProperties().keySet()) {
            if (!key.toString().toLowerCase().startsWith(SYSTEM_PROP_RMA_CONFIG_PREFIX.toLowerCase()) && !key.toString().toLowerCase().startsWith("jnlp.rma.config.".toLowerCase())) continue;
            String configResource = System.getProperty((String)key);
            if (!configResource.startsWith("/")) {
                configResource = "/" + configResource;
            }
            configItems.add(configResource);
        }
        configItems.add(this.asFile(NODE_CONFIG_FILE));
        configItems.add(this.asResource(CONNECTOR_TYPE_FILE));
        configItems.add(this.asResource(NODE_TYPE_FILE));
        configItems.add(this.asFile(NODE_TYPE_FILE));
        configItems.add(this.asFile(RMA_PROPERTIES_FILE));
        configItems.add(this.asResource(UTILITIES_FILE));
        configItems.add(this.asFile(UTILITIES_FILE));
        configItems.add(this.asResource(DEFAULT_SERVICE_CONDITION_FILE));
        configItems.add(this.asFile(DATABASE_CONFIG_FILE));
        for (Object item : configItems) {
            try {
                if (item instanceof File && ((File)item).exists()) {
                    this.loadConfigFromFile((File)item);
                    continue;
                }
                if (!(item instanceof String)) continue;
                this.loadConfigFromResource((String)item);
            }
            catch (Exception ex) {
                String msg = "Failed to read configuration from ";
                msg = item instanceof File ? msg + "file" : msg + "resource";
                msg = msg + " '" + item.toString() + "'. Reason: " + ex.getMessage();
                RmaDefs.loggerNavigator.log(Level.WARNING, msg);
            }
        }
        try {
            this.readLocalProperties();
        }
        catch (Exception ex) {
            RmaDefs.loggerNavigator.log(Level.WARNING, "Failed to read local properties. Reason: " + ex.getMessage());
        }
    }

    private String asResource(String name) {
        return "/config/" + name;
    }

    private File asFile(String name) {
        return new File(this.getUserDir() + File.separatorChar + name);
    }

    private void readLocalProperties() throws IOException {
        Element rootElement;
        File localPropertiesFile = this.asFile(LOCAL_PROPERTIES_FILE);
        if (!localPropertiesFile.exists()) {
            return;
        }
        try {
            rootElement = XMLUtil.buildDocumentFromFile(localPropertiesFile).getDocumentElement();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        for (Node property : new NodeListIterable(rootElement.getElementsByTagName("Property"), 1)) {
            String name = ((Element)property).getAttribute(ATTR_NAME).trim();
            String value = ((Element)property).getAttribute(ATTR_VALUE).trim();
            if (StringUtil.isEmptyString(name)) continue;
            this.localProperties.put(name, value);
        }
    }

    public String getLocalProperty(String key, String defaultValue) {
        String result = null;
        result = this.localProperties.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public void setLocalProperty(String name, String value) {
        this.localProperties.put(name, value);
        this.saveLocalProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLocalProperties() {
        FileOutputStream fos = null;
        try {
            File localPropertiesFile = this.asFile(LOCAL_PROPERTIES_FILE);
            Document tDoc = XMLUtil.createEmptyDocument();
            Element rootElement = tDoc.createElement(TMA_LOCAL_ROOT_TAG);
            tDoc.appendChild(rootElement);
            for (String name : this.localProperties.keySet()) {
                Element property = tDoc.createElement("Property");
                property.setAttribute(ATTR_NAME, name);
                property.setAttribute(ATTR_VALUE, this.localProperties.get(name));
                rootElement.appendChild(property);
            }
            fos = new FileOutputStream(localPropertiesFile);
            try {
                DomWriter.elementToStream(tDoc.getDocumentElement(), new PrintWriter(fos));
            }
            finally {
                fos.close();
            }
            IOCloser.closeIgnoringException(fos);
        }
        catch (IOException ex) {
            RmaDefs.loggerNavigator.log(Level.WARNING, "Failed to save local properties. Reason: " + ex.getMessage());
        }
        finally {
            IOCloser.closeIgnoringException(fos);
        }
    }

    @Deprecated
    public void readConfig(File dir) {
        this.readConfigFromDirectory(dir);
    }

    public void readConfigFromDirectory(File dir) {
        if (dir.isDirectory()) {
            for (String file : dir.list()) {
                File f = new File(dir, file);
                if (!f.isFile()) continue;
                try {
                    this.loadConfigFromFile(f);
                }
                catch (Exception ex) {
                    RmaDefs.loggerNavigator.config("Failed to read configuration from '" + f.getName() + "'. Reason: " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig(String file, String data) throws IOException {
        try (FileWriter out = new FileWriter(this.asFile(file));){
            out.write("<RmaConfig>\n");
            out.write(data);
            out.write("</RmaConfig>\n");
        }
    }

    public Vector<Node> getConfigFor(String type) {
        return this.myConfig.get(type);
    }

    public void reloadNodeConfig() {
        this.myConfig.remove("NodeList");
        File f = this.asFile(NODE_CONFIG_FILE);
        try {
            this.loadConfigFromFile(f);
        }
        catch (Exception ex) {
            RmaDefs.loggerNavigator.log(Level.WARNING, "Failed to reload node configuration from '" + f.getName() + "'. Reason: " + ex.getMessage());
        }
    }

    public void reloadDatabaseConfig() {
        this.myConfig.remove("DatabaseConfig");
        File f = this.asFile(DATABASE_CONFIG_FILE);
        try {
            this.loadConfigFromFile(f);
        }
        catch (Exception ex) {
            RmaDefs.loggerNavigator.log(Level.WARNING, "Failed to reload database configuration from '" + f.getName() + "'. Reason: " + ex.getMessage());
        }
    }

    private void ensureUserDirExists(String userDir) {
        File f = new File(userDir);
        if (!f.exists()) {
            if (GraphicsEnvironment.isHeadless() || Boolean.parseBoolean(SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix("disable.rma.mkdir.info.dialog"))) {
                RmaDefs.loggerRma.info("Headless environment - creating configuration directory silently at: " + userDir);
            } else {
                DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA Startup", "Welcome to RMA.\nRMA needs somewhere to store its configuration data and\na configuration directory will therefore be created at this path:\n" + userDir);
            }
            if (!f.mkdir()) {
                RmaDefs.loggerRma.warning("Failed to create storage for own configuration data. Changes will not be saved.");
            }
        }
    }

    private String getUserBaseDirOverride() {
        String ret = null;
        String override = Config.settings().getValue(Rma.RMA_ARG_USERDIR_BASE_OVERRIDE);
        if (override != null) {
            File f = new File(override);
            if (f.exists()) {
                ret = override;
            } else {
                RmaDefs.loggerRma.warning(String.format("The specified user directory override (%s) does not exist.", override));
            }
        }
        return ret;
    }

    public String getUserDir() {
        String override = this.getUserBaseDirOverride();
        String base = override != null ? override : System.getProperty("user.home");
        String rmaDir = base + USER_CONFIG_DIR;
        this.ensureUserDirExists(rmaDir);
        return rmaDir;
    }

    @Deprecated
    public void readFile(String fname) {
        try {
            this.loadConfigFromResource(fname);
        }
        catch (Exception ex) {
            RmaDefs.loggerRma.warning("Failed to read configuration resource from '" + fname + "': " + ex.getMessage());
        }
    }

    @Deprecated
    public void readFile(File file) {
        try {
            this.loadConfigFromFile(file);
        }
        catch (Exception ex) {
            RmaDefs.loggerRma.warning("Failed to read configuration file: " + ex.getMessage());
        }
    }

    public boolean loadConfigFromFile(File f) throws IOException {
        Document doc;
        try {
            doc = XMLUtil.buildDocumentFromFile(f);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return this.loadConfig(doc.getDocumentElement());
    }

    public boolean loadConfigFromResource(String resourceName) throws IOException {
        Document doc;
        try (InputStream is = this.getClass().getResourceAsStream(resourceName);){
            doc = XMLUtil.buildDocument(is);
        }
        return this.loadConfig(doc.getDocumentElement());
    }

    public boolean loadConfig(Element root) {
        if (root == null || !ROOT_TAG.equalsIgnoreCase(root.getTagName())) {
            return false;
        }
        for (Element keyElement : new ElementIterator(root.getChildNodes())) {
            String key = keyElement.getTagName();
            Vector<Node> configNodes = this.myConfig.get(key);
            if (configNodes == null) {
                configNodes = new Vector();
                this.myConfig.put(key, configNodes);
            }
            boolean added = false;
            for (Element elem : new ElementIterator(keyElement.getChildNodes())) {
                if (this.contains(configNodes, elem)) continue;
                configNodes.add(elem);
                added = true;
            }
            if (!added) continue;
            this.myListeners.firePropertyChange(key, null, configNodes);
        }
        return true;
    }

    private boolean contains(List<? extends Node> nodes, Node node) {
        boolean ret = false;
        for (Node node2 : nodes) {
            if (!node2.isEqualNode(node)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static SettingsRepository settings() {
        return Config.getInstance().mySettings;
    }

    @Deprecated
    public Element getDocumentRoot(String fname) {
        Element root = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(fname);
            root = XMLUtil.buildDocument(is).getDocumentElement();
        }
        catch (Exception e) {
            RmaDefs.loggerNavigator.config("Failed to open '" + fname + "'. Reason: " + e.getMessage());
        }
        return root;
    }

    @Deprecated
    public Element getDocumentRoot(File file) {
        Element root = null;
        try {
            root = XMLUtil.buildDocumentFromFile(file).getDocumentElement();
        }
        catch (Exception e) {
            RmaDefs.loggerNavigator.config("Failed to open '" + file.getName() + "'. Reason: " + e.getMessage());
        }
        return root;
    }

    @Deprecated
    public UserInfo getUserInfo(String username) {
        return this.myUsers.get(username);
    }

    @Deprecated
    public UserInfo addUserInfo(String username, String password) {
        UserInfo ui = new UserInfo(username, password);
        this.myUsers.put(username, ui);
        return ui;
    }

    public void addConfigChangeListener(PropertyChangeListener listener) {
        this.myListeners.addPropertyChangeListener(listener);
    }

    public void addConfigChangeListener(String configKey, PropertyChangeListener listener) {
        this.myListeners.addPropertyChangeListener(configKey, listener);
    }

    public void removeConfigChangeListener(PropertyChangeListener listener) {
        this.myListeners.removePropertyChangeListener(listener);
    }

    public void saveNodeConfig() {
        try {
            Element passwordElement;
            Element rootElement;
            Node passwordNode;
            File nodeConfigFile = this.asFile(NODE_CONFIG_FILE);
            if (nodeConfigFile.exists() && Objects.nonNull(passwordNode = this.getPasswordNode(rootElement = XMLUtil.buildDocumentFromFile(nodeConfigFile).getDocumentElement())) && this.isConfigUpdated(passwordElement = (Element)passwordNode)) {
                this.saveConfigData(NODE_CONFIG_FILE, DomWriter.elementToString(rootElement));
            }
        }
        catch (Exception ex) {
            RmaDefs.loggerRma.warning(String.format("Failed to write node configuration to '%s'. Reason: %s", NODE_CONFIG_FILE, ex.getMessage()));
        }
    }

    public void removeConfigChangeListener(String configKey, PropertyChangeListener listener) {
        this.myListeners.removePropertyChangeListener(configKey, listener);
    }

    public static class UserInfo {
        public String myUsername;
        public String myPassword;

        public UserInfo(String username, String password) {
            this.myUsername = username;
            this.myPassword = password;
        }
    }
}

