/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import java.util.List;

public class PluginName
implements Comparable<PluginName> {
    private String myName;
    private String myAlias = null;

    public PluginName(String name, String alias) {
        this.myName = name;
        if (alias != null && alias.trim().length() > 0) {
            this.myAlias = alias;
        }
    }

    public String getName() {
        return this.myName;
    }

    public String getAlias() {
        if (this.isAlias()) {
            return this.myAlias;
        }
        return this.myName;
    }

    public boolean isAlias() {
        return this.myAlias != null && this.myAlias.trim().length() > 0;
    }

    public String toString() {
        return this.getName();
    }

    public static String[] nameToArray(List<PluginName> list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).getName();
        }
        return array;
    }

    public static String[] aliasToArray(List<PluginName> list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).getAlias();
        }
        return array;
    }

    @Override
    public int compareTo(PluginName o) {
        return this.getAlias().compareTo(o.getAlias());
    }
}

