/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FieldDefinitionHelper {
    public static String getMaxValue(ClassRepository classRepository, String fieldName) {
        return FieldDefinitionHelper.getMaxValue(classRepository.getFieldDefinitionByName(fieldName));
    }

    public static String getMaxValue(FieldDefinition fieldDefinition) {
        String resultValue = null;
        if (fieldDefinition != null && FieldDefinitionHelper.hasRequiredRangeUtil(fieldDefinition)) {
            resultValue = fieldDefinition.getRangeMax();
        }
        return resultValue;
    }

    private static String getRangeValue(FieldDefinition fieldDefinition, boolean fetchMax) {
        String resultValue = null;
        if (fieldDefinition != null && FieldDefinitionHelper.hasRequiredRangeUtil(fieldDefinition)) {
            Element editComponentElement = XMLUtil.getNamedElement("EditComponent", fieldDefinition.getDefinitionNode().getChildNodes());
            NodeList rangeComponents = null;
            if (editComponentElement != null) {
                rangeComponents = editComponentElement.getElementsByTagName("Range");
            }
            Element inputRestrictionElement = XMLUtil.getNamedElement("InputRestriction", fieldDefinition.getDefinitionNode().getChildNodes());
            NodeList rangeComponents2 = null;
            ArrayList<Element> mergedComponents = new ArrayList<Element>();
            if (inputRestrictionElement != null) {
                rangeComponents2 = inputRestrictionElement.getElementsByTagName("Range");
            }
            if (rangeComponents != null) {
                for (int ei = 0; ei < rangeComponents.getLength(); ++ei) {
                    mergedComponents.add((Element)rangeComponents.item(ei));
                }
            }
            int index = mergedComponents.size();
            if (rangeComponents2 != null) {
                for (int ii = 0; ii < rangeComponents2.getLength(); ++ii) {
                    mergedComponents.add(index + ii, (Element)rangeComponents2.item(ii));
                }
            }
            resultValue = FieldDefinitionHelper.getRangeValueString(mergedComponents, fetchMax);
        }
        return resultValue;
    }

    private static String getRangeValueString(List<Element> rangeElements, boolean maxAttribute) {
        String value = null;
        for (Element rangeElement : rangeElements) {
            if (!rangeElement.hasAttributes()) continue;
            if (maxAttribute) {
                if (!rangeElement.getAttribute("Max").equals("")) {
                    value = rangeElement.getAttribute("Max");
                    break;
                }
                value = rangeElement.getAttribute("max");
                break;
            }
            if (!rangeElement.getAttribute("Min").equals("")) {
                value = rangeElement.getAttribute("Min");
                break;
            }
            value = rangeElement.getAttribute("min");
            break;
        }
        return value;
    }

    public static String getMinValue(ClassRepository classRepository, String fieldName) {
        return FieldDefinitionHelper.getMinValue(classRepository.getFieldDefinitionByName(fieldName));
    }

    public static String getMinValue(FieldDefinition fieldDefinition) {
        String resultValue = null;
        if (fieldDefinition != null && FieldDefinitionHelper.hasRequiredRangeUtil(fieldDefinition)) {
            resultValue = fieldDefinition.getRangeMin();
        }
        return resultValue;
    }

    public static String[] getEnumNames(ClassRepository repository, String fieldName) {
        return FieldDefinitionHelper.getEnumNames(repository.getFieldDefinitionByName(fieldName));
    }

    public static String[] getEnumNames(FieldDefinition fieldDefinition) {
        String[] names = null;
        if (fieldDefinition != null && FieldDefinitionHelper.hasRequiredEnumUtil(fieldDefinition)) {
            Element n2;
            ArrayList<String> enumNames = new ArrayList<String>();
            Element n = XMLUtil.getNamedElement("EditComponent", fieldDefinition.getDefinitionNode().getChildNodes());
            List<Element> enumList = null;
            if (n != null) {
                enumList = XMLUtil.getElementNodesNamed("Enum", n.getChildNodes());
            }
            if ((n2 = XMLUtil.getNamedElement("InputRestriction", fieldDefinition.getDefinitionNode().getChildNodes())) != null) {
                List<Element> enumList2 = XMLUtil.getElementNodesNamed("Enum", n2.getChildNodes());
                if (enumList != null) {
                    enumList.addAll(enumList2);
                } else {
                    enumList = new ArrayList<Element>();
                    enumList.addAll(enumList2);
                }
            }
            if (enumList != null && enumList.size() > 0) {
                for (int i = 0; i < enumList.size(); ++i) {
                    Element value = enumList.get(i);
                    if (value.hasAttribute("Name")) {
                        enumNames.add(value.getAttribute("Name"));
                        continue;
                    }
                    if (!value.hasAttribute("name")) continue;
                    enumNames.add(value.getAttribute("name"));
                }
            }
            names = enumNames.toArray(new String[0]);
        }
        return names;
    }

    public static String[] getEnumValues(ClassRepository repository, String fieldName) {
        return FieldDefinitionHelper.getEnumValues(repository.getFieldDefinitionByName(fieldName));
    }

    public static String[] getEnumValues(FieldDefinition fieldDefinition) {
        String[] values = null;
        if (fieldDefinition != null && FieldDefinitionHelper.hasRequiredEnumUtil(fieldDefinition)) {
            ArrayList<String> enumValues = new ArrayList<String>();
            List<Element> enumList = null;
            Element n = XMLUtil.getNamedElement("EditComponent", fieldDefinition.getDefinitionNode().getChildNodes());
            if (n != null) {
                enumList = XMLUtil.getElementNodesNamed("Enum", n.getChildNodes());
            }
            Element n2 = XMLUtil.getNamedElement("InputRestriction", fieldDefinition.getDefinitionNode().getChildNodes());
            List<Element> enumList2 = null;
            if (n2 != null) {
                enumList2 = XMLUtil.getElementNodesNamed("Enum", n2.getChildNodes());
                if (enumList != null) {
                    enumList.addAll(enumList2);
                } else {
                    enumList = new ArrayList<Element>();
                    enumList.addAll(enumList2);
                }
            }
            if (enumList != null) {
                for (Element value : enumList) {
                    if (value.hasAttribute("Value")) {
                        enumValues.add(value.getAttribute("Value"));
                        continue;
                    }
                    if (!value.hasAttribute("value")) continue;
                    enumValues.add(value.getAttribute("value"));
                }
            }
            values = enumValues.toArray(new String[0]);
        }
        return values;
    }

    public static boolean fieldIsWorkingParameter(FieldDefinition field) {
        return "WORKING".equals(field.getParameterType().toUpperCase());
    }

    public static List<String> extractFieldNameList(List<FieldDefinition> fieldList) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (FieldDefinition field : fieldList) {
            nameList.add(field.getCanonicalName());
        }
        return nameList;
    }

    public static List<FieldDefinition> extractFieldDefinitionList(ClassRepository repository, List<String> fieldNames) {
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (String fieldName : fieldNames) {
            FieldDefinition fieldToAdd = repository.getFieldDefinitionByName(fieldName);
            if (fieldToAdd == null) continue;
            fieldDefinitions.add(fieldToAdd);
        }
        return fieldDefinitions;
    }

    public static Map<String, FieldDefinition> createNameToFieldMap(List<FieldDefinition> fields) {
        HashMap<String, FieldDefinition> fieldMap = new HashMap<String, FieldDefinition>();
        for (FieldDefinition field : fields) {
            fieldMap.put(field.getCanonicalName(), field);
        }
        return fieldMap;
    }

    public static Map<String, FieldDefinition> createNameToFieldMap(ClassRepository repository, List<String> fieldNames) {
        HashMap<String, FieldDefinition> fieldMap = new HashMap<String, FieldDefinition>();
        for (String fieldName : fieldNames) {
            FieldDefinition field = repository.getFieldDefinitionByName(fieldName);
            if (field == null) continue;
            fieldMap.put(fieldName, field);
        }
        return fieldMap;
    }

    public static void sortFieldsOnName(List<? extends FieldHierarchyNode> listToSort) {
        Collections.sort(listToSort, new FieldNameComparator());
    }

    public static int getFieldKeyIndex(FieldHierarchyNode field) {
        FieldStructure parent = field.getParent();
        if (parent == null || parent.getComplexType() != FieldHierarchyNode.ComplexType.MAP) {
            throw new IllegalArgumentException("The given field is not located inside a hierarchical MAP structure.");
        }
        if (!field.isKey()) {
            throw new IllegalArgumentException("The given field is not a key field.");
        }
        int index = 0;
        for (FieldHierarchyNode child : parent.getChildren()) {
            if (child == field) break;
            if (!child.isKey()) continue;
            ++index;
        }
        return index;
    }

    public static String getMaxRangeValueFromXml(Node xml) {
        return FieldDefinitionHelper.getRangeValueFromXml(xml, true);
    }

    public static String getMinRangeValueFromXml(Node xml) {
        return FieldDefinitionHelper.getRangeValueFromXml(xml, false);
    }

    private static String getRangeValueFromXml(Node xml, boolean fetchMax) {
        Element editComponentElement = XMLUtil.getNamedElement("EditComponent", xml.getChildNodes());
        NodeList rangeComponents = null;
        if (editComponentElement != null) {
            rangeComponents = editComponentElement.getElementsByTagName("Range");
        }
        Element inputRestrictionElement = XMLUtil.getNamedElement("InputRestriction", xml.getChildNodes());
        NodeList rangeComponents2 = null;
        ArrayList<Element> mergedComponents = new ArrayList<Element>();
        if (inputRestrictionElement != null) {
            rangeComponents2 = inputRestrictionElement.getElementsByTagName("Range");
        }
        if (rangeComponents != null) {
            for (int ei = 0; ei < rangeComponents.getLength(); ++ei) {
                mergedComponents.add((Element)rangeComponents.item(ei));
            }
        }
        int index = mergedComponents.size();
        if (rangeComponents2 != null) {
            for (int ii = 0; ii < rangeComponents2.getLength(); ++ii) {
                mergedComponents.add(index + ii, (Element)rangeComponents2.item(ii));
            }
        }
        String resultValue = FieldDefinitionHelper.getRangeValueString(mergedComponents, fetchMax);
        return resultValue;
    }

    private static boolean hasRequiredEnumUtil(FieldDefinition fieldDefinition) {
        boolean result = false;
        if ((fieldDefinition.hasUtil("EditComponent") || fieldDefinition.hasUtil("InputRestriction")) && ("ericsson.ere.gui.util.EnumEditor".equals(fieldDefinition.getUtilClass("EditComponent")) || "Enum".equals(fieldDefinition.getUtilClass("InputRestriction")))) {
            result = true;
        }
        return result;
    }

    private static boolean hasRequiredRangeUtil(FieldDefinition fieldDefinition) {
        boolean result = false;
        if ((fieldDefinition.hasUtil("EditComponent") || fieldDefinition.hasUtil("InputRestriction")) && ("ericsson.ere.gui.util.NumberRangeEditor".equals(fieldDefinition.getUtilClass("EditComponent")) || "Range".equals(fieldDefinition.getUtilClass("InputRestriction")))) {
            result = true;
        }
        return result;
    }

    private static class FieldNameComparator
    implements Comparator<FieldHierarchyNode> {
        private FieldNameComparator() {
        }

        @Override
        public int compare(FieldHierarchyNode o1, FieldHierarchyNode o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getCanonicalName(), o2.getCanonicalName());
        }
    }
}

