/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import com.ericsson.ere.datatype.LazyEvaluatedEREDate;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.datatype.ValueResolverAdapter;
import com.ericsson.ere.selectiontree.conditions.util.EnumParser;
import com.ericsson.ere.util.Maps;
import ericsson.ere.RatingDataField;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.AbstractStructureNode;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.FieldCreationManager;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.defs.InvalidFieldException;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.xml.XMLUtil;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FieldDefinition
extends AbstractStructureNode
implements Comparable<FieldDefinition> {
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_VALUE_DATE = "20000101";
    private static final String DEFAULT_VALUE_DATE_TIME = "20000101T000000000";
    private static final String DEFAULT_VALUE_BOOLEAN = "false";
    private static final String DEFAULT_VALUE_DECIMAL = "0.0";
    private static final String DEFAULT_VALUE_INT = "0";
    private static final String PARAMETER_TYPE_VIRTUAL = "VIRTUAL";
    private static final String PARAMETER_TYPE_VALIDATION = "VALIDATION";
    private static final String PARAMETER_TYPE_OUT = "OUT";
    private static final String PARAMETER_TYPE_IN = "IN";
    private static final Map<String, String> INPUTRESTRICTION_TYPE_TO_CLASS = new HashMap<String, String>();
    private final DataType myDataType;
    private final boolean myMandatory;
    private final String myParameterType;
    private final String myComment;
    private final String myDefaultValue;
    private final transient Node myDefinitionNode;
    private final Map<String, String> myFieldSettings;
    private final Map<String, String> myEnumMap;
    private final String myKeyField;
    private final ValueClassFactory myValueClassFactory;
    private final Class<?> myValueClass;
    private final boolean myIsKey;
    private final Map<String, String> myUtilClassMap;
    private final String myRangeMin;
    private final String myRangeMax;

    private FieldDefinition(FieldBuilder config) {
        super(config.myParent, config.myName, config.myTag, config.myComplexType, config.myIsAutoConditionMapAllowed, config.myContextNames, FieldDefinition.getToolTipFromXml(config.myDefinitionNode));
        this.myDataType = config.myDataType;
        this.myMandatory = config.myMandatory;
        this.myParameterType = FieldDefinition.extractParameterType(config.myParameterType);
        this.myComment = config.myComment;
        this.myDefaultValue = FieldDefinition.extractDefaultValue(config.myDefaultValue);
        this.myDefinitionNode = config.myKeepXml ? config.myDefinitionNode : null;
        this.myFieldSettings = Maps.unmodifiableMap(config.myFieldSettings);
        this.myKeyField = config.myKeyField;
        this.myValueClassFactory = config.myValueClassFactory;
        this.myValueClass = config.myValueClass;
        this.myIsKey = config.myIsKey;
        Map<Object, Object> map = this.myEnumMap = config.myEnumMap != null ? Maps.unmodifiableMap(config.myEnumMap) : null;
        if (config.myDefinitionNode == null) {
            this.myUtilClassMap = null;
            this.myRangeMin = null;
            this.myRangeMax = null;
        } else {
            this.myUtilClassMap = FieldDefinition.parseUtilClasses(config.myDefinitionNode);
            this.myRangeMin = FieldDefinitionHelper.getMinRangeValueFromXml(config.myDefinitionNode);
            this.myRangeMax = FieldDefinitionHelper.getMaxRangeValueFromXml(config.myDefinitionNode);
        }
    }

    @Deprecated
    public FieldDefinition(String name, int dataType) {
        this(new FieldBuilder().withName(name).withDataType(dataType));
    }

    public FieldDefinition(String name, int dataType, boolean array) {
        this(new FieldBuilder().withName(name).withDataType(dataType).withComplexType(array ? FieldHierarchyNode.ComplexType.ARRAY : FieldHierarchyNode.ComplexType.NONE));
    }

    @Deprecated
    public FieldDefinition(String name, int dataType, boolean array, Node theDefinitionNode) {
        this(new FieldBuilder().withXml(theDefinitionNode));
    }

    public static FieldDefinition createFromXml(Node theDefinitionNode) {
        return new FieldDefinition(new FieldBuilder().withXml(theDefinitionNode));
    }

    public static FieldDefinition createContextFieldFromXml(Node theDefinitionNode, List<String> contexts) {
        return new FieldDefinition(new FieldBuilder().withXml(theDefinitionNode).withContextNames(contexts));
    }

    public static FieldDefinition createField(FieldConfiguration configuration) {
        return FieldDefinition.createField(null, configuration, true);
    }

    public static FieldDefinition createField(FieldStructure parent, FieldConfiguration configuration) {
        FieldBuilder config = new FieldBuilder().withParent(parent).withXml(configuration.getFieldNode()).withKeyField(configuration.getKeyField()).withContextNames(configuration.getContexts());
        return new FieldDefinition(config);
    }

    public static FieldDefinition createField(FieldStructure parent, FieldConfiguration configuration, boolean keepXml) {
        FieldBuilder config = new FieldBuilder().withParent(parent).withXml(configuration.getFieldNode()).withKeyField(configuration.getKeyField()).withContextNames(configuration.getContexts()).withXmlSaved(keepXml);
        return new FieldDefinition(config);
    }

    public static FieldDefinition createField(FieldConfiguration configuration, FieldCreationManager fieldManager) {
        boolean keepXml = fieldManager != null ? fieldManager.keepXml() : true;
        FieldDefinition field = FieldDefinition.createField(null, configuration, keepXml);
        if (configuration.getFieldNode() != null && fieldManager != null) {
            fieldManager.fieldCreated(field, configuration.getFieldNode());
        }
        return field;
    }

    public static FieldDefinition createField(FieldStructure parent, FieldConfiguration configuration, FieldCreationManager fieldManager) {
        boolean keepXml = fieldManager != null ? fieldManager.keepXml() : true;
        FieldDefinition field = FieldDefinition.createField(parent, configuration, keepXml);
        if (configuration.getFieldNode() != null && fieldManager != null) {
            fieldManager.fieldCreated(field, configuration.getFieldNode());
        }
        return field;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myComment == null ? 0 : this.myComment.hashCode());
        result = 31 * result + (this.myDataType == null ? 0 : this.myDataType.hashCode());
        result = 31 * result + (this.myDefaultValue == null ? 0 : this.myDefaultValue.hashCode());
        result = 31 * result + (this.myFieldSettings == null ? 0 : this.myFieldSettings.hashCode());
        result = 31 * result + (this.myIsKey ? 1231 : 1237);
        result = 31 * result + (this.myKeyField == null ? 0 : this.myKeyField.hashCode());
        result = 31 * result + (this.myMandatory ? 1231 : 1237);
        result = 31 * result + (this.myParameterType == null ? 0 : this.myParameterType.hashCode());
        result = 31 * result + (this.myValueClass == null ? 0 : this.myValueClass.hashCode());
        result = 31 * result + (this.myValueClassFactory == null ? 0 : this.myValueClassFactory.getClass().hashCode());
        result = 31 * result + (this.myEnumMap == null ? 0 : this.myEnumMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FieldDefinition other = (FieldDefinition)obj;
        if (this.myComment == null ? other.myComment != null : !this.myComment.equals(other.myComment)) {
            return false;
        }
        if (this.myIsKey != other.myIsKey) {
            return false;
        }
        if (this.myDataType == null ? other.myDataType != null : !this.myDataType.equals(other.myDataType)) {
            return false;
        }
        if (this.myDefaultValue == null ? other.myDefaultValue != null : !this.myDefaultValue.equals(other.myDefaultValue)) {
            return false;
        }
        if (this.myFieldSettings == null ? other.myFieldSettings != null : !this.myFieldSettings.equals(other.myFieldSettings)) {
            return false;
        }
        if (this.myKeyField == null ? other.myKeyField != null : !this.myKeyField.equals(other.myKeyField)) {
            return false;
        }
        if (this.myMandatory != other.myMandatory) {
            return false;
        }
        if (this.myParameterType == null ? other.myParameterType != null : !this.myParameterType.equals(other.myParameterType)) {
            return false;
        }
        if (this.myValueClass == null ? other.myValueClass != null : !this.myValueClass.equals(other.myValueClass)) {
            return false;
        }
        if (this.myValueClassFactory == null) {
            if (other.myValueClassFactory != null) {
                return false;
            }
        } else {
            if (other.myValueClassFactory == null) {
                return false;
            }
            if (!this.myValueClassFactory.getClass().equals(other.myValueClassFactory.getClass())) {
                return false;
            }
        }
        return !(this.myEnumMap == null ? other.myEnumMap != null : !this.myEnumMap.equals(other.myEnumMap));
    }

    @Deprecated
    public void init(Node theDefinitionNode) {
        throw new UnsupportedOperationException("Class is immutable, use constructor or factory method instead");
    }

    @Deprecated
    public int getDatatype() {
        return this.myDataType != null ? this.myDataType.getTypeIdentifier() : -1;
    }

    @Deprecated
    public String getDataType() {
        return this.myDataType != null ? this.myDataType.getTypeName() : EMPTY_STRING;
    }

    public DataType getTypedDataType() {
        return this.myDataType;
    }

    @Override
    public String getFieldName() {
        return this.myName;
    }

    public String getParameterType() {
        return this.myParameterType;
    }

    @Deprecated
    public NamedNodeMap getVariableAttributes() {
        Node node = this.getDefinitionNode();
        return node != null ? node.getAttributes() : null;
    }

    public Node getDefinitionNode() {
        return this.myDefinitionNode != null ? XMLUtil.createEmptyDocument().importNode(this.myDefinitionNode, true) : null;
    }

    public String getComment() {
        return this.myComment;
    }

    public XMLInitializable createUtil(String theName) throws Exception {
        XMLInitializable util = null;
        String clazz = this.getResolvedUtilClass(theName);
        if (clazz != null && this.myDefinitionNode != null) {
            util = (XMLInitializable)EreClassLoader.createInstance(clazz);
            Element n = XMLUtil.getNamedElement(theName, this.myDefinitionNode.getChildNodes());
            Node clone = XMLUtil.createEmptyDocument().importNode(n, true);
            util = util.init(clone);
        }
        return util;
    }

    public boolean hasUtil(String theName) {
        return this.getUtilClass(theName) != null;
    }

    public String getUtilClass(String theName) {
        return this.myUtilClassMap != null ? this.myUtilClassMap.get(theName) : null;
    }

    private static Map<String, String> parseUtilClasses(Node xml) {
        HashMap<String, String> utilClassMap = new HashMap<String, String>();
        for (Element e : XMLUtil.getElementChildList(xml)) {
            String clazz = XMLUtil.getAttributeValue(e.getAttributes(), "class", null);
            if (clazz == null && e.getElementsByTagName("InputRestriction") != null) {
                clazz = e.getAttribute("Type");
            }
            if (clazz == null) continue;
            String tagName = e.getNodeName();
            utilClassMap.put(tagName, clazz);
        }
        return Maps.unmodifiableMap(utilClassMap);
    }

    public String getRangeMin() {
        return this.myRangeMin;
    }

    public String getRangeMax() {
        return this.myRangeMax;
    }

    public String getResolvedUtilClass(String util) {
        String clazz = this.getUtilClass(util);
        if (clazz != null && INPUTRESTRICTION_TYPE_TO_CLASS.containsKey(clazz)) {
            clazz = INPUTRESTRICTION_TYPE_TO_CLASS.get(clazz);
        }
        return clazz;
    }

    @Deprecated
    public boolean hasVariableAttributes() {
        return this.getVariableAttributes() != null;
    }

    public boolean isMandatory() {
        return this.myMandatory;
    }

    @Deprecated
    public void initAttributes(NamedNodeMap attributes) {
        throw new UnsupportedOperationException("Class is immutable, use constructor or factory method instead");
    }

    @Deprecated
    public RatingDataField getRatingDataField() {
        if (this.usesTagNumber()) {
            return new RatingDataField(this.myName, this.getTagNumber(), this.getDataType(), this.isArray());
        }
        return new RatingDataField(this.myName, this.getDataType(), this.isArray());
    }

    @Deprecated
    public boolean getSupportArray() {
        return this.isArray();
    }

    public boolean isArray() {
        return this.myComplexType == FieldHierarchyNode.ComplexType.ARRAY;
    }

    public boolean isMap() {
        return this.myComplexType == FieldHierarchyNode.ComplexType.MAP;
    }

    public boolean isSet() {
        return this.myComplexType == FieldHierarchyNode.ComplexType.SET;
    }

    public boolean isComplexType() {
        return this.myComplexType != FieldHierarchyNode.ComplexType.NONE;
    }

    @Deprecated
    public boolean getUseTagNumber() {
        return this.usesTagNumber();
    }

    public boolean usesTagNumber() {
        return this.myTagNumber != -1;
    }

    public Object createValueObject(String value) throws ParseException {
        if (this.myDataType == null) {
            throw new ParseException("Unknown data type", 0);
        }
        return this.myDataType.parseValue(value);
    }

    public boolean hasDefaultValue() {
        return this.myDefaultValue != null;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    public int compareTo(FieldDefinition o) {
        return this.myName.compareTo(o.myName);
    }

    public boolean isFieldOriented() {
        return !this.myParameterType.equals(PARAMETER_TYPE_VALIDATION);
    }

    @Deprecated
    public String getKeyField() {
        return this.myKeyField;
    }

    public String[] getKeyFields() {
        if (this.myKeyField == null) {
            return new String[0];
        }
        return this.myKeyField.split(";");
    }

    public Map<String, String> getFieldSettings() {
        return this.myFieldSettings;
    }

    public boolean hasValueClass() {
        return this.myValueClass != null;
    }

    public boolean hasValueClassFactory() {
        return this.myValueClassFactory != null;
    }

    public ValueClassFactory getValueClassFactory() {
        if (!this.hasValueClassFactory()) {
            throw new IllegalArgumentException("There is no value class factory defined for this field.");
        }
        return this.myValueClassFactory;
    }

    @Deprecated
    public Class<?> getValueClass() throws ClassNotFoundException {
        if (!this.hasValueClass()) {
            throw new ClassNotFoundException("There is no value class defined for this field.");
        }
        return this.myValueClass;
    }

    public Class<?> getValueClassProper() {
        try {
            return this.getValueClass();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.myCanonicalName, this.myDataType.getTypeName(), this.myParameterType);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public FieldHierarchyNode getChildByName(String name) {
        throw new UnsupportedOperationException("Field " + this.getFieldName() + " is a leaf and cannot have children.");
    }

    @Override
    public List<FieldHierarchyNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean isKey() {
        return this.myIsKey;
    }

    public Map<String, String> getEnumMap() {
        return this.myEnumMap;
    }

    private static String extractDefaultValue(String value) {
        if (DEFAULT_VALUE_INT.equals(value)) {
            return DEFAULT_VALUE_INT;
        }
        if (DEFAULT_VALUE_DECIMAL.equals(value)) {
            return DEFAULT_VALUE_DECIMAL;
        }
        if (DEFAULT_VALUE_BOOLEAN.equals(value)) {
            return DEFAULT_VALUE_BOOLEAN;
        }
        if (DEFAULT_VALUE_DATE_TIME.equals(value)) {
            return DEFAULT_VALUE_DATE_TIME;
        }
        if (DEFAULT_VALUE_DATE.equals(value)) {
            return DEFAULT_VALUE_DATE;
        }
        if (EMPTY_STRING.equals(value)) {
            return EMPTY_STRING;
        }
        return value;
    }

    private static String extractParameterType(String value) {
        if (PARAMETER_TYPE_IN.equals(value)) {
            return PARAMETER_TYPE_IN;
        }
        if (PARAMETER_TYPE_OUT.equals(value)) {
            return PARAMETER_TYPE_OUT;
        }
        if (PARAMETER_TYPE_VALIDATION.equals(value)) {
            return PARAMETER_TYPE_VALIDATION;
        }
        if (PARAMETER_TYPE_VIRTUAL.equals(value)) {
            return PARAMETER_TYPE_VIRTUAL;
        }
        return value;
    }

    static {
        INPUTRESTRICTION_TYPE_TO_CLASS.put("Range", "ericsson.ere.gui.util.NumberRangeEditor");
        INPUTRESTRICTION_TYPE_TO_CLASS.put("Enum", "ericsson.ere.gui.util.EnumEditor");
        INPUTRESTRICTION_TYPE_TO_CLASS.put("RelativeDate", "ericsson.ere.gui.util.RelativeDateEditor");
        INPUTRESTRICTION_TYPE_TO_CLASS.put("RelativeTime", "ericsson.ere.gui.util.RelativeDateTimeEditor");
    }

    public static class DefaultFieldConfiguration
    implements FieldConfiguration {
        private Node myFieldNode;
        private List<String> myContexts;
        private String myKeyField;

        public DefaultFieldConfiguration(Node fieldNode, List<String> contexts, String keyField) {
            this.myFieldNode = fieldNode;
            this.myContexts = contexts;
            this.myKeyField = keyField;
        }

        @Override
        public Node getFieldNode() {
            return this.myFieldNode;
        }

        @Override
        public List<String> getContexts() {
            return this.myContexts;
        }

        @Override
        public String getKeyField() {
            return this.myKeyField;
        }
    }

    public static interface FieldConfiguration {
        public Node getFieldNode();

        public List<String> getContexts();

        public String getKeyField();
    }

    private static class FieldBuilder {
        private String myName;
        private int myTag = -1;
        private FieldHierarchyNode.ComplexType myComplexType = FieldHierarchyNode.ComplexType.NONE;
        private FieldStructure myParent;
        private DataType myDataType;
        private boolean myMandatory;
        private String myParameterType = "IN";
        private String myComment;
        private boolean myIsAutoConditionMapAllowed;
        private String myDefaultValue;
        private Node myDefinitionNode;
        private List<String> myContextNames;
        private Map<String, String> myFieldSettings = new HashMap<String, String>();
        private String myKeyField;
        private ValueClassFactory myValueClassFactory;
        private Class<?> myValueClass;
        private boolean myIsKey;
        private Map<String, String> myEnumMap = null;
        private boolean myKeepXml = true;

        private FieldBuilder() {
        }

        public FieldBuilder withParent(FieldStructure parent) {
            this.myParent = parent;
            return this;
        }

        public FieldBuilder withXmlSaved(boolean keepXml) {
            this.myKeepXml = keepXml;
            return this;
        }

        public FieldBuilder withDataType(int dataType) {
            this.myDataType = DataType.lookup(dataType);
            return this;
        }

        public FieldBuilder withName(String name) {
            this.myName = name;
            return this;
        }

        public FieldBuilder withComplexType(FieldHierarchyNode.ComplexType complexType) {
            this.myComplexType = complexType;
            return this;
        }

        public FieldBuilder withXml(Node config) {
            this.myDefinitionNode = XMLUtil.createEmptyDocument().importNode(config, true);
            this.myName = AbstractStructureNode.getNameFromXml(this.myDefinitionNode);
            this.myTag = AbstractStructureNode.getTagFromXml(this.myDefinitionNode);
            this.myComplexType = FieldBuilder.getComplexTypeFromConfig(this.myDefinitionNode);
            this.initFieldAttributes(this.myDefinitionNode.getAttributes());
            this.initFieldSettings(this.myDefinitionNode);
            this.myEnumMap = EnumParser.createEnumMap(this.myDefinitionNode);
            this.myEnumMap = this.myEnumMap != null ? Collections.unmodifiableMap(this.myEnumMap) : null;
            return this;
        }

        public FieldBuilder withKeyField(String keyField) {
            this.myKeyField = keyField;
            return this;
        }

        public FieldBuilder withContextNames(List<String> contextNames) {
            this.myContextNames = contextNames;
            return this;
        }

        private void initFieldAttributes(NamedNodeMap attributes) {
            this.myDataType = DataType.lookup(XMLUtil.getAttributeValue(attributes, "DataType", FieldDefinition.EMPTY_STRING));
            this.myParameterType = XMLUtil.getAttributeValue(attributes, "ParameterType", this.myParameterType);
            this.myParameterType = this.myParameterType.toUpperCase();
            this.initMandatoryIndication(attributes);
            this.initKeyFieldIfExists(attributes);
            this.myComment = XMLUtil.getAttributeValue(attributes, "Comment", null);
            this.myIsAutoConditionMapAllowed = AbstractStructureNode.getIsAutoConditionMapAllowedFromXml(this.myDefinitionNode);
            this.initValueClassFactoryIfExists(attributes);
            this.initValueClassIfExists(attributes);
            this.verifyValueClassAndFactory();
            this.initDefaultValueIfExists(attributes);
        }

        private void verifyValueClassAndFactory() {
            if (this.myValueClass != null && this.myDataType != null && this.myDataType != DataType.OBJECT) {
                if (this.myDataType == DataType.DATE && this.myValueClass == LazyEvaluatedEREDate.class) {
                    this.myValueClass = null;
                } else {
                    throw new InvalidFieldException(this.myName, "ValueClass", this.getValueClazz().getName(), "Value class cannot be specified for non-OBJECT fields.");
                }
            }
            if (this.myValueClass != null && this.myValueClassFactory == null) {
                throw new InvalidFieldException(this.myName, "ValueClassFactory", FieldDefinition.EMPTY_STRING, "Value class factory must be specified when a value class is specified.");
            }
        }

        private Class<?> getValueClazz() {
            if (this.myValueClass == null) {
                throw new IllegalArgumentException("There is no value class defined for this field.");
            }
            return this.myValueClass;
        }

        private void initFieldSettings(Node theDefinitionNode) {
            Node fieldSettingsNode;
            List<Element> settingsNodes = XMLUtil.getElementNodesNamed("FieldSettings", theDefinitionNode.getChildNodes());
            if (!settingsNodes.isEmpty() && (fieldSettingsNode = (Node)settingsNodes.get(0)) != null) {
                List<Node> settingsList = XMLUtil.getElementChildren(fieldSettingsNode);
                for (Node aSetting : settingsList) {
                    this.myFieldSettings.put(aSetting.getNodeName(), XMLUtil.getFirstTextContent(aSetting));
                }
            }
        }

        private void initKeyFieldIfExists(NamedNodeMap attributes) {
            String keyFieldStr = XMLUtil.getAttributeValue(attributes, "KeyField", FieldDefinition.EMPTY_STRING);
            this.myIsKey = keyFieldStr.equalsIgnoreCase("true");
        }

        private void initDefaultValueIfExists(NamedNodeMap attributes) {
            String defaultValue = XMLUtil.getAttributeValue(attributes, "Default", null);
            if (defaultValue != null && this.myDataType != null) {
                String mode = XMLUtil.getAttributeValue(attributes, "Mode", null);
                if (mode != null && this.myDataType == DataType.OCTETSTRING) {
                    boolean isAscii = "ascii".equalsIgnoreCase(mode);
                    OctetString os = isAscii ? OctetString.fromAscii(defaultValue) : new OctetString(defaultValue);
                    defaultValue = os.toString();
                    attributes.removeNamedItem("Mode");
                }
                this.myDefaultValue = this.checkDefaultValue(defaultValue);
            }
        }

        private void initValueClassFactoryIfExists(NamedNodeMap attributes) {
            String className = XMLUtil.getAttributeValue(attributes, "ValueClassFactory", null);
            if (className != null) {
                try {
                    this.myValueClassFactory = (ValueClassFactory)EreClassLoader.createInstance(className);
                }
                catch (Exception e) {
                    throw (InvalidFieldException)new InvalidFieldException(this.myName, "ValueClassFactory", className).initCause(e);
                }
            }
        }

        private void initValueClassIfExists(NamedNodeMap attributes) {
            String className = XMLUtil.getAttributeValue(attributes, "ValueClass", null);
            if (className != null) {
                try {
                    this.myValueClass = EreClassLoader.getClass(className);
                }
                catch (Exception e) {
                    throw (InvalidFieldException)new InvalidFieldException(this.myName, "ValueClass", className).initCause(e);
                }
            }
        }

        private static FieldHierarchyNode.ComplexType getComplexTypeFromConfig(Node xml) {
            FieldHierarchyNode.ComplexType ret = FieldHierarchyNode.ComplexType.NONE;
            String complexTypeStr = XMLUtil.getAttributeValue(xml.getAttributes(), "ComplexType", null);
            if (complexTypeStr != null) {
                try {
                    ret = FieldHierarchyNode.ComplexType.valueOf(complexTypeStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidFieldException(AbstractStructureNode.getNameFromXml(xml), "ComplexType", complexTypeStr, "unknown type");
                }
            } else {
                String valueListStr = XMLUtil.getAttributeValue(xml.getAttributes(), "ValueList", FieldDefinition.DEFAULT_VALUE_BOOLEAN);
                if (valueListStr.equalsIgnoreCase("true")) {
                    ret = FieldHierarchyNode.ComplexType.ARRAY;
                }
            }
            return ret;
        }

        private void initMandatoryIndication(NamedNodeMap attributes) {
            String strMandatory = XMLUtil.getAttributeValue(attributes, "Mandatory", null);
            boolean mandatory = Boolean.parseBoolean(strMandatory);
            boolean defMandatory = false;
            if (FieldDefinition.PARAMETER_TYPE_VIRTUAL.equals(this.myParameterType)) {
                if (strMandatory != null && !mandatory) {
                    throw new InvalidFieldException(this.myName, "Mandatory", strMandatory, "Parameter type VIRTUAL should always have mandatory parameter set to 'true'");
                }
                defMandatory = true;
            }
            this.myMandatory = strMandatory == null ? defMandatory : mandatory;
        }

        private String checkDefaultValue(String defaultValue) {
            boolean failed;
            String ret = defaultValue;
            boolean doThrow = failed = !this.isValidDefaultString(this.myDataType, this.myValueClassFactory, defaultValue);
            if (failed) {
                if (this.myDataType == DataType.AMOUNT) {
                    if (FieldDefinition.EMPTY_STRING.equals(defaultValue)) {
                        ret = null;
                        doThrow = false;
                    }
                } else if (this.myDataType == DataType.DATE) {
                    boolean bl = doThrow = !this.isValidDefaultString(DataType.TIME, null, defaultValue);
                }
            }
            if (doThrow) {
                throw new InvalidFieldException(this.myName, "Default", defaultValue, "invalid default value for data type " + this.myDataType);
            }
            return ret;
        }

        private boolean isValidDefaultString(DataType type, ValueClassFactory valueClassFactory, String str) {
            Object value = null;
            try {
                ValueResolver resolver = valueClassFactory != null ? new ValueResolverAdapter(valueClassFactory, type) : type;
                value = this.myComplexType == FieldHierarchyNode.ComplexType.ARRAY ? DataType.parseMultiString(str, resolver) : resolver.parseValueString(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value != null;
        }
    }
}

