/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import ericsson.ere.datatype.interfaces.UnsignedInt;

public class UnsignedInt16
extends Number
implements UnsignedInt,
Cloneable {
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;
    public static final UnsignedInt16 ZERO = new UnsignedInt16(0);
    public static final UnsignedInt16 MAX = new UnsignedInt16(65535);
    private int myIntValue;

    public UnsignedInt16(short value) {
        this.setValue(value);
    }

    public UnsignedInt16(int value) {
        this.checkValue(value);
        this.setValue((short)value);
    }

    public UnsignedInt16(String str) {
        int value = Integer.parseInt(str);
        this.checkValue(value);
        this.setValue((short)value);
    }

    @Deprecated
    public void set(short value) {
        this.setValue(value);
    }

    protected void setValue(short value) {
        this.myIntValue = value < 0 ? value + 65535 + 1 : (int)value;
    }

    public short shortSignedValue() {
        return (short)this.myIntValue;
    }

    @Override
    public byte byteValue() {
        return (byte)this.myIntValue;
    }

    @Override
    public short shortValue() {
        return (short)this.myIntValue;
    }

    @Override
    public int intValue() {
        return this.myIntValue;
    }

    @Override
    public long longValue() {
        return this.myIntValue;
    }

    @Override
    public float floatValue() {
        return this.myIntValue;
    }

    @Override
    public double doubleValue() {
        return this.myIntValue;
    }

    public static UnsignedInt16 valueOf(String aValue) {
        int number = Integer.parseInt(aValue);
        if (number == 0) {
            return ZERO;
        }
        if (number == 65535) {
            return MAX;
        }
        return new UnsignedInt16(number);
    }

    public String toString() {
        return Integer.toString(this.myIntValue);
    }

    public int hashCode() {
        return this.myIntValue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnsignedInt)) {
            return false;
        }
        return this.longValue() == ((UnsignedInt)obj).longValue();
    }

    private void checkValue(int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("UnsignedInt16 value out of range: " + val);
        }
    }

    public UnsignedInt16 clone() {
        try {
            return (UnsignedInt16)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

