/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OctetString
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -2369194718643083158L;
    private byte[] myByteArray;

    public OctetString(byte[] data) {
        if (data != null) {
            byte[] copyOfData = new byte[data.length];
            System.arraycopy(data, 0, copyOfData, 0, copyOfData.length);
            this.myByteArray = copyOfData;
        }
    }

    public OctetString(String str) {
        if (str == null || str.length() == 0) {
            this.myByteArray = new byte[0];
        } else {
            OctetString tmp = OctetString.valueOf(str);
            this.myByteArray = tmp.myByteArray;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OctetString clone = (OctetString)super.clone();
        byte[] newArray = new byte[this.myByteArray.length];
        System.arraycopy(this.myByteArray, 0, newArray, 0, newArray.length);
        clone.myByteArray = newArray;
        return clone;
    }

    public void set(byte[] data) {
        byte[] copyOfData = new byte[data.length];
        System.arraycopy(data, 0, copyOfData, 0, copyOfData.length);
        this.myByteArray = copyOfData;
    }

    public byte[] getData() {
        return this.myByteArray;
    }

    public String toString() {
        if (this.myByteArray == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.myByteArray.length; ++i) {
            String value = Integer.toHexString(this.myByteArray[i] & 0xFF).toUpperCase();
            if (value.length() == 1) {
                buffer.append("0");
            }
            buffer.append(value);
        }
        return buffer.toString();
    }

    public String toAscii() {
        char[] buffer = new char[this.myByteArray.length];
        for (int i = 0; i < this.myByteArray.length; ++i) {
            buffer[i] = (char)this.myByteArray[i];
        }
        return new String(buffer);
    }

    public String toExtendedAscii() {
        char[] buffer = new char[this.myByteArray.length];
        for (int i = 0; i < this.myByteArray.length; ++i) {
            buffer[i] = (char)((char)this.myByteArray[i] & 0xFF);
        }
        return new String(buffer);
    }

    public static boolean isDisplayableUSAscii(OctetString octetString) {
        if (octetString.myByteArray.length == 0) {
            return true;
        }
        for (byte currentByte : octetString.myByteArray) {
            if (OctetString.isPrintableAscii(currentByte)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableAscii(byte byteToCheck) {
        return byteToCheck > 31 && byteToCheck < 127;
    }

    public static OctetString fromAscii(String aString) {
        char[] text = aString.toCharArray();
        byte[] buffer = new byte[text.length];
        for (int i = 0; i < text.length; ++i) {
            buffer[i] = (byte)text[i];
        }
        return new OctetString(buffer);
    }

    public static String toAscii(String hexValues) {
        String workingString = hexValues;
        if (workingString.startsWith("0x")) {
            workingString = workingString.substring(2);
        }
        if (workingString.indexOf(45) != -1) {
            throw new IllegalArgumentException("Failed parsing OctetString: " + workingString);
        }
        if (workingString.length() % 2 != 0) {
            workingString = "0" + workingString;
        }
        byte[] byteArray = new byte[workingString.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            byte b;
            String tmp = workingString.substring(2 * i, 2 * i + 2);
            byteArray[i] = b = Byte.parseByte(tmp, 16);
        }
        return new String(byteArray);
    }

    public static OctetString valueOf(String aString) {
        String workingString = aString;
        if (workingString.startsWith("0x")) {
            workingString = workingString.substring(2);
        }
        if (workingString.indexOf(45) != -1) {
            throw new IllegalArgumentException("Failed parsing OctetString: " + workingString);
        }
        if (workingString.length() % 2 != 0) {
            workingString = "0" + workingString;
        }
        byte[] byteArray = new byte[workingString.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            String tmp = workingString.substring(2 * i, 2 * i + 2);
            int integer = Integer.parseInt(tmp, 16);
            if (integer > 255 || integer < 0) {
                throw new NumberFormatException("Failed parsing OctetString, " + tmp + " in " + workingString);
            }
            byteArray[i] = (byte)(integer & 0xFF);
        }
        return new OctetString(byteArray);
    }

    public int length() {
        return this.myByteArray.length;
    }

    public boolean startsWith(OctetString octetStr) {
        if (octetStr.getData().length > this.myByteArray.length) {
            return false;
        }
        for (int ii = 0; ii < octetStr.myByteArray.length; ++ii) {
            if (octetStr.myByteArray[ii] == this.myByteArray[ii]) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(OctetString octetStr) {
        if (octetStr.getData().length > this.myByteArray.length) {
            return false;
        }
        int ii = octetStr.myByteArray.length - 1;
        int k = 1;
        while (ii >= 0) {
            if (octetStr.myByteArray[ii] != this.myByteArray[this.myByteArray.length - k]) {
                return false;
            }
            --ii;
            ++k;
        }
        return true;
    }

    private List<Byte> createListFromArray(byte[] bytes) {
        ArrayList<Byte> ret = new ArrayList<Byte>(bytes.length);
        for (byte theByte : bytes) {
            ret.add(theByte);
        }
        return ret;
    }

    public boolean contains(OctetString octetStr) {
        return Collections.indexOfSubList(this.createListFromArray(this.myByteArray), this.createListFromArray(octetStr.getData())) > -1;
    }

    public String toPrintableAscii() {
        StringBuilder asciiStringBuilder = new StringBuilder();
        for (byte currentByte : this.myByteArray) {
            if (OctetString.isPrintableAscii(currentByte)) {
                asciiStringBuilder.append((char)currentByte);
                continue;
            }
            asciiStringBuilder.append(".");
        }
        return asciiStringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.myByteArray);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctetString other = (OctetString)obj;
        return Arrays.equals(this.myByteArray, other.myByteArray);
    }
}

