/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.datatype.ValueResolverAdapter;
import com.ericsson.ere.selectiontree.conditions.util.EnumParser;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.factory.LazyEvaluatedEREDateClassFactory;
import ericsson.ere.datatype.factory.LazyEvaluatedERETimeClassFactory;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.defs.FieldDefinition;
import java.text.ParseException;
import java.util.Map;

public final class ContextBasedValueResolver {
    private static final ValueResolver NULL_VALUE_RESOLVER = new ValueResolverAdapter();
    private DataType myDataType;
    private ClassRepository myRepository;
    private DataSet myDataSet;
    private FieldDefinition myFieldDefinition;
    private boolean myUseEnumsForDisplayString = true;
    private boolean myUseStrictParsing = true;
    private boolean myPreferLazyEvaluatedValue = true;

    ContextBasedValueResolver(DataType dataType) {
        this.myDataType = dataType;
    }

    public ContextBasedValueResolver withClassRepository(ClassRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("Requires a non-null class repository.");
        }
        this.myRepository = repository;
        return this;
    }

    public ContextBasedValueResolver withDataSet(DataSet dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Requires a non-null class data set.");
        }
        this.myDataSet = dataset;
        return this;
    }

    public ContextBasedValueResolver withFieldDefinition(FieldDefinition field) {
        if (field == null) {
            throw new IllegalArgumentException("Requires a non-null field definition.");
        }
        this.myFieldDefinition = field;
        this.myDataType = field.getTypedDataType();
        return this;
    }

    public ContextBasedValueResolver disableEnumDisplay() {
        this.myUseEnumsForDisplayString = false;
        return this;
    }

    public ContextBasedValueResolver disableStrictParsing() {
        this.myUseStrictParsing = false;
        return this;
    }

    public ContextBasedValueResolver disableLazyEvaluatedValuePreference() {
        this.myPreferLazyEvaluatedValue = false;
        return this;
    }

    public Object createDefaultValue() {
        return this.legacyResolver().createDefaultInstance();
    }

    public Object parseString(String str) throws ParseException {
        Object obj = this.legacyResolver().parseValueString(str);
        if (obj == null) {
            throw new ParseException("Failed to parse string: " + str, 0);
        }
        return obj;
    }

    public Object[] parseMultiString(String str) throws ParseException {
        return DataType.parseMultiString(str, this.legacyResolver());
    }

    private ValueResolver legacyResolver() {
        return this.disableLazyEvaluatedValuePreference().disableStrictParsing().finish();
    }

    public ValueResolver finish() {
        ValueResolver inner;
        DataType dt;
        FieldDefinition field = this.myFieldDefinition;
        ValueResolverContext context = new ValueResolverContext(this.myRepository, this.myDataSet, this.myFieldDefinition, this.myUseStrictParsing, this.myPreferLazyEvaluatedValue);
        DataType dataType = dt = field != null ? field.getTypedDataType() : this.myDataType;
        if (field != null && field.hasValueClassFactory()) {
            ValueClassFactory factory = field.getValueClassFactory();
            if (factory.getClass() == LazyEvaluatedEREDateClassFactory.class) {
                LazyEvaluatedEREDateClassFactory newFactory = ((LazyEvaluatedEREDateClassFactory)factory).createCopyWithField(field);
                inner = new ValueResolverAdapter(newFactory, null);
            } else if (factory.getClass() == LazyEvaluatedERETimeClassFactory.class) {
                LazyEvaluatedERETimeClassFactory newFactory = ((LazyEvaluatedERETimeClassFactory)factory).createCopyWithField(field);
                inner = new ValueResolverAdapter(newFactory, null);
            } else {
                inner = new ValueResolverAdapter(field.getValueClassFactory(), null);
            }
        } else {
            inner = dt == null ? null : new DataTypeContextResolver(dt, context);
        }
        return inner == null ? NULL_VALUE_RESOLVER : new FieldResolver(field, dt, true, this.myUseEnumsForDisplayString, inner);
    }

    @Immutable
    private static class DataTypeContextResolver
    implements ValueResolver {
        private final DataType myDataType;
        private final ValueResolverContext myContext;

        DataTypeContextResolver(DataType dataType, ValueResolverContext context) {
            this.myDataType = dataType;
            this.myContext = context;
        }

        @Override
        public DataType getDataType() {
            return this.myDataType;
        }

        @Override
        public Object createDefaultInstance() {
            return this.myDataType.createDefaultInstance(this.myContext);
        }

        @Override
        public String makeDisplayString(Object anObject) {
            return this.myDataType.makeDisplayString(anObject, this.myContext);
        }

        @Override
        public String makeValueString(Object anObject) {
            return this.myDataType.makeParseableString(anObject, this.myContext);
        }

        @Override
        public Object parseValueString(String aString) {
            try {
                return this.myDataType.parseString(aString, this.myContext);
            }
            catch (ParseException ex) {
                return null;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myContext == null ? 0 : this.myContext.hashCode());
            result = 31 * result + (this.myDataType == null ? 0 : this.myDataType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataTypeContextResolver other = (DataTypeContextResolver)obj;
            if (this.myContext == null ? other.myContext != null : !this.myContext.equals(other.myContext)) {
                return false;
            }
            return !(this.myDataType == null ? other.myDataType != null : !this.myDataType.equals(other.myDataType));
        }
    }

    private static class FieldResolver
    extends ValueResolverAdapter {
        private final String myFieldDefaultStr;
        private final DataType myDataType;
        private final Map<Object, String> myFieldEnumValueMap;
        private final boolean myIsArrayField;
        private final boolean myIsSetField;

        FieldResolver(FieldDefinition field, DataType dataType, boolean useFieldDefault, boolean useEnums, ValueResolver inner) {
            super(inner);
            this.myDataType = dataType;
            if (field != null) {
                this.myFieldEnumValueMap = useEnums ? EnumParser.generateValueEnumMap(field) : null;
                this.myFieldDefaultStr = field.hasDefaultValue() && useFieldDefault ? field.getDefaultValue() : null;
                this.myIsArrayField = field.isArray();
                this.myIsSetField = field.isSet();
            } else {
                this.myFieldEnumValueMap = null;
                this.myFieldDefaultStr = null;
                this.myIsArrayField = false;
                this.myIsSetField = false;
            }
        }

        @Override
        public String makeDisplayString(Object anObject) {
            String ret;
            String string = ret = this.myFieldEnumValueMap != null ? this.myFieldEnumValueMap.get(anObject) : null;
            if (ret == null) {
                ret = super.makeDisplayString(anObject);
            }
            return ret;
        }

        @Override
        public Object createDefaultInstance() {
            Object ret = null;
            if (this.myFieldDefaultStr != null) {
                ret = this.myIsArrayField || this.myIsSetField ? this.getArrayDefault(this.myFieldDefaultStr) : this.parseValueString(this.myFieldDefaultStr);
            }
            if (ret == null) {
                ret = super.createDefaultInstance();
            }
            return ret;
        }

        private Object getArrayDefault(String str) {
            Object ret = null;
            try {
                Object[] values = DataType.parseMultiString(str, this.myResolver);
                if (values.length > 0) {
                    ret = values[0];
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return ret;
        }

        @Override
        public DataType getDataType() {
            return this.myDataType;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myDataType == null ? 0 : this.myDataType.hashCode());
            result = 31 * result + (this.myFieldDefaultStr == null ? 0 : this.myFieldDefaultStr.hashCode());
            result = 31 * result + (this.myFieldEnumValueMap == null ? 0 : this.myFieldEnumValueMap.hashCode());
            result = 31 * result + (this.myIsArrayField ? 1231 : 1237);
            result = 31 * result + (this.myIsSetField ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldResolver other = (FieldResolver)obj;
            if (this.myDataType == null ? other.myDataType != null : !this.myDataType.equals(other.myDataType)) {
                return false;
            }
            if (this.myFieldDefaultStr == null ? other.myFieldDefaultStr != null : !this.myFieldDefaultStr.equals(other.myFieldDefaultStr)) {
                return false;
            }
            if (this.myFieldEnumValueMap == null ? other.myFieldEnumValueMap != null : !this.myFieldEnumValueMap.equals(other.myFieldEnumValueMap)) {
                return false;
            }
            if (this.myIsArrayField != other.myIsArrayField) {
                return false;
            }
            return this.myIsSetField == other.myIsSetField;
        }
    }

    @Immutable
    static class ValueResolverContext {
        private final ClassRepository myRepository;
        private final DataSet myDataSet;
        private final FieldDefinition myFieldDefinition;
        private final boolean myStrict;
        private boolean myPreferLazy;

        ValueResolverContext(ClassRepository repository, DataSet dataset, FieldDefinition field, boolean strict, boolean preferLazy) {
            this.myRepository = repository;
            this.myDataSet = dataset;
            this.myFieldDefinition = field;
            this.myStrict = strict;
            this.myPreferLazy = preferLazy;
        }

        ClassRepository getClassRepository() {
            ClassRepository rep = this.myRepository;
            if (rep == null && this.myDataSet != null) {
                rep = this.myDataSet.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(this.myDataSet));
            }
            return rep;
        }

        DataSet getDataSet() {
            DataSet ds = this.myDataSet;
            if (ds == null && this.myRepository != null) {
                DataSetFactory fact = this.myRepository.getDataSetFactory();
                ds = fact != null ? fact.createDataSet() : null;
            }
            return ds;
        }

        FieldDefinition getFieldDefinition() {
            return this.myFieldDefinition;
        }

        boolean isStrict() {
            return this.myStrict;
        }

        boolean preferLazyEvaluatedValue() {
            return this.myPreferLazy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myDataSet == null ? 0 : this.myDataSet.hashCode());
            result = 31 * result + (this.myFieldDefinition == null ? 0 : this.myFieldDefinition.hashCode());
            result = 31 * result + (this.myPreferLazy ? 1231 : 1237);
            result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.hashCode());
            result = 31 * result + (this.myStrict ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueResolverContext other = (ValueResolverContext)obj;
            if (this.myDataSet == null ? other.myDataSet != null : !this.myDataSet.equals(other.myDataSet)) {
                return false;
            }
            if (this.myFieldDefinition == null ? other.myFieldDefinition != null : !this.myFieldDefinition.equals(other.myFieldDefinition)) {
                return false;
            }
            if (this.myPreferLazy != other.myPreferLazy) {
                return false;
            }
            if (this.myRepository == null ? other.myRepository != null : !this.myRepository.equals(other.myRepository)) {
                return false;
            }
            return this.myStrict == other.myStrict;
        }
    }
}

