/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.numberList;

import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class NumberTree
implements Comparable<NumberTree> {
    private NumberTree[] next = null;
    private boolean result = false;

    public NumberTree(String theNumbers) throws IllegalArgumentException {
        this.addNumbers(theNumbers);
    }

    private NumberTree() {
    }

    public boolean checkNumber(String theNumber) throws Exception {
        return this.checkNumber(theNumber, 0);
    }

    public boolean checkNumber(String theNumber, int theLevel) throws Exception {
        int tempNumber;
        if (this.result) {
            return true;
        }
        if (theNumber.length() == theLevel) {
            return this.result;
        }
        try {
            tempNumber = NumberTree.convertDigit(theNumber.charAt(theLevel));
        }
        catch (Exception e) {
            return false;
        }
        if (this.next == null || this.next[tempNumber] == null) {
            return false;
        }
        return this.next[tempNumber].checkNumber(theNumber, theLevel + 1);
    }

    public boolean checkNumber(byte[] theNumber, int theLevel) {
        if (this.result) {
            return true;
        }
        if (theNumber.length == theLevel) {
            return this.result;
        }
        int tempNumber = theNumber[theLevel];
        if (tempNumber > 15) {
            tempNumber = NumberTree.convertDigit((byte)tempNumber);
        }
        if (this.next == null || this.next[tempNumber] == null) {
            return false;
        }
        return this.next[tempNumber].checkNumber(theNumber, theLevel + 1);
    }

    public boolean checkNumber(byte[] theNumber) {
        NumberTree tree;
        if (theNumber == null || theNumber.length == 0 || this.next == null) {
            return false;
        }
        byte b = theNumber[0];
        if (b > 16) {
            b = (byte)NumberTree.convertDigit(b);
        }
        if ((tree = this.next[b]) == null) {
            return false;
        }
        if (tree.result) {
            return tree.result;
        }
        int len = theNumber.length;
        for (int i = 1; i < len; ++i) {
            b = theNumber[i];
            if (b > 16) {
                b = (byte)NumberTree.convertDigit(b);
            }
            if ((tree = tree.next[b]) == null) {
                return false;
            }
            if (!tree.result) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(NumberTree other) {
        if (this.next != null && other.next == null) {
            return 1;
        }
        if (this.next == null && other.next != null) {
            return -1;
        }
        if (this.result && !other.result) {
            return 1;
        }
        if (!this.result && other.result) {
            return -1;
        }
        if (this.next == null) {
            return 0;
        }
        for (int i = 0; i < this.next.length; ++i) {
            int res;
            if (this.next[i] == null && other.next[i] != null) {
                return -1;
            }
            if (this.next[i] != null && other.next[i] == null) {
                return 1;
            }
            if (this.next[i] == null || (res = this.next[i].compareTo(other.next[i])) == 0) continue;
            return res;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int res = 1;
        res = 31 * res + Arrays.hashCode(this.next);
        res = 31 * res + (this.result ? 1231 : 1237);
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberTree other = (NumberTree)obj;
        if (!Arrays.equals(this.next, other.next)) {
            return false;
        }
        return this.result == other.result;
    }

    private void addNumbers(String theNumbers) throws IllegalArgumentException {
        if (this.next != null) {
            throw new IllegalArgumentException("Cannot add new numbers to already initialized tree.");
        }
        StringTokenizer tokenizer = new StringTokenizer(theNumbers, " ,\t\n\r\u0000", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 0) continue;
            int rangeIndicatorPos = token.indexOf(45);
            if (rangeIndicatorPos == -1) {
                this.addNumber(token, 0);
                continue;
            }
            String from = token.substring(0, rangeIndicatorPos);
            String to = token.substring(rangeIndicatorPos + 1, token.length());
            this.addNumberRange(from, to);
        }
        this.optimize();
    }

    private void optimize() {
        if (this.next != null) {
            for (int i = 0; i < this.next.length; ++i) {
                if (this.next[i] == null) continue;
                NumberTree n = Cache.fetch(this.next[i]);
                if (n != null && n != this.next[i]) {
                    this.next[i] = n;
                    continue;
                }
                this.next[i].optimize();
            }
        }
    }

    private void addNumber(String theNumber, int theLevel) throws IllegalArgumentException {
        if (theNumber.length() == theLevel) {
            if (this.result) {
                throw new IllegalArgumentException("Number already exists: " + theNumber);
            }
            this.result = true;
            return;
        }
        int tempNumber = NumberTree.convertDigit(theNumber.charAt(theLevel));
        if (this.next == null) {
            this.next = new NumberTree[16];
        }
        if (this.next[tempNumber] == null) {
            this.next[tempNumber] = new NumberTree();
        }
        this.next[tempNumber].addNumber(theNumber, theLevel + 1);
    }

    private void addNumber(char[] theNumber, int theLevel, int maxLevel) throws IllegalArgumentException {
        if (maxLevel == theLevel) {
            if (this.result) {
                throw new IllegalArgumentException("Number already exists: " + new String(theNumber));
            }
            this.result = true;
            return;
        }
        int tempNumber = NumberTree.convertDigit(theNumber[theLevel]);
        if (this.next == null) {
            this.next = new NumberTree[16];
        }
        if (this.next[tempNumber] == null) {
            this.next[tempNumber] = new NumberTree();
        }
        this.next[tempNumber].addNumber(theNumber, theLevel + 1, maxLevel);
    }

    private void addNumberRange(String from, String to) throws IllegalArgumentException {
        char[] fromNumber;
        int fromLen = from.length();
        int toLen = to.length();
        char[] workingFromNumber = fromNumber = new char[toLen + 1];
        if (fromLen > toLen) {
            throw new IllegalArgumentException("The from number (\"" + from + "\") must be less than the to number (\"" + to + "\")");
        }
        from.getChars(0, fromLen, fromNumber, 0);
        if (fromLen < toLen) {
            int i;
            workingFromNumber = new char[toLen + 1];
            for (i = 0; i < toLen - fromLen; ++i) {
                workingFromNumber[i] = 48;
            }
            from.getChars(0, fromLen, workingFromNumber, i);
        }
        if (!this.isDigit(workingFromNumber, toLen) || !this.isDigit(to)) {
            throw new IllegalArgumentException("Invalid format of input, only digits are allowed in number range (\"" + new String(workingFromNumber, 0, toLen) + "-" + to + "\")");
        }
        if (NumberTree.compareCharArrayWithString(workingFromNumber, toLen, to) >= 0) {
            throw new IllegalArgumentException("The from number (\"" + from + "\") must be less than the to number (\"" + to + "\")");
        }
        int max = fromLen;
        int wmax = toLen;
        while (NumberTree.compareCharArrayWithString(workingFromNumber, wmax, to) < 0) {
            this.addNumber(fromNumber, 0, max);
            max = NumberTree.plusOneOnACharArray(fromNumber, max);
            if (workingFromNumber != fromNumber) {
                wmax = NumberTree.plusOneOnACharArray(workingFromNumber, wmax);
                continue;
            }
            if (wmax >= max) continue;
            wmax = max;
        }
        this.addNumber(to, 0);
    }

    public static int convertDigit(char theDigit) throws IllegalArgumentException {
        switch (theDigit) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Invalid format of input only digits are allowed");
    }

    public static int convertDigit(byte theDigit) throws IllegalArgumentException {
        if (theDigit == 42) {
            return 11;
        }
        if (theDigit == 35) {
            return 12;
        }
        if (theDigit >= 97) {
            return theDigit - 97 + 10;
        }
        if (theDigit >= 65) {
            return theDigit - 65 + 10;
        }
        return theDigit - 48;
    }

    public static boolean isxDigit(char theDigit) {
        return theDigit >= '0' && theDigit <= '9' || theDigit >= 'A' && theDigit <= 'F' || theDigit >= 'a' && theDigit <= 'f';
    }

    public static boolean isDigit(char theDigit) {
        return theDigit >= '0' && theDigit <= '9';
    }

    private boolean isDigit(String theNumber) {
        int len = theNumber.length();
        for (int i = 0; i < len; ++i) {
            if (NumberTree.isDigit(theNumber.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isDigit(char[] theNumber, int len) {
        for (int i = 0; i < len; ++i) {
            if (NumberTree.isDigit(theNumber[i])) continue;
            return false;
        }
        return true;
    }

    private static int compareCharArrayWithString(char[] left, int leftLen, String right) {
        int rightLen = right.length();
        int minLen = leftLen < rightLen ? leftLen : rightLen;
        for (int i = 0; i < minLen; ++i) {
            char lc = left[i];
            char rc = right.charAt(i);
            if (lc == rc) continue;
            return lc - rc;
        }
        return leftLen - rightLen;
    }

    private static int plusOneOnACharArray(char[] theNumber, int len) {
        char c;
        int i = len - 1;
        boolean stop = false;
        while (i != 0 && !stop) {
            c = theNumber[i];
            if (c != '9') {
                int n = i;
                theNumber[n] = (char)(theNumber[n] + '\u0001');
                stop = true;
                continue;
            }
            theNumber[i] = 48;
            --i;
        }
        if (i == 0) {
            c = theNumber[i];
            if (c == '9') {
                theNumber[i] = 48;
                System.arraycopy(theNumber, 0, theNumber, 1, len);
                theNumber[0] = 49;
                return len + 1;
            }
            int n = i;
            theNumber[n] = (char)(theNumber[n] + '\u0001');
        }
        return len;
    }

    public static class Cache {
        private static Map<NumberTree, NumberTree> treeCache = new TreeMap<NumberTree, NumberTree>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static NumberTree fetch(NumberTree wanted) {
            NumberTree res;
            Map<NumberTree, NumberTree> map = treeCache;
            synchronized (map) {
                res = treeCache.get(wanted);
                if (res == null) {
                    treeCache.put(wanted, wanted);
                    res = wanted;
                }
            }
            return res;
        }
    }
}

