/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.number;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.ShortVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ShortConditionProfile
extends AbstractConditionProfile {
    private static final String[] numericOperatorArr = new String[]{"=", ">", "<", ">=", "<="};
    private static final String[] tokenOperatorArr = new String[]{"=", "GT", "LT", "GTE", "LTE"};

    private String operatorToToken(String operator) {
        for (int i = 0; i < numericOperatorArr.length; ++i) {
            if (!numericOperatorArr[i].equals(operator)) continue;
            return tokenOperatorArr[i];
        }
        return operator;
    }

    private String tokenToOperator(String token) {
        for (int i = 0; i < tokenOperatorArr.length; ++i) {
            if (!tokenOperatorArr[i].equals(token)) continue;
            return numericOperatorArr[i];
        }
        return token;
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        short val = 0;
        l.add(new DropDownVariable("Operator", (Object)numericOperatorArr[0], (Object[])numericOperatorArr));
        l.add(new ShortVariable("Value", val));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        String tagName = "ShortValue";
        String operator = numericOperatorArr[0];
        String val = "0";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            int bb;
            NodeList value;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase(tagName = this.getTagName(k))) {
                value = children.item(aa).getChildNodes();
                for (bb = 0; bb < value.getLength(); ++bb) {
                    String valueStr;
                    val = valueStr = value.item(bb).getNodeValue();
                }
                continue;
            }
            if (!k.equalsIgnoreCase("Operator")) continue;
            value = children.item(aa).getChildNodes();
            for (bb = 0; bb < value.getLength(); ++bb) {
                String token = value.item(bb).getNodeValue();
                operator = this.tokenToOperator(token);
            }
        }
        l.add(new DropDownVariable("Operator", (Object)operator, (Object[])numericOperatorArr));
        l.add(new ShortVariable("Value", val));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String operator = VarListUtil.getValueStringForName(variables, "Operator");
        String value = VarListUtil.getValueStringForName(variables, "Value");
        String token = this.operatorToToken(operator);
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Operator>" + token + "</Operator>");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<ShortValue>" + value + "</" + "ShortValue" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String data = VarListUtil.getValueStringForName(variables, "Operator");
        data = data + VarListUtil.getValueStringForName(variables, "Value");
        String info = "<b>" + this.getDescription(variables) + "</b> (" + GuiUtil.replaceSubString(data, "<", "&lt;") + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    private String getTagName(String fieldsName) {
        String tagName = "ShortValue";
        return tagName;
    }
}

