/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere;

import ericsson.ere.RatingDataField;
import ericsson.ere.RatingDataInterface;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.exception.RatingException;
import ericsson.ere.interfaces.TariffStructure;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import ericsson.ere.trace.RatingTraceInterface;
import ericsson.ere.util.UDate;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

@Deprecated
public class RatingData
implements RatingDataInterface {
    private String myServiceName = null;
    private Service myService = null;
    private EreManager myManager;
    private DoubleValue myDouble = new DoubleValue(0.0);
    private LongValue myLong = new LongValue();
    public int skipTimeCharging = 0;
    public long currentMaxDuration = 0L;
    public long timeLeft = 0L;
    public long currentDuration = 0L;
    public long currentStartTime = 0L;
    public long accumulatedDuration = 0L;
    public long maxDuration = 0L;
    public long startTime = 0L;
    public Calendar currentStartDate;
    public double currentDiscount = 1.0;
    public double moneyLeft = 0.0;
    public double totalCost = 0.0;
    public double maxCost = 0.0;
    public boolean hasRated = false;
    public Map addedFields = new HashMap();
    public Map myTagNumberLookup = new HashMap();
    private Map<Object, Object> myFieldsByName = new HashMap<Object, Object>();
    public boolean mySupportTagNumbers = false;
    private boolean myUseTraceFlag = false;
    private boolean myUseDebugFlag = false;
    private String myTraceDestinationName = "";
    private RatingTraceInterface myTraceObject = null;
    private Map<String, RatingDataField> myWorkingParams = null;

    public RatingData() {
        this.myManager = new EreManager();
        this.currentStartDate = Calendar.getInstance();
    }

    public RatingData(String serviceName) {
        this.myManager = new EreManager();
        this.myServiceName = serviceName;
    }

    public RatingData(Service service) {
        this.myService = service;
    }

    private Service getService() {
        return this.myService != null ? this.myService : this.myManager.getService(this.myServiceName);
    }

    public String getTraceDestinationName() {
        return this.myTraceDestinationName;
    }

    public boolean useTrace() {
        return this.myUseTraceFlag;
    }

    public RatingTraceInterface getTrace() {
        return this.myTraceObject;
    }

    public boolean useDebug() {
        return this.myUseDebugFlag;
    }

    public void setTraceDestinationName(String traceDestinationName) {
        this.myTraceDestinationName = traceDestinationName;
    }

    public void setTrace(boolean onOffFlag) {
        this.myUseTraceFlag = onOffFlag;
    }

    public void setTrace(RatingTraceInterface trace) {
        this.myTraceObject = trace;
        this.myUseTraceFlag = trace != null;
    }

    public void setDebug(boolean onOffFlag) {
        this.myUseDebugFlag = onOffFlag;
    }

    public void reset() {
        this.skipTimeCharging = 0;
        this.currentMaxDuration = 0L;
        this.timeLeft = 0L;
        this.currentDuration = 0L;
        this.currentStartTime = 0L;
        this.accumulatedDuration = 0L;
        this.maxDuration = 0L;
        this.startTime = 0L;
        this.currentDiscount = 1.0;
        this.moneyLeft = 0.0;
        this.totalCost = 0.0;
        this.maxCost = 0.0;
        this.hasRated = false;
        this.myDouble.setValue(0.0);
        this.myLong.setValue(0L);
        Iterator<Object> resetIterator = this.myFieldsByName.values().iterator();
        RatingDataField field = null;
        while (resetIterator.hasNext()) {
            field = (RatingDataField)resetIterator.next();
            FieldDefinition definition = this.getService().getClassRepository().getFieldDefinitionByName(field.getName());
            if (!definition.hasDefaultValue()) continue;
            field.setDefault(definition.getDefaultValue(), definition.getSupportArray());
        }
        this.myUseTraceFlag = false;
        this.myTraceObject = null;
    }

    public String getGrantedTime() {
        return new Long(this.myLong.getValue() * 1000L).toString();
    }

    public String getCost() {
        return this.doubleToMonetaryUnits(this.totalCost, 3);
    }

    public void setFirstField(String key, Object value) {
        try {
            RatingDataField field = (RatingDataField)this.myFieldsByName.get(key);
            field.isResult(true);
            field.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void setField(String key, int index, Object value) {
        try {
            RatingDataField field = (RatingDataField)this.myFieldsByName.get(key);
            field.isResult(true);
            field.setValue(index, value);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void addField(String key, Object value) {
        try {
            RatingDataField field = (RatingDataField)this.myFieldsByName.get(key);
            field.isResult(true);
            field.addValue(value);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public double allocateCost(double theCost) {
        double returnCost = 0.0;
        this.totalCost += theCost;
        if (this.moneyLeft != -1.0) {
            this.moneyLeft -= theCost;
            if (this.moneyLeft < 0.0 && this.moneyLeft > -1.0E-7) {
                this.moneyLeft = 0.0;
            }
        }
        returnCost = theCost;
        if (this.useTrace()) {
            this.myTraceObject.println("\tALLOCATE COST moneyLeft(" + this.moneyLeft + ") theCost(" + theCost + ")) totalCost(" + this.totalCost + ")");
        }
        return returnCost;
    }

    public long allocateTime(long theTime) {
        long returnTime = 0L;
        if (theTime == 0L) {
            this.timeLeft = 0L;
        } else {
            this.timeLeft -= theTime;
            if (this.timeLeft < 0L) {
                this.timeLeft = 0L;
            }
        }
        returnTime = theTime;
        this.currentDuration += theTime;
        this.currentStartTime += theTime;
        if (this.currentStartTime > 86399L) {
            this.currentStartTime -= 86400L;
            this.currentStartDate.add(5, 1);
        }
        if (this.useTrace()) {
            this.myTraceObject.println("\tALLOCATE TIME timeLeft(" + this.timeLeft + ") currentDuration(" + this.currentDuration + ") theTime(" + theTime + ")");
        }
        return returnTime;
    }

    public void setCurrentMaxDuration(long theNewMaxDuration) {
        if (this.currentMaxDuration > theNewMaxDuration) {
            this.currentMaxDuration = theNewMaxDuration;
        }
        if (this.currentMaxDuration > this.timeLeft) {
            this.currentMaxDuration = this.timeLeft;
        }
    }

    public void initWorkingParameters(long theCurrentDuration, long theCurrentMaxDuration, long theCurrentStartTime, double theCurrentMaxCost) {
        this.hasRated = false;
        this.currentDuration = theCurrentDuration;
        this.timeLeft = this.currentMaxDuration = theCurrentMaxDuration;
        this.moneyLeft = theCurrentMaxCost;
        Date theDate = new Date();
        theDate.setTime(theCurrentStartTime);
        this.currentStartDate.setTime(theDate);
        this.currentStartTime = UDate.getTimeOfDayInSeconds(this.currentStartDate);
        if (this.useTrace()) {
            this.myTraceObject.println("START PARAMETERS Duration: " + this.timeLeft + " Money: " + this.moneyLeft + " Start: " + DateUtil.format(this.currentStartDate));
        }
    }

    @Override
    public Map<Object, Object> getDetailedInfo() {
        return this.myFieldsByName;
    }

    @Override
    public Map<?, ?> getUsedValues() {
        return this.addedFields;
    }

    public Object getValueObject(String key) {
        RatingDataField field = (RatingDataField)this.myFieldsByName.get(key);
        field.isUsed(true);
        return field.getFirstValue();
    }

    public Object getValueObject(int index, String key) {
        RatingDataField field = (RatingDataField)this.myFieldsByName.get(key);
        field.isUsed(true);
        return field.getValue(index);
    }

    public Object[] getObjectArray(String key) {
        RatingDataField field = (RatingDataField)this.myFieldsByName.get(key);
        field.isUsed(true);
        return field.getObjectArray();
    }

    @Override
    public Map<Object, Object> getValues() {
        return this.myFieldsByName;
    }

    public void put(String name, RatingDataField field) {
        this.myFieldsByName.put(name, field);
    }

    public void remove(String name) {
        RatingDataField field = (RatingDataField)this.myFieldsByName.remove(name);
        if (field != null) {
            // empty if block
        }
    }

    public boolean containsKey(String name) {
        return this.myFieldsByName.containsKey(name);
    }

    public int rate(ServiceProvider provider, RatingPlan ratingPlan, String dateStr, String theMaxTime, String theMaxCost) throws Exception {
        if (this.useDebug()) {
            System.out.println("Rate Called ...");
            System.out.println("provider " + provider);
            System.out.println("ratingplan " + ratingPlan);
            System.out.println("dateStr " + dateStr);
            System.out.println("maxTime " + theMaxTime);
            System.out.println("maxCost " + theMaxCost);
        }
        this.maxDuration = Long.parseLong(theMaxTime) / 1000L;
        this.maxCost = EreDefs.monetaryUnitStringToDouble(theMaxCost);
        if (provider == null) {
            throw new RatingException(9, EreDefs.getErrorString("error.noProviderFound"));
        }
        if (ratingPlan == null) {
            throw new RatingException(8, EreDefs.getErrorString("error.noPlanFound"));
        }
        this.currentStartDate = DateUtil.parse(dateStr);
        this.startTime = this.currentStartDate.getTime().getTime();
        if (this.useDebug()) {
            System.out.println("currentStartDate = " + dateStr);
        }
        RatingPeriod period = ratingPlan.getActualRatingPeriod(this.currentStartDate);
        TariffStructure structure = period.getTariffStructure();
        if (this.useDebug()) {
            System.out.println("Data before invoking rate method ...");
            System.out.println("RatingData.owner         " + provider);
            System.out.println("RatingData.maxDuration   " + this.maxDuration);
            System.out.println("RatingData.maxCost       " + this.maxCost);
            System.out.println("dateStr                  " + dateStr);
        }
        if (!period.isStarted()) {
            throw new RatingException(7, EreDefs.getErrorString("error.noPeriodStarted"));
        }
        this.printRatingInfo(period);
        this.printAllData();
        try {
            structure.rate(this, this.myDouble, this.myLong);
        }
        catch (RatingException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RatingException(0, e.getMessage(), e);
        }
        this.printUsedAndResultData();
        return 0;
    }

    @Override
    public int setValues(String name, String type, String[] values) {
        RatingDataField field = (RatingDataField)this.myFieldsByName.get(name);
        field.setValues(type, values);
        return 0;
    }

    public int setValues(int tagNumber, int type, Object[] values) {
        RatingDataField field = (RatingDataField)this.myTagNumberLookup.get(new Integer(tagNumber));
        field.setValues(type, values);
        return 9;
    }

    public void putWorkingParameter(String key, RatingDataField field) {
        if (this.myWorkingParams == null) {
            this.myWorkingParams = new HashMap<String, RatingDataField>();
        }
        this.myWorkingParams.put(key, field);
    }

    public RatingDataField getWorkingParameter(String key) {
        if (this.myWorkingParams == null) {
            return null;
        }
        return this.myWorkingParams.get(key);
    }

    public void setWorkingParameter(String key, RatingDataField param) {
        this.myWorkingParams.put(key, param);
    }

    public int getWorkingInt(String key) {
        RatingDataField f = this.myWorkingParams.get(key);
        Integer i = (Integer)f.getFirstValue();
        return i;
    }

    public void setWorkingInt(String key, int val) {
        RatingDataField f = this.myWorkingParams.get(key);
        f.setValue(new Integer(val));
    }

    public short getWorkingShort(String key) {
        RatingDataField f = this.myWorkingParams.get(key);
        Short i = (Short)f.getFirstValue();
        return i;
    }

    public void setWorkingShort(String key, short val) {
        RatingDataField f = this.myWorkingParams.get(key);
        f.setValue(new Short(val));
    }

    public long getWorkingLong(String key) {
        RatingDataField f = this.myWorkingParams.get(key);
        Long i = (Long)f.getFirstValue();
        return i;
    }

    public void setWorkingLong(String key, long val) {
        RatingDataField f = this.myWorkingParams.get(key);
        f.setValue(new Long(val));
    }

    public double getWorkingDouble(String key) {
        RatingDataField f = this.myWorkingParams.get(key);
        Double i = (Double)f.getFirstValue();
        return i;
    }

    public void setWorkingDouble(String key, double val) {
        RatingDataField f = this.myWorkingParams.get(key);
        f.setValue(new Double(val));
    }

    public RatingDataField getRatingDataFieldByTag(int tagNumber) {
        return (RatingDataField)this.myTagNumberLookup.get(new Integer(tagNumber));
    }

    public RatingDataField getRatingDataFieldByName(String name) {
        return (RatingDataField)this.myFieldsByName.get(name);
    }

    public void printAllData() {
        if (this.useTrace()) {
            int maxLabelLength = 0;
            TreeMap<String, StringBuffer> m = new TreeMap<String, StringBuffer>();
            maxLabelLength = this.preparePrintResultData(m, true);
            this.myTraceObject.println("Print out of Rating data : ");
            this.printRatingData(maxLabelLength, m);
            this.myTraceObject.println("");
        }
    }

    public void printRatingInfo(RatingPeriod aPeriod) {
        if (this.useTrace()) {
            this.myTraceObject.println("Service:            " + aPeriod.getServiceId());
            this.myTraceObject.println("Service provider:   " + aPeriod.getServiceProviderName());
            this.myTraceObject.println("Rating plan:        " + aPeriod.getRatingPlanId());
            this.myTraceObject.println("Rating period:      " + aPeriod.getName());
            this.myTraceObject.println("Rating period file: " + aPeriod.getFileName());
            this.myTraceObject.println("Period start time:  " + aPeriod.getStartTime().getTime());
            this.myTraceObject.println("Current time:       " + this.currentStartDate.getTime());
            this.myTraceObject.println("");
        }
    }

    public void printUsedAndResultData() {
        if (this.useTrace()) {
            int maxLabelLength = 0;
            TreeMap<String, StringBuffer> m = new TreeMap<String, StringBuffer>();
            maxLabelLength = this.preparePrintResultData(m, false);
            this.myTraceObject.println("Print out of Result & Used Rating data : ");
            this.printRatingData(maxLabelLength, m);
            this.myTraceObject.println("");
        }
    }

    private int preparePrintResultData(SortedMap<String, StringBuffer> m, boolean printAll) {
        Iterator<Object> keys = this.myFieldsByName.keySet().iterator();
        String[] values = null;
        int maxLabelLength = 0;
        while (keys.hasNext()) {
            RatingDataField currentField;
            Object o = this.myFieldsByName.get(keys.next());
            if (!(o instanceof RatingDataField) || !(currentField = (RatingDataField)o).isUsed() && !currentField.isResult() && !printAll) continue;
            values = currentField.getValueArray();
            String valueStr = "";
            for (int ii = 0; ii < values.length; ++ii) {
                valueStr = valueStr + values[ii] + "\t";
            }
            if (this.getService().getClassRepository().getFieldDefinitionByName(currentField.getName()).getParameterType().equalsIgnoreCase("VARIABLE") && printAll) {
                valueStr = valueStr + "[VARIABLE]";
            }
            String label = "[" + currentField.getTagNumber() + "]-" + currentField.getName() + " ";
            StringBuffer rowData = new StringBuffer();
            if (!printAll) {
                if (currentField.isUsed() && currentField.isResult()) {
                    rowData.append("(U,R)\t");
                } else if (currentField.isUsed()) {
                    rowData.append("(U)\t");
                } else if (currentField.isResult()) {
                    rowData.append("(R)\t");
                }
            }
            rowData.append(valueStr);
            maxLabelLength = Math.max(maxLabelLength, label.length());
            m.put(label, rowData);
        }
        return maxLabelLength;
    }

    private void printRatingData(int maxLabelLength, SortedMap<String, StringBuffer> m) {
        Iterator<String> labelIterator = m.keySet().iterator();
        String pad = "";
        while (labelIterator.hasNext()) {
            pad = "";
            String label = labelIterator.next();
            for (int aa = 0; aa < maxLabelLength - label.length(); ++aa) {
                pad = pad + " ";
            }
            this.myTraceObject.println(label + pad + "\t" + m.get(label));
        }
    }

    public String doubleToMonetaryUnits(double value, int exp) {
        int result = 1;
        for (int ii = 0; ii < exp; ++ii) {
            result *= 10;
        }
        BigDecimal big = new BigDecimal(value);
        big = big.setScale(exp, 4).multiply(new BigDecimal(result)).setScale(0);
        return big + ":" + exp + ":1";
    }

    public Enumeration<?> keys() {
        return new Enumerated(this.myFieldsByName.keySet().iterator());
    }

    public Object get(Object key) {
        return this.myFieldsByName.get(key);
    }

    public void put(Object key, Object value) {
        this.myFieldsByName.put(key, value);
    }

    public Set<Object> keySet() {
        return this.myFieldsByName.keySet();
    }

    class Enumerated
    implements Enumeration<Object> {
        Iterator<Object> myIterator;

        public Enumerated(Iterator<Object> iterator) {
            this.myIterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.myIterator.hasNext();
        }

        @Override
        public Object nextElement() {
            return this.myIterator.next();
        }
    }
}

