/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils;

import com.ericsson.utils.LazyLoadListLoader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LazyLoadList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> mWrappedList;
    private transient LazyLoadListLoader<T, ?, ?> mLazyLoadListLoader;
    private final Lock mLoadLock = new ReentrantLock();

    public LazyLoadList(LazyLoadListLoader<T, ?, ?> lazyLoadListLoader) {
        this.mLazyLoadListLoader = lazyLoadListLoader;
    }

    public void setLazyLoadListLoader(LazyLoadListLoader<T, ?, ?> lazyLoadListLoader) {
        this.mLazyLoadListLoader = lazyLoadListLoader;
    }

    private void load() {
        if (this.mWrappedList == null) {
            try {
                this.mLoadLock.lock();
                if (this.mWrappedList == null) {
                    this.mWrappedList = this.mLazyLoadListLoader.load();
                }
            }
            finally {
                this.mLoadLock.unlock();
            }
        }
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        this.load();
        return this.mWrappedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.load();
        return this.mWrappedList.containsAll(c);
    }

    @Override
    public T get(int index) {
        this.load();
        return this.mWrappedList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.load();
        return this.mWrappedList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        this.load();
        return this.mWrappedList.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        this.load();
        return this.mWrappedList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        this.load();
        return this.mWrappedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        this.load();
        return this.mWrappedList.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.load();
        return this.mWrappedList.listIterator(index);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.load();
        return this.mWrappedList.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.load();
        return this.mWrappedList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        this.load();
        return this.mWrappedList.toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        this.load();
        return this.mWrappedList.toArray(a);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.load();
        out.defaultWriteObject();
    }
}

