/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.console;

import com.ericsson.lwac.statistics.StatisticsName;
import com.ericsson.lwac.utilities.console.Column;
import com.ericsson.lwac.utilities.console.Row;
import com.ericsson.lwac.utilities.console.TablePrinter;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public final class TreeTable {
    private final List<Column> columns;
    private final ImmutableList.Builder<Row> rows = ImmutableList.builder();
    private final Deque<Row.Builder> row = new ArrayDeque<Row.Builder>();

    private TreeTable(List<Column> columns) {
        this.columns = columns;
    }

    List<Column> getColumns() {
        return this.columns;
    }

    List<Row> getRows() {
        return this.rows.build();
    }

    public TreeTable beginRow() {
        this.row.push(Row.builder());
        return this;
    }

    public TreeTable endRow() {
        if (this.row.isEmpty()) {
            throw new IllegalStateException("There are no active rows that can be finalized");
        }
        Row.Builder rowBuilder = this.row.pop();
        if (this.row.isEmpty()) {
            this.rows.add((Object)rowBuilder.build());
        } else {
            this.row.peek().add(rowBuilder.build());
        }
        return this;
    }

    public TreeTable column(String name, String value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(String name, boolean value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(String name, int value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(String name, long value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(String name, double value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(String name, float value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(String name, LocalDateTime value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(String name, LocalDate value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(String name, Enum<?> value) {
        return this.column(StatisticsName.fromString(name), (Object)value);
    }

    public TreeTable column(String name, Duration value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public <T> TreeTable column(String name, T value) {
        return this.column(StatisticsName.fromString(name), value);
    }

    public TreeTable column(StatisticsName name, String value) {
        if (value != null) {
            this.row.peek().column(name, value);
        }
        return this;
    }

    public TreeTable column(StatisticsName name, boolean value) {
        return this.column(name, value ? "Y" : "N");
    }

    public TreeTable column(StatisticsName name, int value) {
        return this.column(name, String.valueOf(value));
    }

    public TreeTable column(StatisticsName name, long value) {
        return this.column(name, String.valueOf(value));
    }

    public TreeTable column(StatisticsName name, double value) {
        return this.column(name, String.format("%.3f", value));
    }

    public TreeTable column(StatisticsName name, float value) {
        return this.column(name, String.format("%.3f", Float.valueOf(value)));
    }

    public TreeTable column(StatisticsName name, LocalDateTime value) {
        if (value != null) {
            return this.column(name, DateTimeFormatter.ISO_DATE_TIME.format(value));
        }
        return this;
    }

    public TreeTable column(StatisticsName name, LocalDate value) {
        if (value != null) {
            return this.column(name, DateTimeFormatter.ISO_DATE.format(value));
        }
        return this;
    }

    public TreeTable column(StatisticsName name, Enum<?> value) {
        if (value != null) {
            return this.column(name, value.name().toLowerCase().replace('_', ' '));
        }
        return this;
    }

    public TreeTable column(StatisticsName name, Duration value) {
        if (value != null) {
            if (value.toMillis() >= 86400000L) {
                return this.column(name, value.toDays() + "d");
            }
            if (value.toMillis() >= 3600000L) {
                return this.column(name, value.toHours() + "h");
            }
            if (value.toMillis() >= 60000L) {
                return this.column(name, value.toMinutes() + "m");
            }
            return this.column(name, value.getSeconds() + "s");
        }
        return this;
    }

    public <T> TreeTable column(StatisticsName name, T value) {
        if (value != null) {
            return this.column(name, value.toString());
        }
        return this;
    }

    public TreeTable columns(Map<StatisticsName, String> values) {
        if (values != null) {
            for (Map.Entry<StatisticsName, String> value : values.entrySet()) {
                this.column(value.getKey(), value.getValue());
            }
        }
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.printTable();
    }

    public String printTable() {
        return this.printTable(false);
    }

    public String printTable(boolean colorize) {
        return TablePrinter.builder(this).colorize(colorize).build().print();
    }

    public TablePrinter.Builder printTableWithProperties() {
        return TablePrinter.builder(this);
    }

    public static final class Builder {
        private final ImmutableList.Builder<Column> columns = new ImmutableList.Builder();

        public Builder column(String name, ColumnAlignment alignment) {
            return this.column(StatisticsName.fromString(name), alignment);
        }

        public Builder column(String name) {
            return this.column(StatisticsName.fromString(name));
        }

        public Builder column(StatisticsName name, ColumnAlignment alignment) {
            this.columns.add((Object)new Column(name, alignment));
            return this;
        }

        public Builder column(StatisticsName name) {
            this.columns.add((Object)new Column(name, ColumnAlignment.AUTO));
            return this;
        }

        public Builder columns(Iterable<StatisticsName> names) {
            for (StatisticsName name : names) {
                this.column(name);
            }
            return this;
        }

        public TreeTable build() {
            return new TreeTable((List<Column>)((Object)this.columns.build()));
        }
    }

    public static enum ColumnAlignment {
        RIGHT,
        LEFT,
        AUTO;

    }
}

