/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import com.ericsson.lwac.utilities.ObjectCreateException;
import com.ericsson.lwac.utilities.ObjectDestroyException;
import com.ericsson.lwac.utilities.ObjectFactory;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectPool<T> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectPool.class);
    private final ObjectFactory<T> objectFactory;
    private final BlockingQueue<T> pool = new LinkedBlockingQueue<T>();
    private final Set<T> sustainedPool = new CopyOnWriteArraySet<T>();
    private Semaphore temporaryCounter;
    private final int initialSize;
    private int sustainedSize = 0;
    private int maxSize = 0;
    private int maxWaitTime = 1000;
    private final ReadWriteLock modificationLock = new ReentrantReadWriteLock();

    public ObjectPool(ObjectFactory<T> objectFactory, int initialSize, int sustainedSize, int maxSize) throws ObjectCreateException {
        this.objectFactory = objectFactory;
        this.maxSize = maxSize;
        this.sustainedSize = sustainedSize;
        this.initialSize = initialSize;
        this.init();
    }

    private void init() throws ObjectCreateException {
        this.setMaxSize(this.maxSize);
        this.setSustainedSize(this.sustainedSize);
        for (int i = 0; i < this.initialSize; ++i) {
            T object = this.objectFactory.create();
            this.pool.add(object);
            this.sustainedPool.add(object);
        }
    }

    public T poll() {
        return this.poll(this.maxWaitTime, TimeUnit.MILLISECONDS);
    }

    public T poll(ProgressListener progressListener) {
        return this.poll(this.maxWaitTime, TimeUnit.MILLISECONDS, progressListener);
    }

    public T poll(int timeOut, TimeUnit timeUnit) {
        return this.poll(timeOut, timeUnit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll(int timeOut, TimeUnit timeUnit, ProgressListener progressListener) {
        try {
            this.modificationLock.readLock().lock();
            Object object = this.pool.poll();
            if (object == null) {
                block22: {
                    try {
                        if (this.sustainedPool.size() >= this.sustainedSize) break block22;
                        this.modificationLock.readLock().unlock();
                        this.modificationLock.writeLock().lock();
                        try {
                            if (this.sustainedPool.size() < this.sustainedSize) {
                                object = this.objectFactory.create();
                                this.sustainedPool.add(object);
                            }
                        }
                        finally {
                            this.modificationLock.readLock().lock();
                            this.modificationLock.writeLock().unlock();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error while creating pooled object, {}", (Object)e.toString());
                        logger.debug(e.getMessage(), e);
                        T t = null;
                        this.modificationLock.readLock().unlock();
                        return t;
                    }
                }
                if (object == null) {
                    try {
                        boolean create = false;
                        if (this.temporaryCounter.tryAcquire()) {
                            if (progressListener != null) {
                                progressListener.onSustainedNotAvailable();
                            }
                            create = true;
                        } else if (this.temporaryCounter.tryAcquire(timeOut, timeUnit)) {
                            if (progressListener != null) {
                                progressListener.onMaximumReached();
                            }
                            create = true;
                        }
                        if (create) {
                            try {
                                object = this.objectFactory.create();
                            }
                            catch (Exception e) {
                                logger.error("Error while creating pooled object, {}", (Object)e.toString());
                                logger.debug(e.getMessage(), e);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            Object e = object;
            return (T)e;
        }
        finally {
            this.modificationLock.readLock().unlock();
        }
    }

    public T take() throws InterruptedException {
        T object;
        try {
            this.modificationLock.readLock().lock();
            object = this.pool.take();
        }
        finally {
            this.modificationLock.readLock().unlock();
        }
        return object;
    }

    public void returnObject(T object) {
        try {
            this.modificationLock.readLock().lock();
            if (this.sustainedPool.contains(object)) {
                this.pool.add(object);
            } else {
                try {
                    this.objectFactory.destroy(object);
                    this.temporaryCounter.release();
                }
                catch (Exception ex) {
                    logger.error("Error while destroying pooled object, {}", (Object)ex.toString());
                    logger.debug(ex.getMessage(), ex);
                }
            }
        }
        finally {
            this.modificationLock.readLock().unlock();
        }
    }

    public void returnObject(T object, boolean failed) {
        Objects.requireNonNull(object);
        if (failed) {
            if (this.sustainedPool.contains(object)) {
                try {
                    this.modificationLock.writeLock().lock();
                    this.sustainedPool.remove(object);
                }
                finally {
                    this.modificationLock.writeLock().unlock();
                }
            } else {
                this.temporaryCounter.release();
            }
        } else {
            this.returnObject(object);
        }
    }

    public int getAvailableSustained() {
        return this.pool.size();
    }

    public int getAvailbleTemporary() {
        return this.temporaryCounter.availablePermits();
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getSustainedSize() {
        return this.sustainedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSustainedSize(int sustainedSize) {
        try {
            this.modificationLock.writeLock().lock();
            if (this.maxSize < sustainedSize) {
                throw new IllegalArgumentException(String.format("Pool sustained size can not be larger than max size (%d < %d)", this.maxSize, this.sustainedSize));
            }
            if (this.sustainedSize > sustainedSize) {
                for (int i = this.sustainedSize; i > sustainedSize; --i) {
                    Object object = this.pool.poll();
                    this.sustainedPool.remove(object);
                    try {
                        this.objectFactory.destroy(object);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error("Error while creating pooled object, {}", (Object)ex.toString());
                        logger.debug(ex.getMessage(), ex);
                    }
                }
            }
            this.sustainedSize = sustainedSize;
            this.temporaryCounter = new Semaphore(this.maxSize - this.sustainedSize);
        }
        finally {
            this.modificationLock.writeLock().unlock();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        try {
            this.modificationLock.writeLock().lock();
            if (maxSize < this.sustainedSize) {
                throw new IllegalArgumentException(String.format("Pool max size can not be less than sustained size (%d < %d)", this.maxSize, this.sustainedSize));
            }
            this.maxSize = maxSize;
            this.temporaryCounter = new Semaphore(this.maxSize - this.sustainedSize);
        }
        finally {
            this.modificationLock.writeLock().unlock();
        }
    }

    public void recreate() throws ObjectCreateException, ObjectDestroyException {
        try {
            this.modificationLock.writeLock().lock();
            this.destroy0();
            this.init();
        }
        finally {
            this.modificationLock.writeLock().unlock();
        }
    }

    public void destroy() throws Exception {
        try {
            this.modificationLock.writeLock().lock();
            this.destroy0();
        }
        finally {
            this.modificationLock.writeLock().unlock();
        }
    }

    private void destroy0() throws ObjectDestroyException {
        for (T object : this.sustainedPool) {
            this.objectFactory.destroy(object);
        }
        this.pool.clear();
        this.sustainedPool.clear();
    }

    public static interface ProgressListener {
        public void onSustainedNotAvailable();

        public void onMaximumReached();
    }
}

