/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

public final class MemoryUtils {
    private static final String[] mUnits = new String[]{"b", "kb", "mb", "gb"};

    private MemoryUtils() {
    }

    public static String toNormalizedString(long memory) {
        for (int i = mUnits.length - 1; i >= 0; --i) {
            if (!((double)memory / Math.pow(1024.0, i) >= 10.0)) continue;
            return (int)((double)memory / Math.pow(1024.0, i) * 100.0) / 100 + mUnits[i];
        }
        return "-";
    }

    public static long toBytes(String value) {
        for (int i = mUnits.length - 1; i >= 0; --i) {
            int idx = value.indexOf(mUnits[i]);
            if (idx == -1) continue;
            long v = Long.parseLong(value.substring(0, idx));
            return (long)((double)v * Math.pow(1024.0, i));
        }
        return 0L;
    }
}

