/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import com.ericsson.lwac.utilities.FileWatcherListener;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FileWatcher.class);
    private final List<Path> directories;
    private final List<Pattern> fileNamePatterns;
    private final FileWatcherListener listener;
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> future;
    private final Map<Path, Long> currentState = new ConcurrentHashMap<Path, Long>();

    public FileWatcher(List<Path> directories, List<Pattern> fileNamePatterns, FileWatcherListener listener) {
        this.directories = directories.stream().distinct().collect(Collectors.toList());
        this.fileNamePatterns = new LinkedList<Pattern>(fileNamePatterns);
        this.listener = listener;
    }

    public void start() throws IOException {
        if (this.future == null || this.future.isDone()) {
            this.stop();
            this.currentState.putAll(this.scanDirectories());
            this.future = this.scheduledExecutor.scheduleWithFixedDelay(this, 100L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    private Map<Path, Long> scanDirectories() {
        return this.directories.stream().flatMap(this.listFiles()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> FileWatcher.fileNameMatchesAnyPattern(p.getFileName().toString(), this.fileNamePatterns)).collect(Collectors.toMap(p -> p, this.getLastModifiedTime()));
    }

    private Function<Path, Long> getLastModifiedTime() {
        return p -> {
            try {
                return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private Function<Path, Stream<? extends Path>> listFiles() {
        return d -> {
            try {
                return Files.list(d);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.currentState.clear();
    }

    private static boolean fileNameMatchesAnyPattern(String fileName, List<Pattern> fileNameRegexes) {
        if (fileNameRegexes.isEmpty()) {
            return true;
        }
        return fileNameRegexes.stream().map(pattern -> pattern.matcher(fileName)).anyMatch(Matcher::matches);
    }

    @Override
    public void run() {
        try {
            Map<Path, Long> nextState = this.scanDirectories();
            HashSet<File> modified = new HashSet<File>();
            HashSet<File> deleted = new HashSet<File>();
            for (Map.Entry<Path, Long> entry : nextState.entrySet()) {
                Path path = entry.getKey();
                if (this.currentState.containsKey(path) && this.currentState.get(path) >= entry.getValue()) continue;
                modified.add(path.toFile());
            }
            for (Path path : this.currentState.keySet()) {
                if (nextState.containsKey(path)) continue;
                deleted.add(path.toFile());
            }
            if (!modified.isEmpty()) {
                this.listener.onFilesModified(modified);
            }
            if (!deleted.isEmpty()) {
                this.listener.onFilesDeleted(deleted);
            }
            this.currentState.clear();
            this.currentState.putAll(nextState);
        }
        catch (UncheckedIOException e) {
            logger.warn("Could not scan directories", e);
        }
    }
}

