/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemUtils {
    private static final int BUFFERSIZE = 16384;
    private static final Logger logger = LoggerFactory.getLogger(FileSystemUtils.class);

    private FileSystemUtils() {
    }

    public static void mkdirs(File file) throws IOException {
        logger.trace("Creating directory {}", (Object)file);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        if (!file.mkdirs()) {
            throw new IOException(String.format("Could not create %s", file.getAbsolutePath()));
        }
    }

    public static void delete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        logger.trace("Deleting file {}", (Object)file);
        if (file.isDirectory() && FileSystemUtils.isNotSymbolicLink(file)) {
            List<File> listFiles = FileSystemUtils.listFiles(file);
            for (File child : listFiles) {
                FileSystemUtils.delete(child);
            }
        }
        Files.deleteIfExists(Paths.get(file.getAbsolutePath(), new String[0]));
    }

    private static boolean isNotSymbolicLink(File file) {
        return !Files.isSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static void copy(File source, File target) throws IOException {
        logger.trace("Copying {} to {}", (Object)source, (Object)target);
        FileSystemUtils.copy(new FileInputStream(source), target);
    }

    public static void rename(File source, File target) throws IOException {
        logger.trace("Renaming {} to {}", (Object)source, (Object)target);
        FileSystemUtils.createTargetParentDirectory(target);
        if (!source.renameTo(target)) {
            throw new IOException(String.format("Can not rename %s to %s", source.getPath(), target.getPath()));
        }
    }

    public static void copy(InputStream inputStream, File target) throws IOException {
        FileSystemUtils.createTargetParentDirectory(target);
        try (FileOutputStream fos = new FileOutputStream(target);
             BufferedInputStream bis = new BufferedInputStream(inputStream);){
            int read;
            byte[] buffer = new byte[16384];
            do {
                if ((read = bis.read(buffer)) <= 0) continue;
                fos.write(buffer, 0, read);
            } while (read == 16384);
        }
    }

    private static void createTargetParentDirectory(File target) throws IOException {
        File parentDirectory = target.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists() && !parentDirectory.mkdirs()) {
            throw new IOException("Can not create directory " + target.getParent());
        }
    }

    public static List<File> listFiles(File directory, FileFilter filter) {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(filter);
        File[] files = directory.listFiles(filter);
        if (files != null) {
            return Arrays.asList(files);
        }
        return Collections.emptyList();
    }

    public static List<File> listFiles(File directory) {
        Objects.requireNonNull(directory);
        File[] files = directory.listFiles();
        if (files != null) {
            return Arrays.asList(files);
        }
        return Collections.emptyList();
    }

    public static boolean isDirectoryEmpty(File directory) {
        Objects.requireNonNull(directory);
        File[] objects = directory.listFiles();
        return objects != null && objects.length == 0;
    }
}

